/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.assignprocessorblade;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.controller.wizard.replication.remote.assignprocessorblade.SJctrAssignProcessorBladeConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoMPBladeInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;

public class SJctrAssignProcessorBladeDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831265;
    private static final String DISP_TITLE = "GUID_PROCESSOR_BLADE";
    private static final String KEY_PROCESSOR_BLADE_COMBOBOX = "COM_PROCESSOR_BLADE_COMBOBOX";
    private static final String KEY_JNL_INFO_LIST = "COM_JNL_INFO_LIST";
    public static final int MPB_FLAG = 0;
    public static final int SET_SPACE_INDEX = 0;
    protected static final String KEY_NO_SELECT = "-1";

    public SJctrAssignProcessorBladeDC() {
        super(17831265);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetAllDKCInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrComboBoxDataModel processorBladePulldown = new SJctrComboBoxDataModel();
        this.addDataObjectModel(KEY_PROCESSOR_BLADE_COMBOBOX, processorBladePulldown);
        processorBladePulldown.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> jnlInfoList = this.getProxy().getCache("KEY_SELECTED_JOURNAL");
        if (null == jnlInfoList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == jnlInfoList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorJnlGrp viewData = (SJmoUniversalReplicatorJnlGrp)jnlInfoList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkConstructData", "Information of selected Jnl is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoUniversalReplicatorJnlGrp> selectedJournalList = this.getProxy().getCache("KEY_SELECTED_JOURNAL");
            List<SJmoUniversalReplicatorJnlGrp> journalList = SJctrRemoteReplicationUtility.checkAndGetExistJournalInfo(selectedJournalList, jnlGrpMgr);
            int jnlType = SJctrRemoteReplicationUtility.checkJournalType(journalList);
            if (jnlType == -1) {
                this.logUty.putlog("checkConstructData", "Journal type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206011);
                SJcException exp = err.createException();
                throw exp;
            }
            this.putCache(KEY_JNL_INFO_LIST, journalList);
            SJctrComboBoxDataModel selectedProcessorBlade = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_PROCESSOR_BLADE_COMBOBOX);
            this.createMPBPull(selectedProcessorBlade, journalList);
            this.checkMPB(journalList, selectedProcessorBlade);
            this.getManageData().setData(KEY_PROCESSOR_BLADE_COMBOBOX, selectedProcessorBlade.getSelection());
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrAssignProcessorBladeConfirmData confirmData = new SJctrAssignProcessorBladeConfirmData();
            List<SJmoUniversalReplicatorJnlGrp> selectedJnlList = this.getCache(KEY_JNL_INFO_LIST);
            SJctrComboBoxDataModel processorBladePulldown = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_PROCESSOR_BLADE_COMBOBOX);
            try {
                int processorBlade = Integer.parseInt(processorBladePulldown.getSelection());
                for (int index = 0; index < selectedJnlList.size(); ++index) {
                    SJmoUniversalReplicatorJnlGrp jnlGrpInfo = (SJmoUniversalReplicatorJnlGrp)selectedJnlList.get(index);
                    jnlGrpInfo.setOwner((byte)processorBlade);
                }
                confirmData.setJnlGInfo(selectedJnlList);
            }
            catch (NumberFormatException e) {
                this.logUty.putlog("checkEndData", "The error occurred at the processorBlade getting. NumberFormatException : " + e.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            confirmData.setNeedData(this);
            ArrayList<SJctrAssignProcessorBladeConfirmData> confirmDataList = new ArrayList<SJctrAssignProcessorBladeConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAssignProcessorBladeConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107003);
        }
        return ret;
    }

    private void createMPBPull(SJctrComboBoxDataModel comboObj, List<SJmoUniversalReplicatorJnlGrp> journalList) {
        comboObj.addItem(String.valueOf(-1), " ");
        List<SJmoAllDKCInfo> allDKCInfoList = SJctrRemoteReplicationUtility.getSJmoAllDKCInfo(this);
        for (SJmoAllDKCInfo allDKCInfo : allDKCInfoList) {
            ArrayList<SJmoDKCInfo> dkcInfoList = allDKCInfo.getDKCInfo();
            for (SJmoDKCInfo dkcInfo : dkcInfoList) {
                ArrayList<SJmoMPBladeInfo> mpBladeInfoList = dkcInfo.getMPBladeInfo();
                for (SJmoMPBladeInfo mpBladeInfo : mpBladeInfoList) {
                    int iMpBladeId = mpBladeInfo.getMpBladeId();
                    String strMpBladeId = SJctrOwnerShipUtility.toMpBladeIdDisplay(this.getComUtility(), iMpBladeId);
                    comboObj.addItem(Integer.toString(iMpBladeId), strMpBladeId);
                }
            }
        }
    }

    private void checkMPB(List<SJmoUniversalReplicatorJnlGrp> journalList, SJctrComboBoxDataModel selectedProcessorBlade) {
        boolean flg = false;
        byte byOwnerBase = journalList.get(0).getOwner();
        for (SJmoUniversalReplicatorJnlGrp journalInfo : journalList) {
            byte byOwner = journalInfo.getOwner();
            if (byOwner == -1) {
                selectedProcessorBlade.setSelectedIndex(0);
                flg = true;
                break;
            }
            if (byOwnerBase == byOwner) continue;
            selectedProcessorBlade.setSelectedIndex(0);
            flg = true;
            break;
        }
        if (!flg) {
            selectedProcessorBlade.removeItem(KEY_NO_SELECT);
            selectedProcessorBlade.setSelection(Integer.toString(byOwnerBase));
        }
    }
}

