/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.changesettings;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreateRemotePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrBaseSecondaryVolumeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateTrueCopyPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;

public abstract class SJctrChangeSettingsBaseDC
extends SJctrDialogDataController {
    protected static final int DISP_ID = 33595490;
    protected static final String DISP_TITLE = "CHANGE_SETTING";
    protected boolean isLunDec = false;
    protected static final int SELECT_TOP_INDEX = 0;
    protected static final short FENCE_LEVEL_BIT_SET_SIZE = 3;
    protected static final int PAIR_INFO_INDEX_LDKC = 0;
    protected static final int PAIR_INFO_INDEX_CU = 1;
    protected static final int PAIR_INFO_INDEX_LDEV = 2;
    protected static final int PAIR_INFO_INDEX_PORT_ID = 3;
    protected static final int PAIR_INFO_INDEX_HG_ID = 4;
    protected static final int PAIR_INFO_INDEX_LUN_ID = 5;
    protected static final int PAIR_INFO_INDEX_PVOL_FENCE_LEVEL = 6;
    protected static final int PAIR_INFO_INDEX_INIT_COPY_TYPE = 7;
    protected static final int PAIR_INFO_INDEX_COPY_PACE = 8;
    protected static final int PAIR_INFO_INDEX_INIT_COPY_PRIORITY = 9;
    protected static final int PAIR_INFO_INDEX_CFW_DATA = 11;
    protected static final int PAIR_INFO_INDEX_DFW_TO_SVOL = 12;
    protected static final int PAIR_INFO_INDEX_HIO_TIME_STAMP_TRANS = 13;
    protected static final int PAIR_INFO_INDEX_ERROR_LEVEL = 14;
    protected static final int PAIR_INFO_INDEX_CFW = 15;
    protected static final int PAIR_INFO_INDEX_ALUA_MODE = 17;
    protected static final int PAIR_INFO_MAX_SET_NUM = 1;
    protected int copyType = -1;

    public SJctrChangeSettingsBaseDC(int copyType) throws SJcException {
        super(33595490);
        this.copyType = copyType;
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrSimpleDataModel viewInfo = new SJctrSimpleDataModel();
        this.addDataObjectModel("COM_VIEW_INFO", viewInfo);
        ((SJctrDataObject)viewInfo.getManageData()).setData("COM_COPY_TYPE", String.valueOf(this.copyType));
        this.setDataModel();
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    public void makeDataModelSuperClass() {
        super.makeDataModel();
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        try {
            SJbaseUserSessionInterface us = this.getOwner().getUserSession();
            this.isLunDec = SJctrRemoteReplicationUtility.isLunDec(us);
            SJctrSimpleDataModel viewInfo = (SJctrSimpleDataModel)this.getDataObjectModel("COM_VIEW_INFO");
            ((SJctrDataObject)viewInfo.getManageData()).setData("COM_LUN_ID_DEC", this.isLunDec);
            Map<Integer, Object> pairInfo = this.getDelegatePairInfo();
            int controllerId = -1;
            switch (this.copyType) {
                case 0: 
                case 1: {
                    List<SJctrCreateTrueCopyPairVolInfo> tcPairList = this.getTcPairInfo();
                    controllerId = tcPairList.get(0).getIPairControllerID();
                    break;
                }
                case 2: 
                case 3: {
                    List<SJctrCreateUniversalReplicatorPairVolInfo> urPairList = this.getUrPairInfo();
                    controllerId = urPairList.get(0).getModelId();
                    break;
                }
            }
            SJctrBaseSecondaryVolumeDataModel baseSvolModel = (SJctrBaseSecondaryVolumeDataModel)this.getDataObjectModel("COM_SVOL_SELECTION");
            Short cuNum = (Short)pairInfo.get(1);
            switch (this.copyType) {
                case 1: {
                    SJctrTextBoxDataModel cuTextModel = baseSvolModel.getCuTextModel();
                    if (null != cuNum) {
                        String cuStr = SJctrComUtility.toHexString(cuNum.shortValue(), 2, true);
                        cuTextModel.setValue(cuStr);
                    }
                    cuTextModel.setFixed(true);
                    break;
                }
                case 3: {
                    SJctrComboBoxDataModel cuListModel = baseSvolModel.getCuListModel();
                    baseSvolModel.updateRemoteCuPulldownModel(controllerId);
                    if (null != cuNum) {
                        cuListModel.setSelection(String.valueOf(cuNum));
                        break;
                    }
                    cuListModel.clearSelection();
                    break;
                }
            }
            SJctrComboBoxDataModel ldevListModel = baseSvolModel.getLdevModel();
            if (null != pairInfo.get(2)) {
                ldevListModel.setSelection(String.valueOf(pairInfo.get(2)));
            } else {
                ldevListModel.clearSelection();
            }
            baseSvolModel.makeRemotePortIdModel(controllerId);
            SJctrComboBoxDataModel portIdModel = baseSvolModel.getPortIdModel();
            if (null == pairInfo.get(3)) {
                portIdModel.clearSelection();
            } else {
                portIdModel.setSelection(String.valueOf(pairInfo.get(3)));
            }
            SJctrComboBoxDataModel remoteHgIdModel = baseSvolModel.getHgIdModel();
            if (null == pairInfo.get(4)) {
                remoteHgIdModel.clearSelection();
            } else {
                remoteHgIdModel.setSelection(String.valueOf(pairInfo.get(4)));
            }
            SJctrComboBoxDataModel remoteLunIdModel = baseSvolModel.getLunIdModel();
            if (null == pairInfo.get(5)) {
                remoteLunIdModel.clearSelection();
            } else {
                remoteLunIdModel.setSelection(String.valueOf(pairInfo.get(5)));
            }
            SJctrComboBoxDataModel intervalModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_INTERVAL_VALUE");
            SJctrCreateRemotePairUtility.initIntervalValueModel(intervalModel, this.copyType);
            SJctrCreateRemotePairUtility.initPvolFenceLevelModel(this, this.copyType);
            SJctrComboBoxDataModel pvolFenceLevelModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_PVOL_FENCE_LEVEL");
            if (null != pvolFenceLevelModel) {
                BitSet fence = (BitSet)pairInfo.get(6);
                BitSet levelNever = new BitSet(3);
                BitSet levelData = new BitSet(3);
                levelData.set(0);
                BitSet levelStatus = new BitSet(3);
                levelStatus.set(1);
                if (null != fence) {
                    if (fence.equals(levelNever)) {
                        pvolFenceLevelModel.setSelection(String.valueOf(0));
                    } else if (fence.equals(levelData)) {
                        pvolFenceLevelModel.setSelection(String.valueOf(1));
                    } else if (fence.equals(levelStatus)) {
                        pvolFenceLevelModel.setSelection(String.valueOf(2));
                    } else {
                        pvolFenceLevelModel.clearSelection();
                    }
                } else {
                    pvolFenceLevelModel.clearSelection();
                }
            }
            SJctrCreateRemotePairUtility.initInitCopyTypeModel(this, this.copyType, controllerId);
            SJctrComboBoxDataModel initCopyTypeModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE");
            if (null != initCopyTypeModel) {
                if (null != pairInfo.get(7)) {
                    initCopyTypeModel.setSelection(String.valueOf(pairInfo.get(7)));
                } else {
                    initCopyTypeModel.clearSelection();
                }
            }
            Integer copyPaceValue = (Integer)pairInfo.get(8);
            SJctrCreateRemotePairUtility.initCopyPaceTextBoxDataModel(this);
            if (null != copyPaceValue) {
                this.setTextBoxDefaultValue("COM_COPY_PACE_TXT", copyPaceValue & 0xFFFFFF7F);
            } else {
                this.setTextBoxDefaultValue("COM_COPY_PACE_TXT", "");
            }
            SJctrCreateRemotePairUtility.initCopyPacePllDownListDataModel(this);
            this.setPullDownListDefaultSelection("COM_COPY_PACE_LIST", copyPaceValue);
            SJctrCreateRemotePairUtility.initInitCopyPriorityModel(this);
            this.setTextBoxDefaultValue("COM_INITIAL_COPY_PRIORITY", pairInfo.get(9));
            SJctrCreateRemotePairUtility.initCfwDataModel(this);
            Boolean cfwDataSetting = (Boolean)pairInfo.get(11);
            Integer cfwDataKeyValue = null;
            if (null != cfwDataSetting) {
                cfwDataKeyValue = cfwDataSetting != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            this.setPullDownListDefaultSelection("COM_CFW_DATA", cfwDataKeyValue);
            SJctrCreateRemotePairUtility.initDfwToSvol(this);
            Boolean dfwToSvolSetting = (Boolean)pairInfo.get(12);
            Integer dfwToSvolKeyValue = null;
            if (null != dfwToSvolSetting) {
                dfwToSvolKeyValue = dfwToSvolSetting != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            this.setPullDownListDefaultSelection("COM_DFW_TO_SVOL", dfwToSvolKeyValue);
            SJctrCreateRemotePairUtility.initHioTimeStampTransferModel(this);
            SJctrRadioButtonGroupDataModel hioTsModel = (SJctrRadioButtonGroupDataModel)this.getDataObjectModel("COM_HIO_TIME_STAMP_TRANS");
            Boolean hioTsSetting = (Boolean)pairInfo.get(13);
            String hioTsKeyValue = null;
            if (null != hioTsSetting) {
                hioTsKeyValue = hioTsSetting != false ? "COM_ENABLE" : "COM_DISABLE";
                hioTsModel.setSelect(hioTsKeyValue);
            }
            SJctrCreateRemotePairUtility.initErrorLevelModel(this, this.copyType);
            SJctrComboBoxDataModel errorLevelModel = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_ERROR_LEVEL");
            if (null != errorLevelModel) {
                if (null != pairInfo.get(14)) {
                    errorLevelModel.setSelection(String.valueOf(pairInfo.get(14)));
                } else {
                    errorLevelModel.clearSelection();
                }
            }
            SJctrCreateRemotePairUtility.initCfwModel(this);
            this.setPullDownListDefaultSelection("COM_CFW", pairInfo.get(15));
        }
        catch (SJcException e) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
        }
    }

    private void setPullDownListDefaultSelection(String dataModelKey, Object defaultSettingKey) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel(dataModelKey);
        if (dataModel instanceof SJctrComboBoxDataModel) {
            SJctrComboBoxDataModel pullDown = (SJctrComboBoxDataModel)dataModel;
            if (null == defaultSettingKey) {
                pullDown.clearSelection();
            } else {
                pullDown.setSelection(defaultSettingKey.toString());
            }
        }
    }

    private void setTextBoxDefaultValue(String dataModelKey, Object defaultSettingKey) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel(dataModelKey);
        if (dataModel instanceof SJctrTextBoxDataModel) {
            SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)dataModel;
            if (null == defaultSettingKey) {
                textBox.setValue("");
            } else {
                textBox.setValue(defaultSettingKey.toString());
            }
        }
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> selectedPairsList = this.getProxy().getCache("KEY_SELECTED_PAIRS");
        if (null == selectedPairsList) {
            this.logUty.putlog("checkStartData", "Selected Pairs list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == selectedPairsList.size()) {
            this.logUty.putlog("checkStartData", "Size of Selected Pairs list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> usedSvolIndexList = this.getProxy().getCache("KEY_USED_SVOL_INDEX_LIST");
        if (null == usedSvolIndexList) {
            this.logUty.putlog("checkStartData", "Used S-VOL Index List list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<? extends SJmoReplicationPairVolInfo> pairList = this.getModifiedPairInfoList();
        switch (this.copyType) {
            case 2: 
            case 3: {
                this.checkInitCopyType();
                break;
            }
        }
        this.putCache("KEY_SELECTED_PAIRS", pairList);
        return ret;
    }

    private void checkInitCopyType() {
        SJmoUniversalReplicatorJnlGrpMgr jnlMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
        int initCopyType = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE"));
        List<SJctrCreateUniversalReplicatorPairVolInfo> urPairList = this.getUrPairInfo();
        for (SJctrCreateUniversalReplicatorPairVolInfo urPair : urPairList) {
            SJctrCreateRemotePairUtility.checkJnlStatus(jnlMgr, initCopyType, urPair.getMJnlGrpId(), urPair.getMirrorId());
        }
    }

    protected List<SJctrCreateTrueCopyPairVolInfo> getTcPairInfo() {
        List<SJctrCreateTrueCopyPairVolInfo> inheritedList = this.getProxy().getCache("KEY_SELECTED_PAIRS");
        return inheritedList;
    }

    protected List<SJctrCreateUniversalReplicatorPairVolInfo> getUrPairInfo() {
        List<SJctrCreateUniversalReplicatorPairVolInfo> inheritedList = this.getProxy().getCache("KEY_SELECTED_PAIRS");
        return inheritedList;
    }

    protected abstract void setDataModel();

    protected abstract Map<Integer, Object> getDelegatePairInfo();

    protected abstract List<? extends SJmoReplicationPairVolInfo> getModifiedPairInfoList();
}

