/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deletemirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.deletemirrors.SJctrDeleteMirrorsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.deletemirrors.SJctrDeleteMirrorsDataModel;
import sanproject.sn2.controller.wizard.replication.remote.deletemirrors.SJctrDeleteMirrorsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDeleteMirrorsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 18552129;
    private static final String DISP_TITLE = "DELETE_MIRROR";
    private static final String KEY_TABLE = "COM_DEL_MIRROR_TABLE";
    private static final String KEY_DELETE_MIRROR_MODEL = "COM_DEL_MIRROR_MODEL";
    private Map<String, Integer> pairPositionMap = new HashMap<String, Integer>();

    public SJctrDeleteMirrorsDC() {
        super(18552129);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrDeleteMirrorsTableModel());
        this.addDataObjectModel(KEY_DELETE_MIRROR_MODEL, new SJctrDeleteMirrorsDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.getTopWindow().getDisplayID() == 13314) {
            List<?> pairsList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            if (null == pairsList) {
                this.logUty.putlog("checkStartData", "Pairs list data is null.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
            if (0 == pairsList.size()) {
                this.logUty.putlog("checkStartData", "Size of pairs list data is zero.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            if (this.getTopWindow().getDisplayID() != 13314) {
                List<SJmoMirrorIndex> viewData = this.getProxy().getCache("KEY_SELECTED_MIRROR");
                List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(viewData, allJnlInfo);
                SJctrRemoteReplicationUtility.checkMirrorTypicalVolRs(this, mirrorExist);
                int jnlType = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorExist, allJnlInfo);
                if (jnlType == -1) {
                    this.logUty.putlog("checkConstructData", "Journal type is mixed.");
                    SJctrError err = new SJctrError(210, 22, 206010);
                    SJcException exp = err.createException();
                    throw exp;
                }
                boolean attribute = SJctrRemoteReplicationUtility.checkMirrorAttributeMaster(mirrorExist, false);
                if (!attribute) {
                    if (13314 == this.getTopWindow().getDisplayID()) {
                        this.logUty.putlog("constructConfirmData", "Contained invalid mirror attribute.(ErrorLevel5)");
                        SJctrError err = new SJctrError(210, 22, 206067);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                    this.logUty.putlog("constructConfirmData", "Contained invalid mirror attribute.(ErrorLevel4)");
                    SJctrError err = new SJctrError(210, 22, 206006);
                    SJcException exp = err.createException();
                    throw exp;
                }
                boolean st = SJctrRemoteReplicationUtility.checkDeleteMirrorStatus(mirrorExist);
                if (!st) {
                    if (13314 == this.getTopWindow().getDisplayID()) {
                        this.logUty.putlog("constructConfirmData", "Contained invaid Mirror Status.(ErrorLevel5)");
                        SJctrError err = new SJctrError(210, 22, 206050);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                    this.logUty.putlog("constructConfirmData", "Contained invaid Mirror Status.(ErrorLevel4)");
                    SJctrError err = new SJctrError(210, 22, 206015);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrDeleteMirrorsDataModel dataModel = (SJctrDeleteMirrorsDataModel)this.getDataObjectModel(KEY_DELETE_MIRROR_MODEL);
                dataModel.setJnlType(jnlType);
                boolean forceDel = this.judgeDeleteMode(mirrorExist.get(0));
                dataModel.setForceDeleteFlg(forceDel);
                SJctrDeleteMirrorsTableModel table = (SJctrDeleteMirrorsTableModel)this.getDataObjectModel(KEY_TABLE);
                table.setBasicDataList(mirrorExist);
            } else {
                List<SJmoUniversalReplicatorPairVolInfo> parisList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
                List<SJmoUniversalReplicatorPairVolInfo> pairExist = SJctrRemoteReplicationUtility.checkAndGetExistUrPairVolInfo(parisList, SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this));
                List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList = this.getMirrorListFromPair(pairExist, allJnlInfo);
                Collections.sort(mirrorList);
                int copyType = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(pairExist);
                if (copyType == -1) {
                    this.logUty.putlog("checkConstructData", "Copytype Of Pair is mixed.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206010);
                }
                SJctrDeleteMirrorsDataModel dataModel = (SJctrDeleteMirrorsDataModel)this.getDataObjectModel(KEY_DELETE_MIRROR_MODEL);
                dataModel.setJnlType(copyType);
                if (SJctrRemoteReplicationUtility.isInitialOfMirrorAttribute(mirrorList)) {
                    dataModel.setForceDeleteFlg(false);
                } else {
                    this.checkMirrorStateForURPair(mirrorList);
                    boolean forceDel = this.judgeDeleteMode(mirrorList.get(0));
                    dataModel.setForceDeleteFlg(forceDel);
                }
                SJctrDeleteMirrorsTableModel table = (SJctrDeleteMirrorsTableModel)this.getDataObjectModel(KEY_TABLE);
                table.setBasicDataList(mirrorList);
            }
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrDeleteMirrorsConfirmData confirmData = new SJctrDeleteMirrorsConfirmData();
            SJctrDeleteMirrorsTableModel table = (SJctrDeleteMirrorsTableModel)this.getDataObjectModel(KEY_TABLE);
            SJctrDeleteMirrorsDataModel dataModel = (SJctrDeleteMirrorsDataModel)this.getDataObjectModel(KEY_DELETE_MIRROR_MODEL);
            SJctrComboBoxDataModel delMode = (SJctrComboBoxDataModel)dataModel.getDataModel("COM_DELETE_MODE");
            int idelMode = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(delMode);
            List<Object> selectedList = table.getAllRowData();
            if (idelMode == 0) {
                SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
                SJctrResourceGroupUtility rsgUty = SJctrRemoteReplicationUtility.getSJctrResourceGroupUtility(this);
                SJctrRemoteReplicationUtility.checkMirrorPortRs(selectedList, mrcuMgr, rsgUty);
            }
            confirmData.setMirrorsInfo(selectedList);
            confirmData.setJnlType(dataModel.getJnlType());
            confirmData.setDeleteMode(idelMode);
            confirmData.setNeedData(this);
            confirmData.setPairPositionMap(this.pairPositionMap);
            ArrayList<SJctrDeleteMirrorsConfirmData> confirmDataList = new ArrayList<SJctrDeleteMirrorsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrDeleteMirrorsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private boolean judgeDeleteMode(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo) {
        int iStatus;
        boolean rtn = true;
        if (mirrorInfo.getDelta() == 0 && SJctrRemoteReplicationDataMacro.MIRROR_STAUTS_HALTING_STOPPING.contains(iStatus = mirrorInfo.getStatus())) {
            rtn = false;
        }
        return rtn;
    }

    private void checkMirrorStateForURPair(List<SJmoUniversalReplicatorJnlGrpMirror> mirrorList) {
        SJctrRemoteReplicationUtility.checkMirrorTypicalVolRs(this, mirrorList);
        boolean attribute = SJctrRemoteReplicationUtility.checkMirrorAttributeMaster(mirrorList, false);
        if (!attribute) {
            this.logUty.putlog("checkConstructData", "Contained invalid mirror attribute.(ErrorLevel5)");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206067);
        }
        boolean st = SJctrRemoteReplicationUtility.checkDeleteMirrorStatus(mirrorList);
        if (!st) {
            this.logUty.putlog("checkConstructData", "Contained invaid Mirror Status.(ErrorLevel5)");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206050);
        }
    }

    private void mergeMirrorInfoFromPair(SJmoUniversalReplicatorJnlGrpMirror mirrorInfo, SJmoUniversalReplicatorPairVolInfo pairInfo) {
        mirrorInfo.setIJnlGroupId(SJctrRemoteReplicationUtility.getJnlIdFromPair(pairInfo));
        mirrorInfo.setMirrorId(pairInfo.getMirrorId());
        mirrorInfo.setIMirrorId(pairInfo.getMirrorId());
        mirrorInfo.setAttribute(0);
        mirrorInfo.setStatus(0);
        mirrorInfo.setPairSN(pairInfo.getPairSN());
        mirrorInfo.setLdkc(pairInfo.getSLdkc());
        mirrorInfo.setModelId(pairInfo.getModelId());
        int localPairPos = SJctrRemoteReplicationUtility.getPairPos(pairInfo);
        int copyType = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVolInfo(pairInfo);
        SJmoLdevDetail ldev = SJctrRemoteReplicationUtility.getSJmoLdevDetailFromUrPairInfo(pairInfo);
        List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
        Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
        if (localPairPos == 0) {
            mirrorInfo.setPDataVol(SJctrRemoteReplicationUtility.getLuPathFromLdev(ldev, copyType, ldevLUPathMap));
            mirrorInfo.setSDataVol(pairInfo.getSVolLuPath());
        } else if (localPairPos == 1) {
            mirrorInfo.setPDataVol(pairInfo.getPVolLuPath());
            mirrorInfo.setSDataVol(SJctrRemoteReplicationUtility.getLuPathFromLdev(ldev, copyType, ldevLUPathMap));
        } else {
            SJctrLogUty.warn("SJctrDeleteMirrorsDC", "mergeMirrorInfoFromPair", "PairPosition is Invalid.");
        }
    }

    private List<SJmoUniversalReplicatorJnlGrpMirror> getMirrorListFromPair(List<SJmoUniversalReplicatorPairVolInfo> pairsList, SJmoUniversalReplicatorJnlGrpMgr allJnlInfo) {
        ArrayList<SJmoUniversalReplicatorJnlGrpMirror> retList = new ArrayList<SJmoUniversalReplicatorJnlGrpMirror>();
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairsList) {
            SJmoMirrorIndex mirrorIndex = SJctrRemoteReplicationUtility.getMirrorIndexFromPair(pairInfo);
            SJmoUniversalReplicatorJnlGrp jnlInfo = allJnlInfo.getJnlGroup(mirrorIndex.getIJnlGroupId());
            if (jnlInfo != null) {
                ArrayList<SJmoUniversalReplicatorJnlGrpMirror> mirrorList = jnlInfo.getMirrors();
                try {
                    SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = (SJmoUniversalReplicatorJnlGrpMirror)((SJmoUniversalReplicatorJnlGrpMirror)mirrorList.get(mirrorIndex.getIMirrorId())).clone();
                    if (Collections.binarySearch(retList, mirrorInfo) >= 0) continue;
                    if (mirrorInfo.getAttribute() == 0) {
                        this.mergeMirrorInfoFromPair(mirrorInfo, pairInfo);
                        this.pairPositionMap.put(mirrorInfo.getIndexKey(), SJctrRemoteReplicationUtility.getPairPos(pairInfo));
                    }
                    retList.add(mirrorInfo);
                    Collections.sort(retList);
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "getMirrorListFromPair", "Catch CloneNotSupportedException.");
                    throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
                }
            }
            SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = this.createrMirrorInfoForNoJournal(pairInfo);
            if (Collections.binarySearch(retList, mirrorInfo) >= 0) continue;
            retList.add(mirrorInfo);
            Collections.sort(retList);
        }
        return retList;
    }

    private SJmoUniversalReplicatorJnlGrpMirror createrMirrorInfoForNoJournal(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        SJmoUniversalReplicatorJnlGrpMirror mirrorInfo = new SJmoUniversalReplicatorJnlGrpMirror();
        mirrorInfo.setNumOfDataVols(0);
        mirrorInfo.setDelta(0);
        this.mergeMirrorInfoFromPair(mirrorInfo, pairInfo);
        this.pairPositionMap.put(mirrorInfo.getIndexKey(), SJctrRemoteReplicationUtility.getPairPos(pairInfo));
        return mirrorInfo;
    }
}

