/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deletetcpairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.RMCPDelete1Pair;
import sanproject.serverux.dataimpl.RMCPDeletePair;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationTcPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.deletetcpairs.SJctrDeleteTCPairsConfirmData;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;

public class SJctrDeleteTCPairsAC
extends SJctrOperationTcPairBaseAC {
    private static final long serialVersionUID = -8412530447535384501L;
    private int deleteMode = -1;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private int deleteKind = 0;
    private int deleteAll = 0;
    private final int SHIFT_COPYTYPE = 0;
    private final int SHIFT_PAIR_POS = 1;
    private final int SHIFT_DEL_KIND = 2;
    private final int SHIFT_DEL_ALL = 5;

    public void setApplyData(SJctrDeleteTCPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.copyType = confirmData.getCopyType();
        this.deleteMode = confirmData.getDeleteMode();
        this.portLunMap = confirmData.getLUPathMap();
        this.setDeleteKindAndRange();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<RMCPDeletePair> applyList = null;
        ArrayList<RMCPDeletePair> applyData = new ArrayList<RMCPDeletePair>();
        RMCPDelete1Pair[] DeletePairList = new RMCPDelete1Pair[this.applyInfo.size()];
        for (int i = 0; i < this.applyInfo.size(); ++i) {
            SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)this.applyInfo.get(i);
            RMCPDelete1Pair Delete1Pair = new RMCPDelete1Pair();
            int localPairPosition = SJctrRemoteReplicationUtility.getPairPos(pairInfo);
            SJmoReplicationPairVolInfo localVol = SJctrRemoteReplicationUtility.getLocalVolumeForTcPair(pairInfo);
            Delete1Pair.CUNo = localVol.getSCu();
            Delete1Pair.LDEVNo = localVol.getSLdev();
            Delete1Pair.LDKC = localVol.getSLdkc();
            Delete1Pair.PairLDEVNo = this.getPairLDEVNo(pairInfo);
            if (localPairPosition == 0) {
                Delete1Pair.PLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
                Delete1Pair.SLU = SJctrRemoteReplicationUtility.getRemoteRMCPHorcLU(pairInfo, this.copyType);
            } else {
                Delete1Pair.PLU = SJctrRemoteReplicationUtility.getRemoteRMCPHorcLU(pairInfo, this.copyType);
                Delete1Pair.SLU = SJctrRemoteReplicationUtility.getLocalRMCPHorcLU(localVol, this.copyType, this.portLunMap);
            }
            Delete1Pair.SN = pairInfo.getStrPairSN();
            Delete1Pair.SSID = this.getPairSSID(pairInfo);
            Delete1Pair.Mode = this.getMode(pairInfo, localPairPosition);
            Delete1Pair.ControllerID = this.getControllerID(pairInfo);
            Delete1Pair.PathGrpID = this.getPathGrpID(pairInfo);
            DeletePairList[i] = Delete1Pair;
        }
        RMCPDeletePair deletePair = new RMCPDeletePair();
        deletePair.Delete1Pair = DeletePairList;
        deletePair.NumofPair = DeletePairList.length;
        applyData.add(deletePair);
        applyList = applyData;
        return applyList;
    }

    private void setDeleteKindAndRange() {
        switch (this.deleteMode) {
            case 0: {
                this.deleteKind = 0;
                this.deleteAll = 0;
                break;
            }
            case 1: {
                this.deleteKind = 1;
                this.deleteAll = 0;
                break;
            }
            case 2: {
                this.deleteKind = 1;
                this.deleteAll = 1;
            }
        }
    }

    private int getMode(SJmoTrueCopyPairVolInfo pairInfo, int pairPosition) {
        int rtn = 0;
        rtn |= this.copyType << 0;
        rtn |= pairPosition << 1;
        rtn |= this.deleteKind << 2;
        return rtn |= this.deleteAll << 5;
    }

    private int getPairLDEVNo(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (this.copyType == 0) {
            rtn = pairInfo.getSLdev();
        }
        return rtn;
    }

    private int getPairSSID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (pairInfo.getICUFree() != 1) {
            rtn = pairInfo.getIPairSSID();
        }
        return rtn;
    }

    private int getControllerID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (this.deleteMode == 0) {
            rtn = pairInfo.getIPairControllerID();
        }
        return rtn;
    }

    private int getPathGrpID(SJmoTrueCopyPairVolInfo pairInfo) {
        int rtn = 0;
        if (this.deleteMode == 0 && pairInfo.getICUFree() == 1) {
            rtn = pairInfo.getIPairRCUID();
        }
        return rtn;
    }
}

