/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editmirroropts.model;

import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editmirroropts.SJctrEditMirrorOptionsDC;

public class SJctrPathWatchTimeDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_PATH_WATCH_TIME_INF = "COM_PATH_WATCH_TIME_INF";
    public static final String KEY_PATH_WATCH_TIME_RADIOBUTTON = "COM_PATH_WATCH_TIME_RADIOBUTTON";
    public static final String KEY_PATH_WATCH_TIME_TEXTBOX = "COM_PATH_WATCH_TIME_TEXTBOX";
    public static final String KEY_PATH_WATCH_TIME_UNIT_LABEL = "COM_PATH_WATCH_TIME_UNIT_LABEL";
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final String KEY_MINUTE = "COM_MINUTE";
    public static final String KEY_HOUR = "COM_HOUR";
    public static final String KEY_DAY = "COM_DAY";

    public SJctrPathWatchTimeDataModel() {
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrCheckBoxDataModel pathWatchCheckBox = new SJctrCheckBoxDataModel();
        this.addDataModel(KEY_CHECKBOX, pathWatchCheckBox);
        SJctrRadioButtonGroupDataModel pathWatchRadioGroup = new SJctrRadioButtonGroupDataModel();
        pathWatchRadioGroup.add(KEY_MINUTE);
        pathWatchRadioGroup.add(KEY_HOUR);
        pathWatchRadioGroup.add(KEY_DAY);
        this.addDataModel(KEY_PATH_WATCH_TIME_RADIOBUTTON, pathWatchRadioGroup);
        SJctrTextBoxDataModel pathWatchTextBox = new SJctrTextBoxDataModel();
        this.addDataModel(KEY_PATH_WATCH_TIME_TEXTBOX, pathWatchTextBox);
        SJctrTextLabelDataModel pathWatchUnitLabel = new SJctrTextLabelDataModel();
        this.addDataModel(KEY_PATH_WATCH_TIME_UNIT_LABEL, pathWatchUnitLabel);
    }

    private void initListener() {
        SJctrCheckBoxDataModel pathWatchCheckBox = this.getPathWatchTimeCheckBox();
        SJctrRadioButtonGroupDataModel pathWatchRadioGroup = this.getPathWatchTimeRadioButton();
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        pathWatchRadioGroup.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                if (event.isSelect()) {
                    SJctrPathWatchTimeDataModel.this.fireMessageEvent(SJctrEditMirrorOptionsDC.EDIT_MIRROR_OPTIONS_MSG.SELECT_PATH_WATCH_TIME);
                }
            }
        });
        pathWatchTextBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public void makeDataObject() {
        this.setSelectCheckBox(false);
        int pathWatchTimeType = this.getSelectPathWatchTimeType();
        this.changePathWatchTimeTextBoxType(pathWatchTimeType);
    }

    public boolean isSelectCheckBox() {
        SJctrCheckBoxDataModel pathWatchCheckBox = this.getPathWatchTimeCheckBox();
        return pathWatchCheckBox.isSelect();
    }

    public void setSelectCheckBox(boolean flg) {
        SJctrCheckBoxDataModel pathWatchCheckBox = this.getPathWatchTimeCheckBox();
        pathWatchCheckBox.setSelect(flg);
    }

    public int getSelectPathWatchTimeType() {
        int value = -1;
        SJctrRadioButtonGroupDataModel pathWatchRadioGroup = this.getPathWatchTimeRadioButton();
        String selectString = pathWatchRadioGroup.getSelect();
        if (selectString != null) {
            if (selectString.equals(KEY_MINUTE)) {
                value = 0;
            } else if (selectString.equals(KEY_HOUR)) {
                value = 64;
            } else if (selectString.equals(KEY_DAY)) {
                value = 128;
            } else {
                this.logUty.putlog("getSelectPathWatchTimeType", "Selected value is invalid.");
            }
        }
        return value;
    }

    public void setSelectPathWatchTimeType(int pathWatchTimeType) {
        String key = "";
        SJctrRadioButtonGroupDataModel pathWatchRadioGroup = this.getPathWatchTimeRadioButton();
        if (0 == pathWatchTimeType) {
            key = KEY_MINUTE;
        } else if (64 == pathWatchTimeType) {
            key = KEY_HOUR;
        } else if (128 == pathWatchTimeType) {
            key = KEY_DAY;
        } else {
            this.logUty.putlog("setSelectPathWatchTimeType", "Argument value is invalid.");
        }
        pathWatchRadioGroup.setSelect(key);
    }

    public String getDisplayDataPathWatchTime() {
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        return pathWatchTextBox.getValue();
    }

    public void setDisplayDataPathWatchTime(String value) {
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchTextBox.setValue(value);
    }

    public void setMax(String max) {
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchTextBox.setMax(max);
    }

    public void setMin(String min) {
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchTextBox.setMin(min);
    }

    public void setUnit(String unitKey) {
        SJctrTextLabelDataModel pathWatchUnitLabel = this.getPathWatchUnitLabel();
        String unit = "";
        if (!unitKey.equals("")) {
            unit = this.getComUtility().getGuidance(unitKey);
        }
        pathWatchUnitLabel.setLabel(unit);
    }

    public void setDirty(String key) {
        SJctrDataObjectModel<SJctrDataObject> dataModel = this.getDataModel(key);
        if (dataModel != null) {
            dataModel.setDirty();
        }
    }

    public void changePathWatchTimeTextBoxType(int pathWatchTimeType) {
        String pathWatchMin = "";
        String pathWatchMax = "";
        String pathWatchUnitKey = "";
        if (pathWatchTimeType == 0) {
            pathWatchMin = String.valueOf(1);
            pathWatchMax = String.valueOf(59);
            pathWatchUnitKey = "PATH_WATCH_TIME_MINUTE";
        } else if (pathWatchTimeType == 64) {
            pathWatchMin = String.valueOf(1);
            pathWatchMax = String.valueOf(23);
            pathWatchUnitKey = "PATH_WATCH_TIME_HOUR";
        } else if (pathWatchTimeType == 128) {
            pathWatchMin = String.valueOf(1);
            pathWatchMax = String.valueOf(30);
            pathWatchUnitKey = "PATH_WATCH_TIME_DAY";
        } else {
            this.logUty.putlog("changePathWatchTimeTextBoxType", "Argument value is invalid.");
        }
        this.setMin(pathWatchMin);
        this.setMax(pathWatchMax);
        this.setUnit(pathWatchUnitKey);
    }

    public void setEnable(boolean flg) {
        SJctrCheckBoxDataModel pathWatchCheckBox = this.getPathWatchTimeCheckBox();
        SJctrRadioButtonGroupDataModel pathWatchRadioGroup = this.getPathWatchTimeRadioButton();
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchCheckBox.setEnable(flg);
        pathWatchRadioGroup.setEnable(flg);
        pathWatchTextBox.setEnable(flg);
    }

    public void setPathWatchTimeTextBoxEnable(boolean flg) {
        SJctrTextBoxDataModel pathWatchTextBox = this.getPathWatchTimeTextBox();
        pathWatchTextBox.setEnable(flg);
    }

    private SJctrCheckBoxDataModel getPathWatchTimeCheckBox() {
        return (SJctrCheckBoxDataModel)this.getDataModel(KEY_CHECKBOX);
    }

    private SJctrRadioButtonGroupDataModel getPathWatchTimeRadioButton() {
        return (SJctrRadioButtonGroupDataModel)this.getDataModel(KEY_PATH_WATCH_TIME_RADIOBUTTON);
    }

    private SJctrTextBoxDataModel getPathWatchTimeTextBox() {
        return (SJctrTextBoxDataModel)this.getDataModel(KEY_PATH_WATCH_TIME_TEXTBOX);
    }

    private SJctrTextLabelDataModel getPathWatchUnitLabel() {
        return (SJctrTextLabelDataModel)this.getDataModel(KEY_PATH_WATCH_TIME_UNIT_LABEL);
    }
}

