/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.editurpairopts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.remote.editurpairopts.SJctrCfwDataModel;
import sanproject.sn2.controller.wizard.replication.remote.editurpairopts.SJctrEditUrPairOptionsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.editurpairopts.SJctrErrorLvDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrEditUrPairOptionsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 18486369;
    private static final String DISP_TITLE = "EDIT_PAIR_OPTION";
    private static final String KEY_ERROR_LEVEL_INF = "COM_ERROR_LEVEL_INF";
    private static final String KEY_CFW_INF = "COM_CFW_INF";
    private static final String KEY_COPY_TYPE_INF = "COM_COPY_TYPE_INF";
    private static final String KEY_COPY_TYPE = "COM_COPY_TYPE";

    public SJctrEditUrPairOptionsDC() {
        super(18486369);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_COPY_TYPE_INF, new SJctrSimpleDataModel());
        this.addDataObjectModel(KEY_ERROR_LEVEL_INF, new SJctrErrorLvDataModel());
        this.addDataObjectModel(KEY_CFW_INF, new SJctrCfwDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoUniversalReplicatorPairVolInfo viewData = (SJmoUniversalReplicatorPairVolInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkStartData", "Information of selected Pair is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorPairVolInfoMgr allURPairInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            List<SJmoUniversalReplicatorPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrRemoteReplicationUtility.chkCacheUniversalReplicatorDetailData(this);
            List<SJmoUniversalReplicatorPairVolInfo> pairlist = SJctrRemoteReplicationUtility.checkAndGetExistUrPairVolInfo(viewData, allURPairInfo);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(pairlist);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Mixed copytype.");
                SJctrError err = new SJctrError(210, 22, 206008);
                SJcException exp = err.createException();
                throw exp;
            }
            for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairlist) {
                this.checkPairPosition(pairInfo);
                this.checkPairStatus(pairInfo);
            }
            this.initialSetupDataModel(pairlist, copytype);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void checkPairPosition(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (SJctrRemoteReplicationUtility.getPairPos(pairInfo) != 0) {
            this.logUty.putlog("checkPairPosition", "Contained SVOL.");
            SJctrError err = new SJctrError(210, 22, 206004);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void checkPairStatus(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        if (!SJctrRemoteReplicationUtility.checkEditURPairOptionsStatus(pairInfo)) {
            this.logUty.putlog("checkPairStatus", "Contained invalid Status.");
            SJctrError err = new SJctrError(210, 22, 206013);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrEditUrPairOptionsConfirmData confirmData = new SJctrEditUrPairOptionsConfirmData();
            ArrayList<SJmoUniversalReplicatorPairVolInfo> sendPairList = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
            List<SJmoUniversalReplicatorPairVolInfo> selectedPairList = this.getProxy().getCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION");
            List<?> originalPairList = this.getProxy().getCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION_ORIGINAL");
            List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            Map<Integer, List<SJmoPortLunDetail>> ldevLUPathMap = SJctrReplicationUtility.createLDEVLUPathMap(portLunList, ldevDetailList);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForUrPairVol(selectedPairList);
            SJctrSimpleDataModel errorLevelInf = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_ERROR_LEVEL_INF);
            SJctrCheckBoxDataModel errorLevelCheckBox = (SJctrCheckBoxDataModel)errorLevelInf.getDataModel("COM_CHECKBOX");
            SJctrComboBoxDataModel errorLevelComboBox = (SJctrComboBoxDataModel)errorLevelInf.getDataModel("COM_ERROR_LEVEL_COMBOBOX");
            boolean errorLevelCheck = errorLevelCheckBox.isSelect();
            int errorLevelSelectKey = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(errorLevelComboBox);
            boolean cfwCheck = false;
            int cfwSelectKey = -1;
            if (copytype == 0) {
                SJctrSimpleDataModel cfwInf = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_CFW_INF);
                SJctrCheckBoxDataModel cfwCheckBox = (SJctrCheckBoxDataModel)cfwInf.getDataModel("COM_CHECKBOX");
                SJctrComboBoxDataModel cfwComboBox = (SJctrComboBoxDataModel)cfwInf.getDataModel("COM_CFW_COMBOBOX");
                cfwCheck = cfwCheckBox.isSelect();
                cfwSelectKey = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cfwComboBox);
            }
            for (int i = 0; i < selectedPairList.size(); ++i) {
                SJmoUniversalReplicatorPairVolInfo sendPairInfo = selectedPairList.get(i);
                SJmoUniversalReplicatorPairVolInfo savePairInfo = (SJmoUniversalReplicatorPairVolInfo)originalPairList.get(i);
                this.updateErrorLevel(sendPairInfo, savePairInfo, copytype, errorLevelCheck, errorLevelSelectKey);
                this.updateCFW(sendPairInfo, savePairInfo, copytype, cfwCheck, cfwSelectKey);
                sendPairList.add(sendPairInfo);
            }
            Collections.sort(sendPairList, new SJctrUniversalReplicatorPairInfoComparator());
            confirmData.setPairInfoList(sendPairList);
            confirmData.setCopyType(copytype);
            confirmData.setErrorLevel(errorLevelSelectKey);
            confirmData.setCFW(cfwSelectKey);
            confirmData.setLUPathMap(ldevLUPathMap);
            confirmData.setNeedData(this);
            ArrayList<SJctrEditUrPairOptionsConfirmData> confirmDataList = new ArrayList<SJctrEditUrPairOptionsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditUrPairOptionsConfirmData.class, confirmDataList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        return true;
    }

    private void updateErrorLevel(SJmoUniversalReplicatorPairVolInfo pairInfo, SJmoUniversalReplicatorPairVolInfo savePairInfo, int copytype, boolean errorLevelCheck, int errorLevelSelectKey) {
        if (copytype == 1 || errorLevelCheck) {
            pairInfo.setErrLv(errorLevelSelectKey);
        } else {
            pairInfo.setErrLv(savePairInfo.getErrLv());
        }
    }

    private void updateCFW(SJmoUniversalReplicatorPairVolInfo pairInfo, SJmoUniversalReplicatorPairVolInfo savePairInfo, int copytype, boolean cfwCheck, int cfwSelectKey) {
        if (copytype == 0) {
            if (cfwCheck) {
                pairInfo.setCFW(cfwSelectKey);
            } else {
                pairInfo.setCFW(savePairInfo.getCFW());
            }
        }
    }

    private void initialSetupDataModel(List<SJmoUniversalReplicatorPairVolInfo> pairList, int copytype) {
        SJctrErrorLvDataModel errorLevelInf = (SJctrErrorLvDataModel)this.getDataObjectModel(KEY_ERROR_LEVEL_INF);
        errorLevelInf.createErrorLevelItem(copytype);
        SJctrComboBoxDataModel errorLevelComboBox = (SJctrComboBoxDataModel)errorLevelInf.getDataModel("COM_ERROR_LEVEL_COMBOBOX");
        SJctrCfwDataModel cfwInf = (SJctrCfwDataModel)this.getDataObjectModel(KEY_CFW_INF);
        cfwInf.createCfwItem();
        SJctrComboBoxDataModel cfwComboBox = (SJctrComboBoxDataModel)cfwInf.getDataModel("COM_CFW_COMBOBOX");
        SJmoUniversalReplicatorPairVolInfo firstPairInfo = pairList.get(0);
        int firstErrorLevel = firstPairInfo.getErrLv();
        int firstCFW = firstPairInfo.getCFW();
        boolean errorLevelMixFlg = false;
        boolean cfwMixFlg = false;
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairList) {
            int errorLevel = pairInfo.getErrLv();
            int cfw = pairInfo.getCFW();
            if (firstErrorLevel != errorLevel) {
                errorLevelMixFlg = true;
                if (copytype == 1) break;
            }
            if (copytype != 0) continue;
            if (firstCFW != cfw) {
                cfwMixFlg = true;
            }
            if (!errorLevelMixFlg || !cfwMixFlg) continue;
            break;
        }
        if (!errorLevelMixFlg) {
            errorLevelComboBox.removeItem("-1");
            switch (firstErrorLevel) {
                case 1: {
                    errorLevelComboBox.setSelection(String.valueOf(1));
                    break;
                }
                case 0: {
                    errorLevelComboBox.setSelection(String.valueOf(0));
                    break;
                }
            }
        } else {
            errorLevelComboBox.setSelection(String.valueOf("-1"));
        }
        if (!cfwMixFlg) {
            cfwComboBox.removeItem("-1");
            switch (firstCFW) {
                case 0: {
                    cfwComboBox.setSelection(String.valueOf(0));
                    break;
                }
                case 1: {
                    cfwComboBox.setSelection(String.valueOf(1));
                    break;
                }
            }
        } else {
            cfwComboBox.setSelection(String.valueOf("-1"));
        }
        SJctrSimpleDataModel copyType = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_COPY_TYPE_INF);
        ((SJctrDataObject)copyType.getManageData()).setData(KEY_COPY_TYPE, copytype);
        this.putCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION", pairList);
        ArrayList<SJmoUniversalReplicatorPairVolInfo> pairListCopy = new ArrayList<SJmoUniversalReplicatorPairVolInfo>(pairList.size());
        for (SJmoUniversalReplicatorPairVolInfo pairInfo : pairList) {
            try {
                pairListCopy.add((SJmoUniversalReplicatorPairVolInfo)pairInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                this.logUty.putlog("initialSetupDataModel", "catch CloneNotSupportedException");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        this.putCache("COM_EDIT_PAIR_OPTIONS_CACHE_PAIR_VOL_INFORMATION_ORIGINAL", pairListCopy);
    }
}

