/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.exctgprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.HURgetECTGrps;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrEXCTGJournalsStorageSystemUnitInfo;
import sanproject.sn2.controller.wizard.replication.remote.exctgprops.SJctrEXCTGPropsJNLTableModel;
import sanproject.sn2.controller.wizard.replication.remote.exctgprops.SJctrEXCTGPropsStorageSystemTableModel;
import sanproject.sn2.controller.wizard.replication.remote.exctgprops.SJctrEXCtgPropsSummaryModel;
import sanproject.sn2.controller.wizard.replication.remote.exctgprops.SJmoUniversalReplicatorEXCTGJnlGrpComparator;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTG;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorEXCTGMgr;

public class SJctrEXCtgPropsDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664528;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE_STORAGE_SYSTEM = "COM_TABLE_STORAGE_SYSTEM";
    private static final String KEY_TABLE_JNL = "COM_TABLE_JNL";
    private static final String KEY_SELECTED_EXCTG = "KEY_SELECTED_EXCTG";

    public SJctrEXCtgPropsDC() throws SJcException {
        super(34664528);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrEXCtgPropsSummaryModel());
        this.addDataObjectModel(KEY_TABLE_STORAGE_SYSTEM, new SJctrEXCTGPropsStorageSystemTableModel(false));
        this.addDataObjectModel(KEY_TABLE_JNL, new SJctrEXCTGPropsJNLTableModel(false));
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        List<?> viewDataList = this.getProxy().getCache(KEY_SELECTED_EXCTG);
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Information of data list is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of data list is zero.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJmoUniversalReplicatorEXCTG selectedCtg = (SJmoUniversalReplicatorEXCTG)viewDataList.get(0);
        if (null == selectedCtg) {
            this.logUty.putlog("checkStartData", "Information of selected data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<?> infoList = this.getProxy().getCache(KEY_SELECTED_EXCTG);
            SJmoUniversalReplicatorEXCTG selectedEXctg = (SJmoUniversalReplicatorEXCTG)infoList.get(0);
            HURgetECTGrps rmiHurExctgrps = SJctrRemoteReplicationUtility.getHURgetECTGrpsList(this);
            SJmoUniversalReplicatorEXCTGMgr exctgMgr = new SJmoUniversalReplicatorEXCTGMgr(rmiHurExctgrps);
            SJmoUniversalReplicatorEXCTG rmiMatchedEXctg = exctgMgr.getExCtGroup(selectedEXctg.getIExCtgId());
            if (rmiMatchedEXctg == null) {
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107002);
            }
            SJctrEXCtgPropsSummaryModel summary = (SJctrEXCtgPropsSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.setData(rmiMatchedEXctg);
            this.setStorageSystemTableData(rmiMatchedEXctg);
            this.setJnlTableData(rmiMatchedEXctg);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void setStorageSystemTableData(SJmoUniversalReplicatorEXCTG selectedEXCTG) {
        List<SJctrEXCTGJournalsStorageSystemUnitInfo> journalList = SJctrRemoteReplicationUtility.getEXCTGJournalsStorageSystemUnit(selectedEXCTG);
        SJctrEXCTGPropsStorageSystemTableModel table = (SJctrEXCTGPropsStorageSystemTableModel)this.getDataObjectModel(KEY_TABLE_STORAGE_SYSTEM);
        Collections.sort(journalList);
        table.setBasicDataList(journalList);
    }

    private void setJnlTableData(SJmoUniversalReplicatorEXCTG selectedEXCTG) {
        ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> journalList = selectedEXCTG.getJnlGrpList();
        if (journalList == null) {
            this.logUty.putlog("setJnlTableData", "Journal data is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrEXCTGPropsJNLTableModel table = (SJctrEXCTGPropsJNLTableModel)this.getDataObjectModel(KEY_TABLE_JNL);
        Collections.sort(journalList, new SJmoUniversalReplicatorEXCTGJnlGrpComparator());
        table.setBasicDataList(journalList);
    }
}

