/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.forcedeletepairs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.replication.remote.forcedeletepairs.SJctrForceDeletePairsHaAC;
import sanproject.sn2.controller.wizard.replication.remote.forcedeletepairs.SJctrForceDeletePairsHaConfirmDC;
import sanproject.sn2.controller.wizard.replication.remote.forcedeletepairs.SJctrForceDeletePairsHaConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrForceDeletePairsHaSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "FORCE_DELETE_PAIRS_HA";
    private static final Class<?> CONFIRM_DC = SJctrForceDeletePairsHaConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrForceDeletePairsHaAC applyCntl = new SJctrForceDeletePairsHaAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<?> selectldevs = dc.getProxy().getCache("KEY_SELECTED_FORCE_DELETE_VOL");
            if (null == selectldevs) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (0 == selectldevs.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err = new SJctrError(210, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrHaUtility.chkCacheForceDeleteHaPairsDetailData(dc);
            List<SJmoLdevDetail> allLdevInfo = SJctrReplicationUtility.getSJmoLdevDetail(dc);
            List<SJmoLdevDetail> ldevInfoList = SJctrRemoteReplicationUtility.checkAndGetExistLdevlInfo(selectldevs, allLdevInfo);
            SJctrResourceGroupUtility rsgUty = SJctrHaUtility.getSJctrResourceGroupUtility(dc);
            for (SJmoLdevDetail ldevinfo : ldevInfoList) {
                if (!rsgUty.isSelRscLdevInSysRsg(ldevinfo)) continue;
                dc.getLogUty().putlog("constructConfirmData", "Selected LDEVs is belong to System RSG.");
                SJctrError err = new SJctrError(210, 22, 205175);
                SJcException exp = err.createException();
                throw exp;
            }
            int voltype = SJctrRemoteReplicationUtility.checkVolTypeForLdev(ldevInfoList);
            if (1 != voltype) {
                dc.getLogUty().putlog("selectChanged", "volume type is not open.");
                SJctrError err = new SJctrError(210, 22, 206157);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoHAPairVolInfoMgr allHAPairInfo = SJctrHaUtility.getSJmoHAPairVolInfoMgr(dc);
            boolean usedHaPair = SJctrHaUtility.isUsedHAPairVol(ldevInfoList, allHAPairInfo);
            if (usedHaPair) {
                dc.getLogUty().putlog("constructConfirmData", "It is already used as HA Pair.");
                SJctrError err = new SJctrError(210, 22, 206156);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrForceDeletePairsHaConfirmData confirmData = new SJctrForceDeletePairsHaConfirmData();
            ArrayList<SJctrForceDeletePairsHaConfirmData> confirmDataList = new ArrayList<SJctrForceDeletePairsHaConfirmData>();
            confirmData.setLdevInfo(ldevInfoList);
            confirmData.setVolType(voltype);
            confirmData.setLUPathMap(SJctrHaUtility.getLDEVLUPathMap(dc));
            confirmData.setNeedData(dc);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrForceDeletePairsHaConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHAPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

