/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resynchapairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaPairTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.resynchapairs.SJctrResyncHaPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.resynchapairs.SJctrResyncHaPairsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncHaPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17832225;
    private static final String DISP_TITLE = "RESYNC_PAIRS";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_COPY_PACE = "COM_COPY_PACE";
    private static final String KEY_CTG_ID = "COM_CTG_ID";
    public static final int CTG_ID_NOT_ASSIGN = -1;
    public static final int CTG_ID_BRANK = -2;
    public static final int INITIAL_CTG_ID = 0;
    public static final int SELECT_TOP_INDEX = 0;
    private static final String KEY_ALUA_MODE = "COM_ALUA_MODE";

    public SJctrResyncHaPairsDC() {
        super(17832225);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        SJctrTextBoxDataModel copyPaceTxt = new SJctrTextBoxDataModel();
        copyPaceTxt.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_COPY_PACE, copyPaceTxt);
        SJctrComboBoxDataModel ctgIdCmb = new SJctrComboBoxDataModel();
        ctgIdCmb.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_CTG_ID, ctgIdCmb);
        SJctrComboBoxDataModel cmbAluaMode = new SJctrComboBoxDataModel();
        cmbAluaMode.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrHaUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addDataObjectModel(KEY_ALUA_MODE, cmbAluaMode);
        this.addDataObjectModel(KEY_TABLE, new SJctrResyncHaPairsTableModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
        if (viewDataList == null) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (viewDataList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoHAPairVolInfoMgr allHaPairInfo = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            List<SJmoHAPairVolInfo> viewData = this.getProxy().getCache("KEY_SELECTED_REMOTE_VOL");
            SJctrHaUtility.chkCacheHaPairsDetailData(this);
            List<SJmoHAPairVolInfo> pairExist = SJctrHaUtility.checkAndGetExistHaPairInfo(viewData, allHaPairInfo);
            List<SJmoHUVMVirtualLdev> virtualLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
            List<? extends SJmoReplicationPairVolInfo> currentHaPairVolInfoList = SJctrHaUtility.getRemoteCopyPairVolInfoList(allHaPairInfo.getHAPairVolInfoList());
            ArrayList<SJctrHaCtgInfo> ctgInfoList = SJctrHaUtility.getHaCtgInfoList(currentHaPairVolInfoList, virtualLdevList, virtualDkcList);
            SJctrUserController uc = this.getOwner();
            SJctrRemoteReplicationUtility.checkPpLicenseForGADList(uc, 1);
            boolean st = SJctrHaUtility.checkResyncHaPairStatus(pairExist);
            if (!st) {
                this.logUty.putlog("checkConstructData", "Contains a pair of invalid pair position.");
                SJctrError err = new SJctrError(210, 22, 206160);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrResyncHaPairsTableModel table = (SJctrResyncHaPairsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(pairExist);
            this.initCtgID(pairExist, ctgInfoList);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrTextBoxDataModel copyPaceTxt = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PACE);
        copyPaceTxt.setValue("15");
        copyPaceTxt.setMax("15");
        copyPaceTxt.setMin("1");
        SJctrComUtility comUty = this.getOwner().getComUtility();
        SJctrComboBoxDataModel aluaMode = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_ALUA_MODE);
        aluaMode.addItem(String.valueOf(0), comUty.getGuidance("DEPEND_ON_PVOL_SETTINGS"));
        aluaMode.addItem(String.valueOf(1), comUty.getGuidance("ENABLE"));
        aluaMode.addItem(String.valueOf(2), comUty.getGuidance("DISABLE"));
        aluaMode.setSelection(String.valueOf(0));
    }

    private void initCtgID(List<SJmoHAPairVolInfo> pairExist, List<SJctrHaCtgInfo> ctgInfoList) {
        SJctrComUtility comUty = this.getComUtility();
        SJctrRsgUtility rsgUty = comUty.getRsgUtility();
        SJctrHaUtility haUty = comUty.getHaUtility();
        boolean ctgFlg = true;
        SJctrComboBoxDataModel cmbCtgId = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CTG_ID);
        List<SJmoHUVMVirtualLdev> virtualLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
        Collections.sort(virtualLdevList);
        List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
        Collections.sort(virtualDkcList);
        int topMirrorID = pairExist.get(0).getIMuNo();
        int topQuorumID = pairExist.get(0).getIQuorumID();
        SJmoHUVMVirtualDkc topVlDkc = SJctrHaUtility.getTargetVirtualDkcInfo(pairExist.get(0), virtualLdevList, virtualDkcList);
        String topVModelSNStr = haUty.getVirtualModelSerialString(topVlDkc, rsgUty);
        boolean topPairPositon = SJctrHaUtility.checkSelectedPairsSvol(pairExist);
        for (SJmoHAPairVolInfo selectedHaInfo : pairExist) {
            SJmoHUVMVirtualDkc virtualDkc = SJctrHaUtility.getTargetVirtualDkcInfo(selectedHaInfo, virtualLdevList, virtualDkcList);
            String vModelSNStr = haUty.getVirtualModelSerialString(virtualDkc, rsgUty);
            if (selectedHaInfo.getIMuNo() != topMirrorID || selectedHaInfo.getIQuorumID() != topQuorumID || !vModelSNStr.equals(topVModelSNStr)) {
                ctgFlg = false;
            } else if (selectedHaInfo.hasGroup()) {
                ctgFlg = false;
            } else if (!topPairPositon) {
                ctgFlg = false;
            }
            if (ctgFlg) continue;
            break;
        }
        this.makeCmbCtgID(topMirrorID, topQuorumID, topVModelSNStr, ctgInfoList, ctgFlg);
    }

    private void makeCmbCtgID(int topMirrorID, int topQuorumID, String topVModelSNStr, List<SJctrHaCtgInfo> ctgInfoList, boolean ctgFlg) {
        SJctrComUtility comUty = this.getComUtility();
        SJctrRsgUtility rsgUty = comUty.getRsgUtility();
        SJctrHaUtility haUty = comUty.getHaUtility();
        SJctrComboBoxDataModel cmbCtgId = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CTG_ID);
        cmbCtgId.removeAllItems();
        if (ctgFlg) {
            cmbCtgId.addItem(String.valueOf(-1), this.getComUtility().getGuidance("NOT_ASSIGN"));
            for (SJctrHaCtgInfo ctgInfo : ctgInfoList) {
                String dispId = SJctrComUtility.toHexString(ctgInfo.getCtgId(), 3, true);
                String vStorageMachineStr = haUty.getHaCtgVirtualStorageMachineString(ctgInfo, rsgUty);
                int usage = ctgInfo.getUsage();
                if (usage == 1) {
                    if (ctgInfo.getMirrorId() != topMirrorID || ctgInfo.getQuorumDiskId() != topQuorumID || !vStorageMachineStr.equals(topVModelSNStr) || ctgInfo.getLocalPairPosition() != 0 || ctgInfo.getNumOfPairs() >= 8192) continue;
                    String useCtgID = dispId + " " + this.getComUtility().getGuidance("ASTERISK");
                    cmbCtgId.addItem(String.valueOf(dispId), useCtgID);
                    continue;
                }
                if (usage != 0) continue;
                cmbCtgId.addItem(String.valueOf(dispId), dispId);
            }
        } else {
            cmbCtgId.addItem(String.valueOf(-2), " ");
        }
        cmbCtgId.setSelectedIndex(0);
        cmbCtgId.setEnable(ctgFlg);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
            SJctrResyncHaPairsConfirmData confirmData = new SJctrResyncHaPairsConfirmData();
            SJctrHaPairTableDataModelBase table = (SJctrHaPairTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            confirmData.setLUPathMap(SJctrHaUtility.getLDEVLUPathMap(this));
            SJmoSubsystemInfo subsysInfo = SJctrHaUtility.getSJmoSubsystemInfo(this);
            int modelID = remoteUty.getModelIDfromSubsysInfo(subsysInfo);
            confirmData.setModelID(modelID);
            SJctrTextBoxDataModel copyPaceTxt = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_COPY_PACE);
            int copyPace = SJctrHaUtility.getValueTextBoxNum(copyPaceTxt);
            for (SJmoHAPairVolInfo sJmoHAPairVolInfo : selectedList) {
                sJmoHAPairVolInfo.setICopyPace(copyPace);
            }
            SJctrComboBoxDataModel cmbCtgId = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_CTG_ID);
            try {
                int n = Integer.parseInt(cmbCtgId.getSelection(), 16);
                for (SJmoHAPairVolInfo sJmoHAPairVolInfo : selectedList) {
                    if (n == -1) {
                        sJmoHAPairVolInfo.setBHasGroup(false);
                        sJmoHAPairVolInfo.setIGroup(0);
                        continue;
                    }
                    if (n == -2) continue;
                    sJmoHAPairVolInfo.setBHasGroup(true);
                    sJmoHAPairVolInfo.setIGroup(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logUty.putlog("checkEndData", "The error occurred at the CTG ID getting. NumberFormatException : " + numberFormatException.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
            }
            int n = SJctrHaUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel(KEY_ALUA_MODE));
            ArrayList<SJmoLdevDetail> confirmLdevDetails = new ArrayList<SJmoLdevDetail>();
            List<SJmoLdevDetail> list = SJctrReplicationUtility.getSJmoLdevDetail(this);
            ArrayList cloneLdevDetails = SJmoDataUtility.alDeepCopy(new ArrayList<SJmoLdevDetail>(list));
            for (SJmoHAPairVolInfo sJmoHAPairVolInfo : selectedList) {
                SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(sJmoHAPairVolInfo);
                if (localVol == null) {
                    this.logUty.putlog("checkEndData", "Information of SJmoReplicationPairVolInfo is null.");
                    continue;
                }
                int index = Collections.binarySearch(cloneLdevDetails, localVol);
                if (index < 0) continue;
                SJmoLdevDetail ldev = (SJmoLdevDetail)cloneLdevDetails.get(index);
                if (n != 0) {
                    ldev.setBAluaMode(n == 1);
                }
                confirmLdevDetails.add(ldev);
            }
            confirmData.setAluaModeSelection(n);
            Collections.sort(confirmLdevDetails);
            confirmData.setConfirmLdevDetails(confirmLdevDetails);
            confirmData.setPairsInfo(selectedList);
            confirmData.setNeedData(this);
            ArrayList<SJctrResyncHaPairsConfirmData> confirmDataList = new ArrayList<SJctrResyncHaPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrResyncHaPairsConfirmData.class, confirmDataList);
            SJctrHaUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }
}

