/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.resyncurpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.HURresync1Pair;
import sanproject.serverux.dataimpl.HURresyncPairs;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoPriorityComparator;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationUrPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.resyncurpairs.SJctrResyncURPairsConfirmData;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrResyncURPairsAC
extends SJctrOperationUrPairBaseAC {
    private static final long serialVersionUID = 2084612890550209488L;
    private static final int RESYNC_RANGE_VOL = 1;
    private static final int RESYNC_NOMAL = 0;
    private static final int RESYNC_DIFF = 1;
    private static final int RESYNC_STANDBY = 2;
    private static final int COPY_START_DEFAULT = 0;
    private static final int COPY_START_LAST_PAIR = 1;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;

    public void setApplyData(SJctrResyncURPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.copyType = confirmData.getCopyType();
        this.portLunMap = confirmData.getLUPathMap();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<HURresyncPairs> applyList = null;
        ArrayList<HURresyncPairs> applyData = new ArrayList<HURresyncPairs>(1);
        ArrayList<HURresync1Pair> resyncPairList = new ArrayList<HURresync1Pair>(this.applyInfo.size());
        ArrayList<SJmoUniversalReplicatorPairVolInfo> applySortInfo = new ArrayList<SJmoUniversalReplicatorPairVolInfo>();
        for (SJmoUniversalReplicatorPairVolInfo info : this.applyInfo) {
            try {
                applySortInfo.add((SJmoUniversalReplicatorPairVolInfo)info.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.title, "getSetList", "Information of SJmoUniversalReplicatorPairVolInfo cannot clone.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(applySortInfo, new SJctrUniversalReplicatorPairInfoPriorityComparator());
        for (int i = 0; i < applySortInfo.size(); ++i) {
            SJmoUniversalReplicatorPairVolInfo pairInfo = (SJmoUniversalReplicatorPairVolInfo)applySortInfo.get(i);
            HURresync1Pair resync1Pair = new HURresync1Pair();
            int localPairPos = SJctrRemoteReplicationUtility.getPairPos(pairInfo);
            SJmoLdevDetail ldev = SJctrRemoteReplicationUtility.getSJmoLdevDetailFromUrPairInfo(pairInfo);
            resync1Pair.mirrorID = pairInfo.getMirrorId();
            resync1Pair.rcuSN = pairInfo.getPairSN();
            resync1Pair.ldkc = pairInfo.getSLdkc();
            resync1Pair.modelID = pairInfo.getModelId();
            if (localPairPos == 0) {
                resync1Pair.pvol = SJctrRemoteReplicationUtility.getHUR1DataVol(ldev, this.copyType, this.portLunMap);
                resync1Pair.svol = SJctrRemoteReplicationUtility.getHUR1DataVol(pairInfo.getSVolLuPath(), this.copyType);
            } else {
                resync1Pair.pvol = SJctrRemoteReplicationUtility.getHUR1DataVol(pairInfo.getPVolLuPath(), this.copyType);
                resync1Pair.svol = SJctrRemoteReplicationUtility.getHUR1DataVol(ldev, this.copyType, this.portLunMap);
            }
            resync1Pair.priority = pairInfo.getCopyPriority();
            resync1Pair.ctGroup = this.getctgId(pairInfo);
            resync1Pair.range = 1;
            resync1Pair.pathID = 0;
            resync1Pair.mJnlGrp = pairInfo.getMJnlGrpId();
            resync1Pair.rJnlGrp = pairInfo.getRJnlGrpId();
            resync1Pair.copyStart = 0;
            resync1Pair.cfw = this.getCFW(pairInfo);
            resync1Pair.errLevel = pairInfo.getErrLv();
            resync1Pair.diffResync = this.getdiffResync(pairInfo);
            resyncPairList.add(resync1Pair);
        }
        if (this.applyInfo.size() > 0) {
            ((HURresync1Pair)resyncPairList.get((int)(this.applyInfo.size() - 1))).copyStart = 1;
        }
        HURresyncPairs resyncPair = new HURresyncPairs();
        resyncPair.flag = this.copyType;
        resyncPair.pairInfo = resyncPairList;
        applyData.add(resyncPair);
        applyList = applyData;
        return applyList;
    }

    private int getdiffResync(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        int diff = -1;
        switch (pairInfo.getDelta()) {
            case 0: {
                diff = 0;
                break;
            }
            case 2: {
                diff = 1;
                break;
            }
            case 3: {
                diff = 2;
                break;
            }
            case 6: {
                diff = 1;
                break;
            }
            default: {
                SJctrLogUty.error(this.title, "getdiffResync", "Invalid data");
            }
        }
        return diff;
    }

    private int getCFW(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        int cfw = 0;
        if (this.copyType == 0) {
            cfw = pairInfo.getCFW();
        }
        return cfw;
    }

    private int getctgId(SJmoUniversalReplicatorPairVolInfo pairInfo) {
        int ictg = 0;
        if (this.copyType == 1) {
            ictg = pairInfo.getCtgId();
        }
        return ictg;
    }

    @Override
    public int getLeadTime() {
        int ret = SJctrRemoteReplicationUtility.getLeadTime(this.applyInfo.size(), 1024, 40);
        return ret;
    }
}

