/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.splitmirrors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMirrorTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.splitmirrors.SJctrSplitMirrorsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.splitmirrors.SJctrSplitMirrorsDataModel;
import sanproject.sn2.controller.wizard.replication.remote.splitmirrors.SJctrSplitMirrorsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;

public class SJctrSplitMirrorsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101441;
    private static final String DISP_TITLE = "SPLIT_MIRROR";
    private static final String KEY_TABLE = "COM_SPLIT_MIRRORS_TABLE";
    private static final String KEY_SPLIT_MIRROR_MODEL = "COM_SPLIT_MIRROR_MODEL";

    public SJctrSplitMirrorsDC() {
        super(0x1101441);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrSplitMirrorsTableModel());
        this.addDataObjectModel(KEY_SPLIT_MIRROR_MODEL, new SJctrSplitMirrorsDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_MIRROR");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorJnlGrpMgr allJnlInfo = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoMirrorIndex> viewData = this.getProxy().getCache("KEY_SELECTED_MIRROR");
            List<SJmoUniversalReplicatorJnlGrpMirror> mirrorExist = SJctrRemoteReplicationUtility.checkAndGetExistMirrorInfo(viewData, allJnlInfo);
            SJctrRemoteReplicationUtility.checkMirrorTypicalVolRs(this, mirrorExist);
            int copytype = SJctrRemoteReplicationUtility.checkCopyTypeForMirror(mirrorExist, allJnlInfo);
            if (copytype == -1) {
                this.logUty.putlog("checkConstructData", "Copy type is mixed.");
                SJctrError err = new SJctrError(210, 22, 206010);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean attribute = SJctrRemoteReplicationUtility.checkMirrorAttributeMaster(mirrorExist, false);
            if (!attribute) {
                if (13314 == this.getTopWindow().getDisplayID()) {
                    this.logUty.putlog("checkConstructData", "Contained invalid mirror attribute.(ErrorLevel5)");
                    SJctrError err = new SJctrError(210, 22, 206067);
                    SJcException exp = err.createException();
                    throw exp;
                }
                this.logUty.putlog("checkConstructData", "Contained invalid mirror attribute.(ErrorLevel4)");
                SJctrError err = new SJctrError(210, 22, 206006);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean st = SJctrRemoteReplicationUtility.checkSplitMirrorStatus(mirrorExist);
            if (!st) {
                if (13314 == this.getTopWindow().getDisplayID()) {
                    this.logUty.putlog("checkConstructData", "Contained invaid Mirror Status.(ErrorLevel5)");
                    SJctrError err = new SJctrError(210, 22, 206050);
                    SJcException exp = err.createException();
                    throw exp;
                }
                this.logUty.putlog("checkConstructData", "Contained invaid Mirror Status.(ErrorLevel4)");
                SJctrError err = new SJctrError(210, 22, 206015);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrSplitMirrorsTableModel table = (SJctrSplitMirrorsTableModel)this.getDataObjectModel(KEY_TABLE);
            table.setBasicDataList(mirrorExist);
            SJctrSplitMirrorsDataModel dataModel = (SJctrSplitMirrorsDataModel)this.getDataObjectModel(KEY_SPLIT_MIRROR_MODEL);
            dataModel.setCopyType(copytype);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrSplitMirrorsConfirmData confirmData = new SJctrSplitMirrorsConfirmData();
            SJctrRcMirrorTableDataModelBase table = (SJctrRcMirrorTableDataModelBase)this.getDataObjectModel(KEY_TABLE);
            List<Object> selectedList = table.getAllRowData();
            confirmData.setMirrorsInfo(selectedList);
            SJctrSplitMirrorsDataModel dataModel = (SJctrSplitMirrorsDataModel)this.getDataObjectModel(KEY_SPLIT_MIRROR_MODEL);
            SJctrRadioButtonGroupDataModel svolWrite = (SJctrRadioButtonGroupDataModel)dataModel.getDataModel("COM_SVOL_WRITE");
            int sWrite = SJctrRemoteReplicationUtility.getSelectedRadioButtonKeyNum(svolWrite);
            confirmData.setSvolWrite(sWrite);
            SJctrComboBoxDataModel splitMode = (SJctrComboBoxDataModel)dataModel.getDataModel("COM_SPLIT_MODE");
            int mode = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(splitMode);
            confirmData.setSplitMode(mode);
            confirmData.setCopyType(dataModel.getCopytype());
            confirmData.setNeedData(this);
            ArrayList<SJctrSplitMirrorsConfirmData> confirmDataList = new ArrayList<SJctrSplitMirrorsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrSplitMirrorsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }
}

