/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.suspendhapairs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_RJiHAsetSeparatePair;
import sanproject.serverux.dataimpl.RJiHAsetSeparatePair;
import sanproject.serverux.dataimpl.RJiHAsetSeparatePair_IN;
import sanproject.serverux.dataimpl.RJiHAsetSeparatePairsList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationHaPairBaseAC;
import sanproject.sn2.controller.wizard.replication.remote.suspendhapairs.SJctrSuspendHaPairsConfirmData;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;

public class SJctrSuspendHaPairsAC
extends SJctrOperationHaPairBaseAC {
    private static final long serialVersionUID = -461575475903356928L;
    private int ioMode = -1;
    private Map<Integer, List<SJmoPortLunDetail>> portLunMap = null;
    private List<SJmoSubsystemInfo> subsystemInfoList = null;
    private List<SJmoSsidDetail> ssidList = null;
    private static final int RMISET_KIND_PVOL = 0;
    private static final int RMISET_KIND_SVOL_SUSPEND = 1;
    private static final int RMISET_SWAP_NORMAL = 0;
    private static final int RMISET_SWAP_PVOL_TO_SVOL = 1;

    public void setApplyData(SJctrSuspendHaPairsConfirmData confirmData) {
        this.applyInfo = confirmData.getPairsInfo();
        this.portLunMap = confirmData.getLUPathMap();
        this.subsystemInfoList = confirmData.getNeedDataMap().get(SJmoGetSubsystemInfo.class.getName());
        this.ssidList = confirmData.getNeedDataMap().get(SJmoGetSsidDetail.class.getName());
        this.ioMode = this.getSuspendIOModeRmiData(confirmData.getIoMode(), confirmData.getChkIOStatus());
    }

    @Override
    public ArrayList<?> getSetList() {
        RJiHAsetSeparatePairsList applyData = new RJiHAsetSeparatePairsList();
        Robj_interface_RJiHAsetSeparatePair[] suspendPairList = new RJiHAsetSeparatePair[this.applyInfo.size()];
        for (int i = 0; i < this.applyInfo.size(); ++i) {
            SJmoHAPairVolInfo pairInfo = (SJmoHAPairVolInfo)this.applyInfo.get(i);
            suspendPairList[i] = this.setSeparatePairToRmiData(pairInfo);
        }
        applyData.setPairParam(suspendPairList);
        RJiHAsetSeparatePair_IN inputIF = new RJiHAsetSeparatePair_IN();
        inputIF.setPairParam(applyData);
        ArrayList<RJiHAsetSeparatePair_IN> applyList = new ArrayList<RJiHAsetSeparatePair_IN>(1);
        applyList.add(inputIF);
        return applyList;
    }

    private RJiHAsetSeparatePair setSeparatePairToRmiData(SJmoHAPairVolInfo pairInfo) {
        RJiHAsetSeparatePair suspend1Pair = new RJiHAsetSeparatePair();
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
        int localSsid = SJctrHaUtility.getLocalExistenceSsid(localVol, this.ssidList);
        if (SJctrHaUtility.isSvol(pairInfo)) {
            suspend1Pair.setLU_P(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
            suspend1Pair.setLU_S(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
            suspend1Pair.setSN_P(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
            suspend1Pair.setSN_S(pairInfo.getStrPairSN());
            suspend1Pair.setSSID_P(localSsid);
            suspend1Pair.setSSID_S(pairInfo.getIPairSSID());
        } else {
            suspend1Pair.setLU_P(SJctrHaUtility.getRemoteRJiHAsetLU(pairInfo));
            suspend1Pair.setLU_S(SJctrHaUtility.getLocalRJiHAsetLU(localVol, this.portLunMap));
            suspend1Pair.setSN_P(pairInfo.getStrPairSN());
            suspend1Pair.setSN_S(SJctrComUtility.toPaddingZeroString(Integer.parseInt(this.subsystemInfoList.get(0).getDKCSNString()), 5));
            suspend1Pair.setSSID_P(pairInfo.getIPairSSID());
            suspend1Pair.setSSID_S(localSsid);
        }
        suspend1Pair.setAttr(pairInfo.getIAttribute());
        suspend1Pair.setMirror(pairInfo.getIMuNo());
        suspend1Pair.setKind(1);
        suspend1Pair.setRange(0);
        suspend1Pair.setGroup(pairInfo.getIGroup());
        suspend1Pair.setSwap(this.getSwapMode(pairInfo));
        suspend1Pair.setSuspended(this.ioMode);
        return suspend1Pair;
    }

    private int getSuspendIOModeRmiData(int iomode, boolean iocheck) {
        int ret = -1;
        if (iomode == 0) {
            ret = iocheck ? 0 : 1;
        } else if (iomode == 1) {
            ret = 2;
        }
        return ret;
    }

    private int getSwapMode(SJmoHAPairVolInfo pairinfo) {
        int iSwap = 0;
        if (SJctrHaUtility.isPvol(pairinfo)) {
            iSwap = 1;
        }
        return iSwap;
    }
}

