/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrSelectedRmPathTableDataModelBase;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropNumOfLunPathTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrRemotePairPropPathGroupTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.com.SJctrViewRemotePairPropertiesDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRJiHaPair;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrHaViewPairPropertiesPropertiesDataModel
extends SJctrSimpleDataModel {
    private static final String IMAGE_PATH_HI = "image/remote/";
    private static final String IMAGE_PATH_HP = "image/remote/hp/";
    private static final String BG_FILE_HA = "gp_ha_bkg.png";
    private static final String GP_ERROR_L = "image/remote/gp_error_l.png";
    private static final String COPY_DIRECTION = "image/remote/gp_ha_copy_direction.png";
    private String imageDirectory = "image/remote/";
    private List<RJiHAget1PairSummary> rmiPairList = null;
    private List<SJmoLdevDetail> ldevDetailList = null;
    private List<SJmoLdevNicknameInfo> ldevNameList = null;
    private List<SJmoClprInfo> clprList = null;
    private SJmoSubsystemInfo subsystemInfo = null;
    private SJmoRemoteReplicationMRCUInfoMgr mrcuMgr = null;

    public SJctrHaViewPairPropertiesPropertiesDataModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataModel("COM_LOCAL_STORAGE_SYSTEM_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_REMOTE_STORAGE_SYSTEM_INF", new SJctrSimpleDataModel());
        this.addDataModel("COM_TABLE_NUM_OF_PATHS", new SJctrRemotePairPropNumOfLunPathTableDataModel());
        this.addDataModel("COM_TABLE_PATH_GROUP", new SJctrRemotePairPropPathGroupTableDataModel());
    }

    @Override
    public void makeDataObject() {
        if (SJctrHaUtility.isHP()) {
            this.imageDirectory = IMAGE_PATH_HP;
        }
        this.rmiPairList = this.getDataController().getProxy().getCache(SJctrGetRJiHaPair.class);
        this.ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this.getDataController());
        Collections.sort(this.ldevDetailList);
        this.ldevNameList = SJctrReplicationUtility.getSJmoLdevNicknameInfo(this.getDataController());
        Collections.sort(this.ldevNameList);
        this.clprList = SJctrReplicationUtility.getSJmoClprInfo(this.getDataController());
        Collections.sort(this.clprList);
        this.subsystemInfo = SJctrHaUtility.getSJmoSubsystemInfo(this.getDataController());
        this.mrcuMgr = SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this.getDataController());
    }

    public void makeProperties(SJmoHAPairVolInfo pairInfo, SJctrDataController dc) {
        RJiHAget1PairSummary rmiPair = SJctrHaUtility.getRmiPairRelatedModelPair(this.rmiPairList, pairInfo);
        if (rmiPair == null) {
            this.logUty.putlog("makeProperties", "RMI Pair Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
        SJmoLdevDetail ldevDetail = null;
        int index = Collections.binarySearch(this.ldevDetailList, localVol);
        if (0 > index) {
            this.logUty.putlog("setLocalStorageSystemInfo", "LDEV Detail Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        ldevDetail = this.ldevDetailList.get(index);
        this.setCopyTypeImage();
        this.setConnectionInfo(pairInfo, rmiPair);
        this.setLocalStorageSystemInfo(localVol, rmiPair, pairInfo, ldevDetail, dc);
        this.setRemoteStorageSystemInfo(pairInfo, rmiPair, ldevDetail);
        SJctrRemotePairPropNumOfLunPathTableDataModel lunTable = (SJctrRemotePairPropNumOfLunPathTableDataModel)this.getDataModel("COM_TABLE_NUM_OF_PATHS");
        lunTable.updateNumOfPaths(localVol);
        SJctrRemotePairPropPathGroupTableDataModel pathGrpTable = (SJctrRemotePairPropPathGroupTableDataModel)this.getDataModel("COM_TABLE_PATH_GROUP");
        this.setPortAttribute(pairInfo);
        SJmoRemoteReplicationRCUInfo rcuInfo = SJctrHaUtility.getPairRcuInfoNoThrow(pairInfo, this.mrcuMgr);
        pathGrpTable.updatePathTable(rcuInfo);
    }

    private void setConnectionInfo(SJmoHAPairVolInfo remoteVol, RJiHAget1PairSummary rmiPair) {
        SJctrHaUtility haUty = this.getComUtility().getHaUtility();
        String status = haUty.getHaStatusString(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS", status);
        int statusIconId = SJctrHaUtility.getPairStatusIconId(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON", statusIconId);
        if (statusIconId == 16405) {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W", GP_ERROR_L);
        } else {
            ((SJctrDataObject)this.getManageData()).setData("COM_STATUS_ICON_W", "");
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_DIRECTION", COPY_DIRECTION);
        boolean pathLinkFlg = SJctrHaUtility.isSvol(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData(SJctrViewRemotePairPropertiesDataMacro.KEY_PATH_LINK_FLG, pathLinkFlg);
        String pathGrpStr = SJctrComUtility.toHexString(remoteVol.getIPathGroup(), 2, true);
        ((SJctrDataObject)this.getManageData()).setData("COM_PATH_GROUP", pathGrpStr);
        String mirrorID = haUty.getMirrorIdString(remoteVol);
        ((SJctrDataObject)this.getManageData()).setData("COM_MIRROR_ID_PAIR1", mirrorID);
    }

    private void setLocalStorageSystemInfo(SJmoReplicationPairVolInfo localVol, RJiHAget1PairSummary rmiPair, SJmoHAPairVolInfo remoteVol, SJmoLdevDetail ldevDetail, SJctrDataController dc) {
        SJctrSimpleDataModel localSysInfo = (SJctrSimpleDataModel)this.getDataModel("COM_LOCAL_STORAGE_SYSTEM_INF");
        SJctrHaUtility haUty = this.getComUtility().getHaUtility();
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        SJctrRemoteReplicationUtility remoteUty = this.getComUtility().getRemoteReplicationUtility();
        String ldevId = SJctrHaUtility.getLdevIdWithLdevName(localVol, this.ldevNameList, ldevUty);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_NUM_OF_PATHS", String.valueOf(ldevDetail.getILUPathNumber()));
        String provisioningType = ldevUty.toVolumeTypeDisplay(ldevDetail);
        String encrypted = remoteUty.getLocalEncryptedStr(ldevDetail);
        String t10pi = SJctrRemoteReplicationUtility.addDelimiter(remoteUty.getT10PIString(ldevDetail));
        if (!"".equals(encrypted)) {
            provisioningType = provisioningType + " , " + encrypted;
        }
        provisioningType = provisioningType + t10pi;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_PROVISIONING_TYPE", provisioningType);
        String ldevAttr = ldevUty.toLdevAttributeDisplay(ldevDetail);
        String emuCap = "";
        emuCap = ldevUty.isLdevAttributeNone(ldevAttr) ? this.getLocalCapacityStr(ldevDetail) : ldevAttr + " , " + this.getLocalCapacityStr(ldevDetail);
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", emuCap);
        int modelId = haUty.getModelIDfromSubsysInfo(this.subsystemInfo);
        String modelIdString = dc.getOwner().getProductName();
        String serialNumber = this.subsystemInfo.getDKCSNString();
        SJmoClprIndex clprIndex = new SJmoClprIndex();
        clprIndex.setSClpr(ldevDetail.getSCLPR());
        int index = Collections.binarySearch(this.clprList, clprIndex);
        String clprString = "?";
        if (0 <= index) {
            clprString = ldevUty.toClprDisplay(this.clprList.get(index));
        }
        String modelSnClpr = modelIdString + " / " + serialNumber + " , " + clprString;
        ((SJctrDataObject)localSysInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM_CLPR", modelSnClpr);
    }

    private void setRemoteStorageSystemInfo(SJmoHAPairVolInfo remoteVol, RJiHAget1PairSummary rmiPair, SJmoLdevDetail ldevDetail) {
        SJctrSimpleDataModel remoteStorageSystemInfo = (SJctrSimpleDataModel)this.getDataModel("COM_REMOTE_STORAGE_SYSTEM_INF");
        SJctrLdevUtility ldevUty = this.getComUtility().getLdevUtility();
        SJctrHaUtility remoteUty = this.getComUtility().getHaUtility();
        String ldevId = ldevUty.toLdevDisplay(remoteVol);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_LDEV_ID", ldevId);
        String portId = this.getComUtility().getGuidance("PORT_NAME_PART_CL");
        portId = portId + SJctrHaUtility.getPortNameMap(rmiPair.getPairModel()).get((short)rmiPair.getPairLU().getPortNo());
        String hgId = SJctrComUtility.toHexString(rmiPair.getPairLU().getGroupNo(), 2, true);
        String lunId = null;
        lunId = SJctrHaUtility.isLunDec(this.getDataController().getOwner().getUserSession()) ? String.valueOf(rmiPair.getPairLU().getLUN()) : SJctrComUtility.toHexString(rmiPair.getPairLU().getLUN(), 4, true);
        String portHgLun = portId + " / " + hgId + " / " + lunId;
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_PORT_HOSTGROUP_LUN", portHgLun);
        String cpacity = this.getLocalCapacityStr(ldevDetail);
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_EMULATION_TYPE_CAP", cpacity);
        String modelSnStr = remoteUty.getModelSNoString(rmiPair.getPairModel(), rmiPair.getPairSN());
        ((SJctrDataObject)remoteStorageSystemInfo.getManageData()).setData("COM_MODEL_SERIAL_NUM_SSID", modelSnStr);
    }

    private void setCopyTypeImage() {
        String copyTypeImage = this.imageDirectory + BG_FILE_HA;
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_TYPE_IMAGE", copyTypeImage);
    }

    private void setPortAttribute(SJmoHAPairVolInfo haPair) {
        int attribute = SJctrHaUtility.getPairPortAttribute(haPair);
        SJctrSelectedRmPathTableDataModelBase table = (SJctrSelectedRmPathTableDataModelBase)this.getDataModel("COM_TABLE_PATH_GROUP");
        table.setPortAttribute(attribute);
    }

    private String getLocalCapacityStr(SJmoLdevDetail ldevDetail) {
        String ret = "?";
        SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
        ret = capaUtil.toUnitString(ldevDetail.getLLDEVLBASize());
        return ret;
    }
}

