/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.comparator.SJctrHAPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrTrueCopyPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrHaViewPairPropertiesDC;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrTcViewPairPropertiesDC;
import sanproject.sn2.controller.wizard.replication.remote.viewpairprops.SJctrUrViewPairPropertiesDC;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorPairVolInfo;

public class SJctrItemSelectListenerViewPairProps
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            SJctrTableDataModel pairsTopTable = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
            if (pairsTopTable == null) {
                dc.getLogUty().putlog("selectChanged", "Top table data model is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            List<Object> selectedPairsList = pairsTopTable.getSelectedRowDataOrder();
            if (selectedPairsList == null || selectedPairsList.isEmpty()) {
                dc.getLogUty().putlog("selectChanged", "selectedPairsList is null.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            if (256 < selectedPairsList.size()) {
                dc.getLogUty().putlog("selectChanged", "Selected pairs is max.");
                SJctrError err = new SJctrError(210, 22, 206085);
                SJcException exp = err.createException();
                throw exp;
            }
            Object rowData = selectedPairsList.get(0);
            Class clazz = null;
            if (rowData instanceof SJmoTrueCopyPairVolInfo) {
                clazz = SJctrTcViewPairPropertiesDC.class;
                Collections.sort(selectedPairsList, new SJctrTrueCopyPairInfoComparator());
            } else if (rowData instanceof SJmoUniversalReplicatorPairVolInfo) {
                clazz = SJctrUrViewPairPropertiesDC.class;
                Collections.sort(selectedPairsList, new SJctrUniversalReplicatorPairInfoComparator());
            } else if (rowData instanceof SJmoHAPairVolInfo) {
                clazz = SJctrHaViewPairPropertiesDC.class;
                Collections.sort(selectedPairsList, new SJctrHAPairInfoComparator());
            } else {
                dc.getLogUty().putlog("selectChanged", "Unknown Copy Type.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Object> param = new ArrayList<Object>();
            HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
            paramMap.put("KEY_SELECTED_REMOTE_VOL", selectedPairsList);
            param.add(clazz);
            param.add(paramMap);
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_DIALOG_EX, param);
        }
    }
}

