/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.syslogbase.com;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrFileUploadInterface;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrCertificationFileTextBox;
import sanproject.syslog.enums.SyslogType;

public class SJctrSyslogCertificationFileUploader
implements SJctrFileUploadInterface {
    private static final int randomIndex = 0;
    private static final String RANDOM_FILE_BAR = "_";
    private SJctrCertificationFileTextBox fileData;
    private SyslogType syslogType;
    private SJctrDataController dc;
    private SJcException exp = null;

    public SJctrSyslogCertificationFileUploader(SJctrCertificationFileTextBox fileData, SyslogType syslogType, SJctrDataController dc) {
        this.dc = dc;
        this.fileData = fileData;
        this.syslogType = syslogType;
        this.exp = null;
    }

    public SJcException getExp() {
        return this.exp;
    }

    public void clearExp() {
        this.exp = null;
    }

    @Override
    public void fileUpload(ArrayList<String> fileList) {
        String randomFileName = "";
        SJcLogUty.getLogger().info("SJctrFileUploadInterface", "SJctrSyslogCertificationFileUpload", "fileUpload()", "Upload start.");
        randomFileName = fileList.get(0);
        this.fileData.setRandomFileName(randomFileName);
        try {
            this.fileData.upload(this.syslogType);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().info("SJctrFileUploadInterface", "SJctrSyslogCertificationFileUpload", "fileUpload()", "Upload failed.");
            throw e;
        }
        this.fileData.setValue(this.getOrgFileName());
        this.fileData.setFixed(true);
        this.fileData.setValueDefault(false);
        SJctrTextBoxDataModel password = this.fileData.getPasswordModel();
        if (password != null) {
            password.setFixed(false);
        }
        this.dc.setDirtyAll();
        SJcLogUty.getLogger().info("SJctrFileUploadInterface", "SJctrSyslogCertificationFileUpload", "fileUpload()", "Upload end.");
    }

    private String getOrgFileName() {
        String orgFileName = "";
        String fileName = this.fileData.getRandomFileName();
        int idx = fileName.indexOf(RANDOM_FILE_BAR);
        if (idx != -1) {
            orgFileName = fileName.substring(idx + 1);
        }
        return orgFileName;
    }
}

