/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.syslogbase.com;

import java.util.regex.Matcher;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogSettingDef;

public class SJctrSyslogUtility
implements SJctrSyslogSettingDef {
    public static void checkCertificationPassword(String pass) throws SJcException {
        if (pass.length() > 128) {
            SJctrSyslogUtility.errorMsg(205047);
        }
        if (pass.length() == 0) {
            return;
        }
        Matcher matcher = CERTIFICATION_PASS_USABLE_PATTERN.matcher(pass);
        if (!matcher.find()) {
            SJctrSyslogUtility.errorMsg(205047);
        }
    }

    public static void checkPortNumber(String portNum) throws SJcException {
        int port = 0;
        try {
            port = Integer.valueOf(portNum);
        }
        catch (NumberFormatException e) {
            SJctrSyslogUtility.errorMsg(205043);
        }
        if (1 > port || 65535 < port) {
            SJctrSyslogUtility.errorMsg(205043);
        }
    }

    public static void checkTimeout(String strTimeout) throws SJcException {
        int timeout = 0;
        try {
            timeout = Integer.valueOf(strTimeout);
        }
        catch (NumberFormatException e) {
            SJctrSyslogUtility.errorMsg(205044);
        }
        if (1 > timeout || 120 < timeout) {
            SJctrSyslogUtility.errorMsg(205044);
        }
    }

    public static void checkRetryInterval(String strInterval) throws SJcException {
        int interval = 0;
        try {
            interval = Integer.valueOf(strInterval);
        }
        catch (NumberFormatException e) {
            SJctrSyslogUtility.errorMsg(205045);
        }
        if (1 > interval || 60 < interval) {
            SJctrSyslogUtility.errorMsg(205045);
        }
    }

    public static void checkNumOfRetries(String strRetries) throws SJcException {
        int retries = 0;
        try {
            retries = Integer.valueOf(strRetries);
        }
        catch (NumberFormatException e) {
            SJctrSyslogUtility.errorMsg(205046);
        }
        if (1 > retries || 50 < retries) {
            SJctrSyslogUtility.errorMsg(205046);
        }
    }

    public static void checkLocationIdentificationName(String location) throws SJcException {
        Matcher matcher;
        if (location.length() > 32) {
            SJctrSyslogUtility.errorMsg(105430);
        }
        if (!(matcher = LOCATION_IDENTIFICATION_USABLE_PATTERN.matcher(location)).find()) {
            SJctrSyslogUtility.errorMsg(105430);
        }
    }

    public static String paddingZeroHead(String subStr, int length) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            buf.append("0");
        }
        if (subStr == null || length <= 0) {
            return buf.toString();
        }
        if (subStr.length() > length) {
            return subStr;
        }
        buf.append(subStr);
        int bufSize = buf.length();
        return buf.substring(bufSize - length, bufSize);
    }

    private static void errorMsg(int error) {
        SJctrError err = new SJctrError(7, 22, error);
        SJcException exp = err.createException();
        throw exp;
    }

    public static void errorMsg(int func, int module, int error) {
        SJctrError err = new SJctrError(func, module, error);
        SJcException exp = err.createException();
        throw exp;
    }

    public static void errorMsg(int func, int module, int error, String[] msg_arg, String[] measure_arg) {
        SJctrError err = new SJctrError(func, module, error);
        err.setMsgArgument(msg_arg);
        err.setMeansureArgument(measure_arg);
        SJcException exp = err.createException();
        throw exp;
    }
}

