/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.syslogbase.dc;

import java.util.LinkedHashMap;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.concrete.SJctrEnableDisableRadioButtonModel;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogCertificationFileUploader;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogSettingData;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogSettingDef;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogUtility;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrCertificationFileTextBox;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrPrimaryServerSettingDataModel;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrSecondaryServerSettingDataModel;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrSyslogServerSettingDataModel;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrTransferProtcolRadioButtonModel;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.sub.SJctrTabManageSubDC;
import sanproject.syslog.enums.SyslogType;

public abstract class SJctrSyslogSettingBaseSubDC
extends SJctrTabManageSubDC
implements SJctrSyslogSettingDef {
    public static final String GUID_PRIMARY_SERVER = "PRIMARY_SERVER";
    public static final String GUID_SECONDARY_SERVER = "SECONDARY_SERVER";
    private SyslogType syslogType;
    protected SJctrTransferProtcolRadioButtonModel transfer;
    protected SJctrEnableDisableRadioButtonModel primary;
    protected SJctrPrimaryServerSettingDataModel primarySrv;
    protected SJctrEnableDisableRadioButtonModel secondary;
    protected SJctrSecondaryServerSettingDataModel secondarySrv;
    protected SJctrTextBoxDataModel location;
    protected SJctrTextBoxDataModel timeout;
    protected SJctrTextBoxDataModel interval;
    protected SJctrTextBoxDataModel retries;
    protected SJctrCheckBoxDataModel edited;
    protected SJctrSyslogCertificationFileUploader fileUpload;
    protected boolean isRequiredPrimaryFile = false;
    protected boolean isRequiredSecondaryFile = false;

    protected SJctrSyslogSettingBaseSubDC(SJctrTabManageDataController managerDC, SyslogType syslogType) throws SJcException {
        super(managerDC);
        this.syslogType = syslogType;
    }

    public Map<String, SJctrDataObjectModel<?>> getBaseDataObjects() {
        LinkedHashMap map = new LinkedHashMap();
        this.transfer = new SJctrTransferProtcolRadioButtonModel();
        map.put("COM_PROTOCOL_RADIO", this.transfer);
        this.primary = new SJctrEnableDisableRadioButtonModel();
        map.put("COM_PRIMARY_RADIO_SYSLOG", this.primary);
        this.primarySrv = new SJctrPrimaryServerSettingDataModel();
        map.put("COM_PRIMARY_SYSLOG", this.primarySrv);
        this.secondary = new SJctrEnableDisableRadioButtonModel();
        map.put("COM_SECONDARY_RADIO_SYSLOG", this.secondary);
        this.secondarySrv = new SJctrSecondaryServerSettingDataModel();
        map.put("COM_SECONDARY_SYSLOG", this.secondarySrv);
        this.location = new SJctrTextBoxDataModel();
        map.put("COM_LOCATION", this.location);
        this.timeout = new SJctrTextBoxDataModel();
        map.put("COM_TIMEOUT", this.timeout);
        this.interval = new SJctrTextBoxDataModel();
        map.put("COM_RETRY_INTERVAL", this.interval);
        this.retries = new SJctrTextBoxDataModel();
        map.put("COM_NUM_OF_RETRIES", this.retries);
        this.edited = new SJctrCheckBoxDataModel();
        map.put("COM_SYSLOG_EDITED", this.edited);
        return map;
    }

    public void checkRequiredFile() {
        boolean isTLS;
        boolean bl = isTLS = this.transfer.getSelected() == 2;
        if (!isTLS || !this.primary.isSelectedEnable()) {
            this.isRequiredPrimaryFile = true;
        }
        if (!isTLS || !this.secondary.isSelectedEnable()) {
            this.isRequiredSecondaryFile = true;
        }
    }

    public boolean checkEndBaseData() throws SJcException {
        boolean isTLS;
        if (!this.edited.isSelect()) {
            return true;
        }
        boolean bl = isTLS = this.transfer.getSelected() == 2;
        if (this.primary.isSelectedEnable()) {
            this.checkServerStatus(this.primarySrv, isTLS, GUID_PRIMARY_SERVER, this.isRequiredPrimaryFile);
        }
        if (this.secondary.isSelectedEnable()) {
            this.checkServerStatus(this.secondarySrv, isTLS, GUID_SECONDARY_SERVER, this.isRequiredSecondaryFile);
        }
        if (this.primary.isSelectedEnable() && this.secondary.isSelectedEnable()) {
            boolean isSame = this.primarySrv.getIPAddress().equals(this.secondarySrv.getIPAddress());
            if (isSame &= this.primarySrv.getPortNum().equals(this.secondarySrv.getPortNum())) {
                SJctrSyslogUtility.errorMsg(7, 22, 205042);
            }
        }
        SJctrSyslogUtility.checkLocationIdentificationName(this.location.getValue());
        if (isTLS) {
            SJctrSyslogUtility.checkTimeout(this.timeout.getValue());
            SJctrSyslogUtility.checkRetryInterval(this.interval.getValue());
            SJctrSyslogUtility.checkNumOfRetries(this.retries.getValue());
        }
        return true;
    }

    private void checkServerStatus(SJctrSyslogServerSettingDataModel srv, boolean isTLS, String guidID, boolean isRequiredFile) {
        SJctrComUtility util = this.getOwner().getComUtility();
        srv.checkIPAddress();
        SJctrSyslogUtility.checkPortNumber(srv.getPortNum());
        if (isTLS) {
            SJctrSyslogUtility.checkCertificationPassword(srv.getPassword());
            if (isRequiredFile) {
                if (srv.getClientFileTextModel().isDefault()) {
                    SJctrSyslogUtility.errorMsg(7, 22, 205056, new String[]{util.getGuidance(guidID)}, new String[0]);
                }
                if (srv.getRootFileTextModel().isDefault()) {
                    SJctrSyslogUtility.errorMsg(7, 22, 205057, new String[]{util.getGuidance(guidID)}, new String[0]);
                }
            }
        }
    }

    protected void setBaseInheritedData(SJctrSyslogSettingData syslogData) {
        syslogData.setTransportType(this.transfer.getSelected());
        syslogData.setEnabledPrimary(this.primary.isSelectedEnable());
        if (this.primary.isSelectedEnable()) {
            syslogData.setIpVersionPrimary(this.primarySrv.getIPVersion());
            syslogData.setIpTextPrimary(this.primarySrv.getIPAddress());
            syslogData.setPortNumPrimary(Integer.valueOf(this.primarySrv.getPortNum()));
            syslogData.setUploadedClientPrimary(!this.primarySrv.getClientFileTextModel().isDefault());
            syslogData.setClientFilePrimary(this.primarySrv.getClientFileTextModel().getValue());
            syslogData.setPassPrimary(this.primarySrv.getPassword());
            syslogData.setUploadedRootPrimary(!this.primarySrv.getRootFileTextModel().isDefault());
            syslogData.setRootFilePrimary(this.primarySrv.getRootFileTextModel().getValue());
        }
        syslogData.setEnabledSecondary(this.secondary.isSelectedEnable());
        if (this.secondary.isSelectedEnable()) {
            syslogData.setIpVersionSecondary(this.secondarySrv.getIPVersion());
            syslogData.setIpTextSecondary(this.secondarySrv.getIPAddress());
            syslogData.setPortNumSecondary(Integer.valueOf(this.secondarySrv.getPortNum()));
            syslogData.setUploadedClientSecondary(!this.secondarySrv.getClientFileTextModel().isDefault());
            syslogData.setClientFileSecondary(this.secondarySrv.getClientFileTextModel().getValue());
            syslogData.setPassSecondary(this.secondarySrv.getPassword());
            syslogData.setUploadedRootSecondary(!this.secondarySrv.getRootFileTextModel().isDefault());
            syslogData.setRootFileSecondary(this.secondarySrv.getRootFileTextModel().getValue());
        }
        syslogData.setLocation(this.location.getValue());
        if (this.transfer.getSelected() == 2) {
            syslogData.setTimeout(Integer.valueOf(this.timeout.getValue()));
            syslogData.setInterval(Integer.valueOf(this.interval.getValue()));
            syslogData.setNumOfRetries(Integer.valueOf(this.retries.getValue()));
        }
        syslogData.setEdited(this.edited.isSelect());
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(NOTIFY_SYSLOG_SETTINGS.PUSH_BROWSE_CLIENT_P, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSyslogSettingBaseSubDC.this.doActionBrowseClientPrimary();
            }
        });
        this.addMessageEventListener(NOTIFY_SYSLOG_SETTINGS.PUSH_BROWSE_ROOT_P, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSyslogSettingBaseSubDC.this.doActionBrowseRootPrimary();
            }
        });
        this.addMessageEventListener(NOTIFY_SYSLOG_SETTINGS.PUSH_BROWSE_CLIENT_S, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSyslogSettingBaseSubDC.this.doActionBrowseClientSecondary();
            }
        });
        this.addMessageEventListener(NOTIFY_SYSLOG_SETTINGS.PUSH_BROWSE_ROOT_S, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSyslogSettingBaseSubDC.this.doActionBrowseRootSecondary();
            }
        });
    }

    protected void openFileDialog(SJctrCertificationFileTextBox crt) {
        this.fileUpload = new SJctrSyslogCertificationFileUploader(crt, this.syslogType, this.getManagerDC());
        SJctrRelatedDispDataObject relatedDisp = null;
        relatedDisp = this.createFileUpload(this.fileUpload);
        this.addUpdateDisp(relatedDisp);
    }

    protected void doActionBrowseClientPrimary() {
        this.openFileDialog(this.primarySrv.getClientFileTextModel());
    }

    protected void doActionBrowseRootPrimary() {
        this.openFileDialog(this.primarySrv.getRootFileTextModel());
    }

    protected void doActionBrowseClientSecondary() {
        this.openFileDialog(this.secondarySrv.getClientFileTextModel());
    }

    protected void doActionBrowseRootSecondary() {
        this.openFileDialog(this.secondarySrv.getRootFileTextModel());
    }

    public static enum NOTIFY_SYSLOG_SETTINGS implements SJctrNotifyState
    {
        PUSH_BROWSE_CLIENT_P,
        PUSH_BROWSE_ROOT_P,
        PUSH_BROWSE_CLIENT_S,
        PUSH_BROWSE_ROOT_S;

    }
}

