/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;

public class SJctrSsidDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_SSID = "COM_SSID";
    private static final String KEY_SSID_BTN = "COM_SSID_BTN";
    public static final int INVALID_SSID = -1;

    public SJctrSsidDataModel() {
        this.initDataModel();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrTextBoxDataModel ssidTextBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_SSID);
        ssidTextBox.setMin("0004");
        ssidTextBox.setMax("FFFE");
    }

    protected void initDataModel() {
        this.addDataModel(KEY_SSID, new SJctrTextBoxDataModel());
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSsidDataModel.this.fireMessageEvent(SSID_MSG.VIEW_SSID);
            }
        });
        this.addDataModel(KEY_SSID_BTN, btn);
    }

    public int getSSIDValue() {
        int ssid = -1;
        SJctrTextBoxDataModel txtBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_SSID);
        String strSsid = txtBox.getValue();
        if (strSsid.length() != 0) {
            ssid = Integer.valueOf(strSsid, 16);
        }
        return ssid;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrTextBoxDataModel txtBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_SSID);
        txtBox.setValue("0004");
    }

    public static enum SSID_MSG implements SJctrNotifyState
    {
        VIEW_SSID;

    }
}

