/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;

public class SJctrLdevNumColumnFromExdVolumeInfo
extends SJctrColumn {
    protected Map<String, Integer> numberMap = null;

    public SJctrLdevNumColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("NUM_OF_LDEV");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExDVirtualPgInfo.class);
        list.add(SJmoGetExdVolumeInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoExDPgInfo> list = new ArrayList<SJmoExDPgInfo>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        SJctrVpgManager vpgMgr = (SJctrVpgManager)modelData.get(SJctrVpgManager.class).get(0);
        EXDExternalVolume rmiExdVol = volumeInfo.getRmiExdVolumeInfo();
        SJmoExDPgInfo pgInfo = vpgMgr.getVpgInfo(rmiExdVol.getIFB4(), rmiExdVol.getIPG());
        list.add(pgInfo);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoExDPgInfo exdPGInfo = (SJmoExDPgInfo)dataList.get(0);
        int num = 0;
        if (exdPGInfo != null) {
            num = exdPGInfo.getSNumOfLdev();
        }
        String strnum = SJctrComUtility.toDecString(num);
        if (this.numberMap == null) {
            this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
        }
        this.numberMap.put(strnum, num);
        return strnum;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        String strNum = this.getString(dat);
        return this.numberMap.get(strNum).intValue();
    }
}

