/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.column;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDLogicalPath_Fiber;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.uvm.com.SJctrExdPathGrpExdVolumeInfoTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;

public class SJctrLunColumnFromExdPathGrpExdVolumeInfoTableKey
extends SJctrColumn {
    protected HashMap<SJctrExdPathGrpExdVolumeInfoTableKey, EXDLogicalPath_Fiber> tableKeyMap = null;
    protected Map<String, Integer> numberMap = null;
    private boolean bDecDisplay = false;

    public SJctrLunColumnFromExdPathGrpExdVolumeInfoTableKey(String key) {
        super(key);
        this.setPartsId("LUN_ID");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrPortUtility.isLunIdDecimal(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExdSubsystemInfoMgr.class);
        list.add(SJmoGetExdProfileInfoMgr.class);
        list.add(SJmoGetExDVirtualPgInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<EXDLogicalPath_Fiber> list = new ArrayList<EXDLogicalPath_Fiber>();
        SJctrExdPathGrpExdVolumeInfoTableKey tableKey = (SJctrExdPathGrpExdVolumeInfoTableKey)index;
        EXDLogicalPath_Fiber logicalPath = (EXDLogicalPath_Fiber)tableKey.getLogicalPathInfo();
        if (this.tableKeyMap == null) {
            this.tableKeyMap = new HashMap(this.getTable().getRowCount());
        }
        this.tableKeyMap.put(tableKey, logicalPath);
        list.add(logicalPath);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        EXDLogicalPath_Fiber logicalPath = (EXDLogicalPath_Fiber)dataList.get(0);
        String strLun = "-";
        int lun = logicalPath.getLun();
        if (lun != -1) {
            strLun = this.bDecDisplay ? SJctrComUtility.toDecString(lun) : SJctrComUtility.toHexString(lun, 4, true);
        }
        if (this.numberMap == null) {
            this.numberMap = new HashMap<String, Integer>(this.getTable().getRowCount());
        }
        this.numberMap.put(strLun, lun);
        return strLun;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String getInputFormat() {
        String ret = "^([0-9A-Fa-f]{1,4})$";
        if (this.bDecDisplay) {
            ret = "^\\d{1,19}$";
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        if (!strNum.equals("?")) {
            num = this.numberMap.get(strNum);
        }
        return num;
    }
}

