/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.data.SJmoModelData_Base;

public abstract class SJctrDefaultUvmManager
implements SJctrUvmManager {
    protected static final int MSG_INTERNAL_ERR = 0;
    protected static final int ID_OFFSET_UNCONFIGURED = -2;
    private SJctrDataController dataController;
    private Map<Class<? extends SJctrUvmManager>, SJctrUvmManager> uvmManagerMap;

    public static <T extends SJmoModelData_Base> List<T> createCloneList(List<T> srcList) {
        List dstList;
        if (srcList != null) {
            int size = srcList.size();
            dstList = new ArrayList(size);
            try {
                for (int i = 0; i < size; ++i) {
                    SJmoModelData_Base src = (SJmoModelData_Base)srcList.get(i);
                    SJmoModelData_Base dst = (SJmoModelData_Base)src.clone();
                    dstList.add(dst);
                }
            }
            catch (CloneNotSupportedException e) {
                SJctrError error = new SJctrError(6, 22, 0);
                throw error.createException();
            }
        } else {
            dstList = Collections.emptyList();
        }
        return dstList;
    }

    @Override
    public final void setDataController(SJctrDataController dc) {
        this.dataController = dc;
    }

    @Override
    public final void setRelatedManager(Map<Class<? extends SJctrUvmManager>, SJctrUvmManager> managerMap) {
        this.uvmManagerMap = managerMap;
    }

    protected final SJctrDataController getDataController() {
        return this.dataController;
    }

    protected final <T extends SJctrUvmManager> T getManager(Class<T> mgrClass) {
        return (T)this.uvmManagerMap.get(mgrClass);
    }

    protected final SJctrComUtility getComUtility() {
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrComUtility utility = null;
        if (uc != null) {
            utility = uc.getComUtility();
        }
        return utility;
    }
}

