/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManagerUser;

public class SJctrDefaultUvmManagerUser
implements SJctrUvmManagerUser {
    private SJctrWizardDataController wizardDc;
    private Map<Class<? extends SJctrUvmManager>, SJctrUvmManager> uvmManagerMap;
    private Map<Class<? extends SJctrUvmManager>, SJctrUvmManager> unmodifiableMap;
    private List<SJctrUvmManager> initManagerList;
    private Map<SJctrUvmManager, Collection<SJctrGetDirectWrapper>> divideMap;

    public SJctrDefaultUvmManagerUser(SJctrWizardDataController dc) {
        this.wizardDc = dc;
        this.uvmManagerMap = new HashMap<Class<? extends SJctrUvmManager>, SJctrUvmManager>();
        this.unmodifiableMap = Collections.unmodifiableMap(this.uvmManagerMap);
        this.initManagerList = new ArrayList<SJctrUvmManager>();
        this.divideMap = Collections.emptyMap();
    }

    public void registerManager() {
        Set<Class<? extends SJctrUvmManager>> targetSet = this.uvmManagerMap.keySet();
        while (targetSet.size() > 0) {
            targetSet = this.registerManager(targetSet);
            targetSet.removeAll(this.uvmManagerMap.keySet());
        }
    }

    private Set<Class<? extends SJctrUvmManager>> registerManager(Set<Class<? extends SJctrUvmManager>> targetSet) {
        HashSet<Class<? extends SJctrUvmManager>> relatedSet = new HashSet<Class<? extends SJctrUvmManager>>();
        for (Class<? extends SJctrUvmManager> mgrClass : targetSet) {
            SJctrUvmManager manager = null;
            List<?> list = this.wizardDc.getCache(mgrClass);
            if (list != null && list.size() > 0) {
                manager = (SJctrUvmManager)list.get(0);
            }
            if (manager == null) {
                manager = this.createManager(mgrClass);
                this.initManagerList.add(manager);
                ArrayList<SJctrUvmManager> managerList = new ArrayList<SJctrUvmManager>();
                managerList.add(manager);
                this.wizardDc.putCache(mgrClass, managerList);
                List<Class<? extends SJctrUvmManager>> relatedManagers = manager.getRelatedManager();
                if (relatedManagers != null) {
                    relatedSet.addAll(relatedManagers);
                }
            }
            this.uvmManagerMap.put(mgrClass, manager);
        }
        return relatedSet;
    }

    private <T extends SJctrUvmManager> T createManager(Class<T> mgrClass) throws SJcException {
        SJctrUvmManager manager = null;
        try {
            manager = (SJctrUvmManager)mgrClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            SJctrError error = new SJctrError(0, 0, 0);
            throw error.createException();
        }
        return (T)manager;
    }

    public void initManager() {
        for (SJctrUvmManager manager : this.initManagerList) {
            manager.setRelatedManager(this.unmodifiableMap);
            manager.setDataController(this.wizardDc);
            manager.initialize();
        }
        this.initManagerList.clear();
    }

    public void startManager() {
        for (SJctrUvmManager manager : this.uvmManagerMap.values()) {
            manager.setRelatedManager(this.unmodifiableMap);
            manager.setDataController(this.wizardDc);
        }
    }

    @Override
    public void addManager(Class<? extends SJctrUvmManager> mgrClass) {
        this.uvmManagerMap.put(mgrClass, null);
    }

    @Override
    public <T extends SJctrUvmManager> T getManager(Class<T> mgrClass) {
        return (T)this.uvmManagerMap.get(mgrClass);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        this.divideMap = new HashMap<SJctrUvmManager, Collection<SJctrGetDirectWrapper>>();
        for (SJctrUvmManager manager : this.uvmManagerMap.values()) {
            List<SJctrGetDirectWrapper> wrappers = manager.getModelDirect();
            if (wrappers == null) continue;
            retSet.addAll(wrappers);
            this.divideMap.put(manager, wrappers);
        }
        return retSet;
    }

    @Override
    public void divideManagerData(Map<SJctrGetDirectWrapper, List<?>> models) {
        for (Map.Entry<SJctrUvmManager, Collection<SJctrGetDirectWrapper>> entry : this.divideMap.entrySet()) {
            HashMap cacheMap = new HashMap();
            for (SJctrGetDirectWrapper wrapper : entry.getValue()) {
                String key = wrapper.getCacheKey();
                List<?> getList = models.get(wrapper);
                cacheMap.put(key, getList);
            }
            SJctrUvmManager manager = entry.getKey();
            manager.divideModelData(cacheMap);
        }
        this.divideMap = Collections.emptyMap();
    }
}

