/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.uvm.com.SJctrEmulationTypeInfo;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetCuLdevIdInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoCuLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;

public class SJctrLdevManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    private static final int INVALID = -1;
    private List<SJmoCuLdevIdInfo> ldevIdInfoList;
    private SJmoRscUtilLdev rscLdevUtil;
    private SJmoRSGgetAllRsgs allRsgs;
    private SJctrResourceGroupUtility rsgUtil;

    public SJctrLdevManager() {
        this.initField();
    }

    private void initField() {
        this.ldevIdInfoList = Collections.emptyList();
        this.rscLdevUtil = null;
        this.allRsgs = null;
        this.rsgUtil = null;
    }

    public List<SJmoCuLdevIdInfo> getLdevIdInfoList() {
        return this.ldevIdInfoList;
    }

    private SJctrResourceGroupUtility getResourceUtility() {
        if (this.rsgUtil == null) {
            SJctrUserController uc = this.getDataController().getOwner();
            this.rsgUtil = new SJctrResourceGroupUtility(uc, this.allRsgs);
        }
        return this.rsgUtil;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetCuLdevIdInfo();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetRscUtilLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<SJmoCuLdevIdInfo> getList;
        if (this.ldevIdInfoList.isEmpty() && (getList = models.get(SJmoGetCuLdevIdInfo.class.getName())) != null && getList.size() > 0) {
            this.ldevIdInfoList = SJctrLdevManager.cloneLDEVID(getList);
        }
        if ((getList = models.get(SJmoGetRscUtilLdev.class.getName())) != null && getList.size() > 0) {
            this.rscLdevUtil = (SJmoRscUtilLdev)((Object)getList.get(0));
        }
        if ((getList = models.get(SJmoGetRSGgetAllRsgs.class.getName())) != null && getList.size() > 0) {
            this.allRsgs = (SJmoRSGgetAllRsgs)((Object)getList.get(0));
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
    }

    public boolean setLdevId(SJmoLdevDetail ldevDetail, SJctrEmulationTypeInfo emu, SJmoLdevIndex startIndex, int interval, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vLdevList) {
        int emulationGroup = emu.getEmulationGroup();
        List<SJmoCuLdevIdInfo> ldevIdList = this.getLdevIdInfoList();
        int emuTypeId = emu.getEmulationId();
        SJmoLdevIndex setIndex = startIndex;
        if (this.isInvalidIndex(setIndex = this.incrementIntervalLdevIndex(setIndex, emulationGroup, ldevIdList, emuTypeId, interval, cvsUty, vLdevList))) {
            return false;
        }
        short ldkc = setIndex.getSLdkc();
        short cu = setIndex.getSCu();
        short ldev = setIndex.getSLdev();
        SJctrCVSUtility.createLDEVID(ldkc, cu, ldev, emulationGroup, ldevIdList);
        ldevDetail.setLdevIndex(ldkc, cu, ldev);
        ldevDetail.setIEmulationType(emuTypeId);
        ldevDetail.setIDataMode(2);
        return true;
    }

    private SJmoLdevIndex incrementIntervalLdevIndex(SJmoLdevIndex index, int emulationGroup, List<SJmoCuLdevIdInfo> ldevIdList, int emuTypeId, int interval, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        SJmoLdevIndex retIndex = index;
        for (int i = 0; i < interval + 1; ++i) {
            if (i != 0) {
                this.incrementLdevIndex(retIndex);
            }
            if (this.isInvalidIndex(retIndex = SJctrCVSUtility.getFreeLDEV(retIndex.getSLdkc(), retIndex.getSCu(), retIndex.getSLdev(), emulationGroup, ldevIdList, emuTypeId, this.rscLdevUtil, this.getResourceUtility(), 0, cvsUty, vldevList))) break;
        }
        return retIndex;
    }

    private void incrementLdevIndex(SJmoLdevIndex index) {
        int value = SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC * index.getSLdkc() + SJmoDataMacro_IF.MAX_EQIP_LDEV_CU * index.getSCu() + index.getSLdev();
        if (++value < SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC) {
            short nextLdkc = (short)(value / SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC);
            short nextCu = (short)(value % SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC / SJmoDataMacro_IF.MAX_EQIP_LDEV_CU);
            short nextLdev = (short)(value % SJmoDataMacro_IF.MAX_EQIP_LDEV_CU);
            index.setLdevIndex(nextLdkc, nextCu, nextLdev);
        } else {
            index.setLdevIndex((short)-1, (short)-1, (short)-1);
        }
    }

    private boolean isInvalidIndex(SJmoLdevIndex index) {
        return index.getSLdkc() == -1 || index.getSCu() == -1 || index.getSLdev() == -1;
    }

    public void removeLdevId(List<?> ldevList) {
        List<SJmoCuLdevIdInfo> ldevIdList = this.getLdevIdInfoList();
        for (Object obj : ldevList) {
            SJmoLdevIndex ldevIndex = (SJmoLdevIndex)obj;
            SJctrCVSUtility.deleteLdevID(ldevIndex, ldevIdList);
        }
    }

    public static List<SJmoCuLdevIdInfo> cloneLDEVID(List<SJmoCuLdevIdInfo> LDEVID) {
        ArrayList<SJmoCuLdevIdInfo> rtn = new ArrayList<SJmoCuLdevIdInfo>(LDEVID.size());
        Iterator<SJmoCuLdevIdInfo> i$ = LDEVID.iterator();
        while (i$.hasNext()) {
            SJmoCuLdevIdInfo culdevidinfo;
            SJmoCuLdevIdInfo ldevID = culdevidinfo = i$.next();
            SJmoCuLdevIdInfo newLDEVID = new SJmoCuLdevIdInfo();
            newLDEVID.setCuIndex(ldevID.getSLdkc(), ldevID.getSCu());
            newLDEVID.setIDataMode(ldevID.getIDataMode());
            SJmoLdevIdInfo[] ldev = ldevID.getLDEVIDInfo();
            SJmoLdevIdInfo[] newldev = new SJmoLdevIdInfo[ldev.length];
            for (int i = 0; i < ldev.length; ++i) {
                newldev[i] = new SJmoLdevIdInfo();
                newldev[i].setEmulationGroup(ldev[i].getEmulationGroup());
                newldev[i].setIDataMode(ldev[i].getIDataMode());
                newldev[i].setLDEVID(ldev[i].getLDEVID());
                newldev[i].setLdevIndex(ldev[i].getSLdkc(), ldev[i].getSCu(), ldev[i].getSLdev());
            }
            newLDEVID.setLDEVIDInfo(newldev);
            rtn.add(newLDEVID);
        }
        return rtn;
    }
}

