/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrUvmManager;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilPg;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.modelrc.util.SJmoRscUtilPg;

public class SJctrVpgManager
extends SJctrDefaultUvmManager
implements SJctrUvmManager {
    public static final int EXG_OFFSET = 100;
    public static final int EXG_MIN = 101;
    public static final int EXG_MAX = 16484;
    public static final int VPG_MIN = 1;
    public static final int VPG_MAX = 4096;
    private static final int INVALID = 0;
    private List<SJmoExDPgInfo> exdPgList;
    private Map<String, SJmoExDPgInfo> exdPgMap;
    private Map<Integer, ExgData> usedExgVpg;
    private int maxVpgCount;
    private SJmoRscUtilPg rscPGUtil;

    public SJctrVpgManager() {
        this.initField();
    }

    private void initField() {
        this.exdPgList = Collections.emptyList();
        this.exdPgMap = Collections.emptyMap();
        this.usedExgVpg = new HashMap<Integer, ExgData>();
        this.rscPGUtil = null;
    }

    public List<SJmoExDPgInfo> getExdPgList() {
        return this.exdPgList;
    }

    @Override
    public List<SJctrGetDirectWrapper> getModelDirect() {
        ArrayList<SJctrGetDirectWrapper> retList = new ArrayList<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetExDVirtualPgInfo();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        kind = new SJmoGetRscUtilPg();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct);
        retList.add(wrapper);
        return retList;
    }

    @Override
    public void divideModelData(Map<String, List<?>> models) {
        List<?> getList = models.get(SJmoGetExDVirtualPgInfo.class.getName());
        if (getList != null && getList.size() > 0) {
            SJmoExDVirtualPgInfo virtualInfo = (SJmoExDVirtualPgInfo)getList.get(0);
            this.exdPgList = virtualInfo.getAlVpgForExd();
            this.maxVpgCount = virtualInfo.getNumOfEmptyVirtualPg();
            this.maxVpgCount += this.exdPgList.size();
        }
        if ((getList = models.get(SJmoGetRscUtilPg.class.getName())) != null && getList.size() > 0) {
            this.rscPGUtil = (SJmoRscUtilPg)getList.get(0);
        }
    }

    @Override
    public List<Class<? extends SJctrUvmManager>> getRelatedManager() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() throws SJcException {
        List<SJmoExDPgInfo> list = this.getExdPgList();
        int size = list.size();
        this.exdPgMap = new HashMap<String, SJmoExDPgInfo>(size * 4 / 3 + 1);
        Integer exgKey = 100;
        ExgData exgData = null;
        for (int i = 0; i < size; ++i) {
            SJmoExDPgInfo exdPg = list.get(i);
            String key = exdPg.getIndexKey();
            this.exdPgMap.put(key, exdPg);
            int exg = exdPg.getFB4();
            int vpg = exdPg.getPG();
            if (exgKey != exg) {
                exgKey = exg;
                exgData = this.getExgData(exgKey);
            }
            exgData.createVpg(vpg);
        }
    }

    public boolean addVpgInfo(int exgId, int vpgId, SJmoExDPgInfo vpgInfo) {
        if (this.remainPgCount() <= 0) {
            return false;
        }
        if (!SJctrVpgManager.checkExg(exgId) || !SJctrVpgManager.checkVpg(vpgId)) {
            return false;
        }
        SJmoPgIndex index = new SJmoPgIndex();
        for (int exg = exgId; exg <= 16484; ++exg) {
            int startVpg;
            index.setFB4(exg);
            ExgData exgData = this.getExgData(exg);
            for (int vpg = startVpg = this.getStartVpg(exgId, vpgId, exg, exgData.getStartVpg()); vpg <= 4096; ++vpg) {
                index.setPG(vpg);
                String key = index.makeIndexKey();
                if (this.exdPgMap.containsKey(key) || this.rscPGUtil.chkPgID(exg, vpg) != 0) continue;
                vpgInfo.setFB4(exg);
                vpgInfo.setPG(vpg);
                this.exdPgMap.put(key, vpgInfo);
                exgData.createVpg(vpg);
                return true;
            }
        }
        this.setInvalidValue(vpgInfo);
        return false;
    }

    private ExgData getExgData(Integer exg) {
        ExgData exgData = this.usedExgVpg.get(exg);
        if (exgData == null) {
            exgData = new ExgData();
            this.usedExgVpg.put(exg, exgData);
        }
        return exgData;
    }

    private int getStartVpg(int startExg, int startVpg, int exg, int vpg) {
        int retValue = startExg == exg ? Math.max(startVpg, vpg) : vpg;
        return retValue;
    }

    private void setInvalidValue(SJmoPgIndex index) {
        index.setFB4(0);
        index.setPG(0);
    }

    public SJmoExDPgInfo getVpgInfo(int exgId, int vpgId) {
        SJmoPgIndex index = new SJmoPgIndex();
        index.setFB4(exgId);
        index.setPG(vpgId);
        return this.getVpgInfo(index);
    }

    public SJmoExDPgInfo getVpgInfo(SJmoPgIndex index) {
        String key = index.makeIndexKey();
        return this.exdPgMap.get(key);
    }

    public void removeVpgInfo(SJmoPgIndex index) {
        String key = index.makeIndexKey();
        if (this.exdPgMap.remove(key) != null) {
            ExgData exgData = this.getExgData(index.getFB4());
            exgData.removeVpg(index.getPG());
            this.setInvalidValue(index);
        }
    }

    public void removeVpgInfo(List<? extends SJmoPgIndex> indexList) {
        int size = indexList.size();
        for (int i = 0; i < size; ++i) {
            SJmoPgIndex index = indexList.get(i);
            this.removeVpgInfo(index);
        }
    }

    public ChangeVpgData changeVpgInfo(int exgId, int vpgId, List<SJmoExDPgInfo> vpgInfoList) {
        ChangeVpgData resultData = new ChangeVpgData(vpgInfoList);
        this.removeVpgInfo(vpgInfoList);
        int size = vpgInfoList.size();
        for (int i = 0; i < size; ++i) {
            SJmoExDPgInfo vpgInfo = vpgInfoList.get(i);
            boolean result = this.addVpgInfo(exgId, vpgId, vpgInfo);
            if (result) {
                resultData.addOk(vpgInfo);
                continue;
            }
            resultData.addNg(vpgInfo);
        }
        return resultData;
    }

    public boolean restoreVpgInfo(ChangeVpgData restoreData) {
        this.removeVpgInfo(restoreData.getOkVpgList());
        List vpgInfoList = restoreData.getChangeVpgList();
        List backUpList = restoreData.getBackUpIndexList();
        boolean result = true;
        int size = vpgInfoList.size();
        for (int i = 0; i < size; ++i) {
            SJmoPgIndex index = (SJmoPgIndex)backUpList.get(i);
            SJmoExDPgInfo vpgInfo = (SJmoExDPgInfo)vpgInfoList.get(i);
            result = this.addVpgInfo(index.getFB4(), index.getPG(), vpgInfo);
            if (!result) break;
        }
        return result;
    }

    public int getPgCount() {
        return this.exdPgMap.size();
    }

    public int remainPgCount() {
        return this.maxVpgCount - this.getPgCount();
    }

    public static boolean checkExg(int exg) {
        return 101 <= exg && exg <= 16484;
    }

    public static boolean checkVpg(int vpg) {
        return 1 <= vpg && vpg <= 4096;
    }

    private static class ExgData {
        private int consecutiveVpg = 0;

        private ExgData() {
        }

        public void createVpg(int vpg) {
            if (this.consecutiveVpg == vpg - 1) {
                ++this.consecutiveVpg;
            }
        }

        public void removeVpg(int vpg) {
            if (this.consecutiveVpg > vpg - 1) {
                this.consecutiveVpg = vpg - 1;
            }
        }

        public int getStartVpg() {
            return this.consecutiveVpg + 1;
        }
    }

    public static class ChangeVpgData {
        private final List<SJmoExDPgInfo> vpgInfoList;
        private final List<SJmoPgIndex> backUpIndexList;
        private final List<SJmoExDPgInfo> okList;
        private final List<SJmoExDPgInfo> ngList;

        private ChangeVpgData(List<SJmoExDPgInfo> vpgList) {
            int size = vpgList.size();
            this.vpgInfoList = vpgList;
            this.backUpIndexList = this.createIndexList(vpgList);
            this.okList = new ArrayList<SJmoExDPgInfo>(size);
            this.ngList = new ArrayList<SJmoExDPgInfo>(size);
        }

        private List<SJmoPgIndex> createIndexList(List<? extends SJmoPgIndex> srcIndexList) {
            int size = srcIndexList.size();
            ArrayList<SJmoPgIndex> dstIndexList = new ArrayList<SJmoPgIndex>(size);
            for (int i = 0; i < size; ++i) {
                SJmoPgIndex srcIndex = srcIndexList.get(i);
                SJmoPgIndex dstIndex = new SJmoPgIndex();
                dstIndex.setFB4(srcIndex.getFB4());
                dstIndex.setPG(srcIndex.getPG());
                dstIndexList.add(dstIndex);
            }
            return dstIndexList;
        }

        private void addOk(SJmoExDPgInfo info) {
            this.okList.add(info);
        }

        private void addNg(SJmoExDPgInfo info) {
            this.ngList.add(info);
        }

        private List<SJmoExDPgInfo> getChangeVpgList() {
            return this.vpgInfoList;
        }

        private List<SJmoPgIndex> getBackUpIndexList() {
            return this.backUpIndexList;
        }

        private List<SJmoExDPgInfo> getOkVpgList() {
            return this.okList;
        }

        public List<SJmoExDPgInfo> getNgVpgList() {
            return this.ngList;
        }

        public boolean isResult() {
            return this.ngList.isEmpty();
        }
    }
}

