/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDExternalDeviceEx;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalVolumeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrVpgManager;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrCacheModeDataModel;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrEditExtVolsConfirmData;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrEditExtVolsSubWizard;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrInflowCtrlDataModel;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrLoadBalanceModeDataModel;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrUseAluaDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;

public class SJctrEditExtVolsDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 17826401;
    private static final String KEY_CACHEMODEINF = "COM_CACHEMODEINF";
    private static final String KEY_INFCTLINF = "COM_INFCTLINF";
    private static final String KEY_ALUAINF = "COM_ALUAINF";
    private static final String KEY_LBM_INF = "COM_LBM_INF";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final String TITLE = "DISP_DI26S_TITLE";
    List<SJmoExdVolumeInfo> editExtVolsList = null;
    SJctrCacheModeDataModel cacheModeDataModel = null;
    SJctrInflowCtrlDataModel inflowCtrlDataModel = null;
    SJctrUseAluaDataModel aluaDataModel = null;
    SJctrLoadBalanceModeDataModel lbmDataModel = null;
    private Byte pathMode = null;
    public static int RESULT_NORMAL = 0;
    public static int EDITEXTVOLS_NOT_FOUND_PARAM = 107001;
    public static int EDITEXTVOLS_NOT_FOUND_MODEL = 107018;
    public static int EDITEXTVOLS_NOT_EQUIP = 106529;
    public static int EDITEXTVOLS_NOT_ENABLE_CMD = 106057;
    public static int EDITEXTVOLS_NOT_SELECT_RADIOBTN = 105234;
    public static int EDITEXTVOLS_UNUSABLE_PG = 105269;
    public static int EDITEXTVOLS_SET_INVALID_VALUE = 105461;
    public static int EDITEXTVOLS_MIX_CACHE_MODE = 209013;

    public SJctrEditExtVolsDC() throws SJcException {
        super(17826401);
        this.initDataModel();
        this.initManager();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_CACHEMODEINF, new SJctrCacheModeDataModel());
        this.addDataObjectModel(KEY_INFCTLINF, new SJctrInflowCtrlDataModel());
        this.addDataObjectModel(KEY_ALUAINF, new SJctrUseAluaDataModel());
        this.addDataObjectModel(KEY_LBM_INF, new SJctrLoadBalanceModeDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrEditExtVolsSubWizard.EDIT_EXT_VOLS_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = EDITEXTVOLS_NOT_FOUND_PARAM;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoExdVolumeInfo) continue;
                errorCode = EDITEXTVOLS_NOT_FOUND_PARAM;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<?> dat = this.getCache(SJctrEditExtVolsSubWizard.EDIT_EXT_VOLS_DATA);
        this.editExtVolsList = dat;
        SJctrExternalVolumeManager extVolInfoMgr = this.getManager(SJctrExternalVolumeManager.class);
        if (extVolInfoMgr == null) {
            SJctrError err = new SJctrError(6, 22, EDITEXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoExdVolumeInfoOnPathGroup> extVolInfoList = extVolInfoMgr.getExternalVolumeList();
        SJctrUserController uc = this.getOwner();
        List<?> rsgInfoList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgInfoList == null || rsgInfoList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, EDITEXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgInfo);
        List<?> strageSystemMgrList = this.getCache(SJmoGetExdSubsystemInfoMgr.class);
        if (strageSystemMgrList == null || strageSystemMgrList.isEmpty()) {
            SJctrError err = new SJctrError(6, 22, EDITEXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdSubsystemInfoMgr strageSystemMgr = (SJmoExdSubsystemInfoMgr)strageSystemMgrList.get(0);
        List<?> profileMgrList = this.getCache(SJmoGetExdProfileInfoMgr.class);
        if (profileMgrList == null || profileMgrList.isEmpty()) {
            SJctrError err = new SJctrError(6, 22, EDITEXTVOLS_NOT_FOUND_MODEL);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoExdProfileInfoMgr profileMgr = (SJmoExdProfileInfoMgr)profileMgrList.get(0);
        SJctrExtUtility exdUtil = uc.getComUtility().getExtUtility();
        this.cacheModeDataModel = (SJctrCacheModeDataModel)this.getDataObjectModel(KEY_CACHEMODEINF);
        HashSet<String> btnMixCacheMode = new HashSet<String>();
        this.inflowCtrlDataModel = (SJctrInflowCtrlDataModel)this.getDataObjectModel(KEY_INFCTLINF);
        HashSet<String> btnMixInflowCtrls = new HashSet<String>();
        this.aluaDataModel = (SJctrUseAluaDataModel)this.getDataObjectModel(KEY_ALUAINF);
        HashSet<Boolean> mixALUA = new HashSet<Boolean>();
        this.lbmDataModel = (SJctrLoadBalanceModeDataModel)this.getDataObjectModel(KEY_LBM_INF);
        HashSet<Short> mixLBM = new HashSet<Short>();
        this.pathMode = null;
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.editExtVolsList.size());
        boolean odmSetting = false;
        for (SJmoExdVolumeInfo selectData : this.editExtVolsList) {
            int errorcode = 0;
            SJmoExdVolumeInfo selectVolume = selectData;
            boolean result = true;
            int fb4 = selectVolume.getRmiExdVolumeInfo().getIFB4();
            int vpg = selectVolume.getRmiExdVolumeInfo().getIPG();
            if (extVolInfoList.size() == 0) {
                result = false;
            } else {
                boolean found = false;
                for (SJmoExdVolumeInfoOnPathGroup extVolInfo : extVolInfoList) {
                    SJmoExdVolumeInfo volume = extVolInfo.getExdVolumeInfo(fb4, vpg);
                    if (volume == null) continue;
                    String key = Boolean.toString(volume.getRmiExdVolumeInfo().getCacheMode());
                    btnMixCacheMode.add(key);
                    key = Boolean.toString(volume.getRmiExdVolumeInfo().getInflowControl());
                    btnMixInflowCtrls.add(key);
                    EXDExternalVolumeEx extVol = (EXDExternalVolumeEx)volume.getRmiExdVolumeInfo();
                    if (this.pathMode == null) {
                        int subSystemID = extVol.getExternalDeviceInfo().referSubsystemID();
                        SJmoExdSubsystemInfo subSystemInfo = strageSystemMgr.getExdSubsystemInfo(subSystemID);
                        int profileID = subSystemInfo.getRmiExdSubsystemInfo().referProfileId();
                        SJmoExdProfileInfo profileInfo = profileMgr.getExdProfileInfo(profileID);
                        this.pathMode = profileInfo.getRmiExdProfileInfo().getPathMode();
                    }
                    mixALUA.add(extVol.isPermittedALUA());
                    short lbm = extVol.getLBmode();
                    mixLBM.add(lbm);
                    found = true;
                    break;
                }
                if (!found) {
                    result = false;
                    errorcode = EDITEXTVOLS_NOT_EQUIP;
                } else {
                    SJmoPgIndex pgIndex = new SJmoPgIndex();
                    pgIndex.setFB4(fb4);
                    pgIndex.setPG(vpg);
                    ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>();
                    pgList.add(pgIndex);
                    if (rsgUtil.extractImpossiblePg(pgList).size() != 0) {
                        result = false;
                        errorcode = EDITEXTVOLS_UNUSABLE_PG;
                    }
                }
            }
            if (selectVolume.getRmiExdVolumeInfo().isODMAttribute()) {
                odmSetting = true;
            }
            if (result) continue;
            ret = false;
            SJctrError errInfo = new SJctrError(6, 22, errorcode);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(selectVolume, errInfo);
            errList.add(errData);
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        if (odmSetting) {
            this.cacheModeDataModel.setEnable(false);
        } else {
            this.cacheModeDataModel.setEnable(true);
            if (btnMixCacheMode.size() == 1) {
                if (btnMixCacheMode.contains(Boolean.toString(true))) {
                    this.cacheModeDataModel.selectButtonEnable();
                } else {
                    this.cacheModeDataModel.selectButtonDisable();
                }
            }
        }
        if (btnMixInflowCtrls.size() == 1) {
            if (btnMixInflowCtrls.contains(Boolean.toString(true))) {
                this.inflowCtrlDataModel.selectButtonEnable();
            } else {
                this.inflowCtrlDataModel.selectButtonDisable();
            }
        }
        this.aluaDataModel.initALUAMode(mixALUA);
        this.lbmDataModel.initLoadBalanceMode(mixLBM);
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<SJmoExDVirtualPgInfo> exdVpgInfoList = this.getCache(SJmoGetExDVirtualPgInfo.class);
        List<SJmoLdevNicknameInfo> ldevNameInfoList = this.getCache(SJmoGetLdevNicknameInfo.class);
        if (!(this.cacheModeDataModel.isSelectCheckBox() || this.inflowCtrlDataModel.isSelectCheckBox() || this.lbmDataModel.isSelectCheckBox() || this.aluaDataModel.isSelectCheckBox())) {
            ret = false;
            return ret;
        }
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.editExtVolsList.size());
        if (this.cacheModeDataModel.isSelectCheckBox() && this.cacheModeDataModel.getSelection() == null) {
            SJctrError error = new SJctrError(6, 22, EDITEXTVOLS_NOT_SELECT_RADIOBTN);
            SJcException exp = error.createException();
            throw exp;
        }
        if (this.inflowCtrlDataModel.isSelectCheckBox() && this.inflowCtrlDataModel.getSelection() == null) {
            SJctrError error = new SJctrError(6, 22, EDITEXTVOLS_NOT_SELECT_RADIOBTN);
            SJcException exp = error.createException();
            throw exp;
        }
        if (this.aluaDataModel.isSelectCheckBox() && !this.aluaDataModel.isSelectEnable() && !this.aluaDataModel.isSelectDisable()) {
            SJctrError error = new SJctrError(6, 22, EDITEXTVOLS_NOT_SELECT_RADIOBTN);
            SJcException exp = error.createException();
            throw exp;
        }
        if (this.lbmDataModel.isSelectCheckBox() && this.lbmDataModel.getSelection().equals("-1")) {
            SJctrError error = new SJctrError(6, 22, EDITEXTVOLS_SET_INVALID_VALUE);
            SJcException exp = error.createException();
            throw exp;
        }
        ArrayList<SJmoExdVolumeInfo> targetVolInfoList = new ArrayList<SJmoExdVolumeInfo>(this.editExtVolsList.size());
        Iterator<SJmoExdVolumeInfo> i$ = this.editExtVolsList.iterator();
        while (i$.hasNext()) {
            SJmoExdVolumeInfo selectData;
            SJmoExdVolumeInfo slelctVolumeInfo = selectData = i$.next();
            boolean result = true;
            if (this.cacheModeDataModel.isSelectCheckBox() && this.cacheModeDataModel.isSelectButtonEnable() && slelctVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().isCommandDevice()) {
                result = false;
                SJctrError errInfo = new SJctrError(6, 22, EDITEXTVOLS_NOT_ENABLE_CMD);
                ret = false;
                SJctrErrorColumnData errData = new SJctrErrorColumnData(slelctVolumeInfo, errInfo);
                errList.add(errData);
            }
            if (!result) continue;
            SJmoExdVolumeInfo createVolumeInfo = null;
            EXDExternalVolumeEx exdVolEx = (EXDExternalVolumeEx)slelctVolumeInfo.getRmiExdVolumeInfo();
            EXDExternalVolumeEx cloneExdVolEx = (EXDExternalVolumeEx)exdVolEx.cloneSC();
            createVolumeInfo = new SJmoExdVolumeInfo(cloneExdVolEx);
            if (this.cacheModeDataModel.isSelectCheckBox()) {
                createVolumeInfo.getRmiExdVolumeInfo().setCacheMode(this.cacheModeDataModel.isSelectButtonEnable());
            }
            if (this.inflowCtrlDataModel.isSelectCheckBox()) {
                createVolumeInfo.getRmiExdVolumeInfo().setInflowControl(this.inflowCtrlDataModel.isSelectButtonEnable());
            }
            if (this.aluaDataModel.isSelectCheckBox()) {
                boolean bAluaMode = this.aluaDataModel.isSelectEnable();
                EXDExternalVolumeEx exdVol = (EXDExternalVolumeEx)createVolumeInfo.getRmiExdVolumeInfo();
                exdVol.setPermittedALUA(bAluaMode);
                EXDExternalDeviceEx exdDev = (EXDExternalDeviceEx)exdVol.getExternalDeviceInfo();
                if (exdDev.isSettableALUA() && bAluaMode) {
                    createVolumeInfo.getRmiExdVolumeInfo().setPathMode((byte)5);
                } else {
                    createVolumeInfo.getRmiExdVolumeInfo().setPathMode(this.pathMode);
                }
            }
            if (this.lbmDataModel.isSelectCheckBox()) {
                EXDExternalVolumeEx exdVol = (EXDExternalVolumeEx)createVolumeInfo.getRmiExdVolumeInfo();
                short lbm = Short.valueOf(this.lbmDataModel.getSelection());
                exdVol.setLBmode(lbm);
            }
            targetVolInfoList.add(createVolumeInfo);
        }
        if (!ret) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        targetVolInfoList.trimToSize();
        Collections.sort(targetVolInfoList);
        ArrayList<SJctrEditExtVolsConfirmData> confirmDataList = new ArrayList<SJctrEditExtVolsConfirmData>(1);
        SJctrEditExtVolsConfirmData confirmData = new SJctrEditExtVolsConfirmData();
        List<Integer> commandList = this.getSubCommand();
        for (Integer command : commandList) {
            confirmData.setSubCommand(command);
        }
        confirmData.setExdVolumeInfo(targetVolInfoList);
        confirmData.setExdVpgInfo(exdVpgInfoList);
        confirmData.setLdevNameInfo(ldevNameInfoList);
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditExtVolsConfirmData.class, confirmDataList);
        return ret;
    }

    private List<Integer> getSubCommand() {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        if (this.cacheModeDataModel.isSelectCheckBox()) {
            if (this.cacheModeDataModel.isSelectButtonEnable()) {
                retList.add(4);
            } else {
                retList.add(3);
            }
        }
        if (this.inflowCtrlDataModel.isSelectCheckBox()) {
            if (this.inflowCtrlDataModel.isSelectButtonEnable()) {
                retList.add(6);
            } else {
                retList.add(5);
            }
        }
        if (this.aluaDataModel.isSelectCheckBox()) {
            if (this.aluaDataModel.isSelectEnable()) {
                retList.add(11);
            } else {
                retList.add(10);
            }
        }
        if (this.lbmDataModel.isSelectCheckBox()) {
            String selection = this.lbmDataModel.getSelection();
            short lbm = Short.valueOf(selection);
            switch (lbm) {
                case 0: {
                    retList.add(7);
                    break;
                }
                case 1: {
                    retList.add(8);
                    break;
                }
                case 2: {
                    retList.add(9);
                }
            }
        }
        return retList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetExDVirtualPgInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdSubsystemInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgLdevInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initManager() {
        this.addManager(SJctrExternalVolumeManager.class);
        this.addManager(SJctrVpgManager.class);
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean result = false;
        if (this.cacheModeDataModel.isSelectCheckBox()) {
            boolean poolVol = false;
            List<?> exdVolList = this.getCache(SJctrEditExtVolsSubWizard.EDIT_EXT_VOLS_DATA);
            ArrayList<SJmoPgIndex> pgIndexList = new ArrayList<SJmoPgIndex>();
            HashSet pgSet = new HashSet();
            for (SJmoExdVolumeInfo exdVol : exdVolList) {
                EXDExternalVolume volume = exdVol.getRmiExdVolumeInfo();
                SJmoPgIndex pgIndex = new SJmoPgIndex();
                pgIndex.setFB4(volume.getIFB4());
                pgIndex.setPG(volume.getIPG());
                pgIndexList.add(pgIndex);
            }
            List<?> pgLdevInfoList = this.getCache(SJmoGetPgLdevInfo.class);
            List<?> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
            block1: for (SJmoPgIndex pgIndex : pgIndexList) {
                int pgLdevIndex = Collections.binarySearch(pgLdevInfoList, pgIndex);
                if (pgLdevIndex < 0) continue;
                SJmoPgLdevInfo pgLdevInfo = (SJmoPgLdevInfo)pgLdevInfoList.get(pgLdevIndex);
                ArrayList ldevList = pgLdevInfo.getAlLdevIndex();
                for (SJmoLdevIndex ldevIndex : ldevList) {
                    SJmoLdevDetail ldev;
                    int index = Collections.binarySearch(ldevDetailList, ldevIndex);
                    if (index < 0 || !(ldev = (SJmoLdevDetail)ldevDetailList.get(index)).getbPoolVol()) continue;
                    poolVol = true;
                    continue block1;
                }
            }
            if (poolVol) {
                String strFuncID = Integer.toString(6);
                String strModuleID = Integer.toString(22);
                String strMsgID = Integer.toString(EDITEXTVOLS_MIX_CACHE_MODE);
                SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
                SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
                SJctrUserController uc = this.getOwner();
                SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
                msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrEditExtVolsDC.this.checkEndData();
                        SJctrEditExtVolsDC.this.finishEvent(msgEvent, dstModel);
                    }
                });
                msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
                this.addUpdateDisp(related);
                result = true;
            }
        }
        return result;
    }
}

