/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.editpathgrp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.EXDDiscoveryDevice;
import sanproject.serverux.dataimpl.EXDDiscoveryTargetPort;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDLogicalPath;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.serverux.dataimpl.EXDPhysicalPath;
import sanproject.serverux.dataimpl.EXDSubsystem;
import sanproject.serverux.dataimpl.EXDTargetPort_Fiber;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_IN;
import sanproject.serverux.dataimpl.EXDgetDiscoveryDevice_OUT;
import sanproject.serverux.dataimpl.EXDgetDiscoveryTargetPort_IN;
import sanproject.serverux.dataimpl.EXDgetDiscoveryTargetPort_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrExdDiscoveryTargetPortPhysicalPathComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.uvm.com.SJctrExdPathGroupPhysicalPathInfoTableKey;
import sanproject.sn2.controller.wizard.uvm.com.SJctrGetExdDiscoveryDevice;
import sanproject.sn2.controller.wizard.uvm.com.SJctrGetExdDiscoveryTargetPort;
import sanproject.sn2.controller.wizard.uvm.com.SJctrUvmWizardDataController;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrDefaultUvmManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalPathStatusManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrExternalVolumeManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPathGroupManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrPhysicalPathManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrSubsytemManager;
import sanproject.sn2.controller.wizard.uvm.com.manager.SJctrTargetPortManager;
import sanproject.sn2.controller.wizard.uvm.comdialog.discovernewstoragesystem.SJctrDiscoverNewStorageSystemDialogDC;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.SJctrEditExtPathGrpsConfirmData;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.SJctrEditExtPathGrpsSubWizard;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.table.SJctrAvailableExternalPathTableModel;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.table.SJctrExternalStorageSystemDataModel;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.table.SJctrPathGroupDataModel;
import sanproject.sn2.controller.wizard.uvm.editpathgrp.table.SJctrSelectedExternalPathTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathStatusInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrEditExtPathGrpsDC
extends SJctrUvmWizardDataController {
    private static final int DISP_ID = 17827457;
    public static final String KEY_EXTPATHGPID = "COM_EXTPATHGPID";
    public static final String KEY_EXTSTORAGE = "COM_EXTSTORAGE";
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_DISCOVERY_PORTLIST = "COM_DISCOVERY_PORTLIST";
    public static final String TITLE = "DISP_DI68S_TITLE";
    private static final String KEY_DISCOVER_BTN = "COM_DISCOVER_BTN";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_ROLLBACK = "COM_ROLLBACK";
    public static final String PATHGRP_AUTO = "AUTO";
    private SJmoExdPathGroupInfo selectPathGrpInfo = null;
    private List<SJmoExdPhysicalPathInfo> priorityInfo = null;
    private List<SJmoExdPathGroupInfo> availableTableKeyList = null;
    private SJctrResourceGroupUtility rsgUtil = null;
    static SJctrExdDiscoveryTargetPortPhysicalPathComparator DIS_PHYSICALPATH_COMP = new SJctrExdDiscoveryTargetPortPhysicalPathComparator();
    private HashMap<String, PortWwnInfo> discoveryDeviceMap = new HashMap();
    private List<SJmoPortIscsiTargetPathInfo> ptITPathList = Collections.emptyList();
    static int RESULT_NORMAL = 0;
    static int RESULT_ERROR = -1;
    static final int MSG_ERR_DATA = 107001;
    static final int MSG_ERR_CACHE_MODEL = 107018;
    static final int MSG_ERR_UNMATCE_CONFIG = 106086;
    static final int MSG_ERR_NOTEQUIP_PATHGROUP = 106527;
    static final int MSG_NO_SELECTION = 105235;
    static final int MSG_INVALID_SUBSYSTEMID = 107004;
    static final int MSG_FAILD_CREATE_PATHGROUP = 105240;
    static final int MSG_TOO_MANY_SELECT_PATH = 105239;
    static final int MSG_ALTERNATEPATH_CHANGE_FAILED = 105258;
    static final int MSG_ERR_PATH_CONF_NOTSET = 105244;
    static final int MSG_ERR_UNUSABLE_PATHGRP = 105268;
    static final int MSG_ERR_UNUSABLE_PG = 105275;

    public SJctrEditExtPathGrpsDC() throws SJcException {
        super(17827457);
        this.initDataModel();
        this.initListener();
        this.initManager();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("UVM", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableExternalPathTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedExternalPathTableModel());
        this.addDataObjectModel(KEY_EXTSTORAGE, new SJctrExternalStorageSystemDataModel());
        this.addDataObjectModel(KEY_EXTPATHGPID, new SJctrPathGroupDataModel());
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DISCOVER_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditExtPathGrpsDC.this.discoverNewStorageSystem();
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditExtPathGrpsDC.this.addAction();
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditExtPathGrpsDC.this.removeAction();
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    public void setCtrManager() {
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        ArrayList<SJctrDefaultUvmManager> list = new ArrayList<SJctrDefaultUvmManager>();
        list.add(subsystemMgr);
        avaliableTable.setBasicData(SJctrSubsytemManager.class, list);
        selectedTable.setBasicData(SJctrSubsytemManager.class, list);
        list = new ArrayList();
        list.add(physicalPathMgr);
        avaliableTable.setBasicData(SJctrPhysicalPathManager.class, list);
        selectedTable.setBasicData(SJctrPhysicalPathManager.class, list);
        list = new ArrayList();
        list.add(targetPortMgr);
        avaliableTable.setBasicData(SJctrTargetPortManager.class, list);
        selectedTable.setBasicData(SJctrTargetPortManager.class, list);
    }

    @Override
    public void makeDataModel() {
        int pathId;
        this.setCtrManager();
        super.makeDataModel();
        SJctrComUtility util = this.getComUtility();
        SJctrPathGroupDataModel pathGrpLabel = (SJctrPathGroupDataModel)this.getDataObjectModel(KEY_EXTPATHGPID);
        this.priorityInfo = new ArrayList<SJmoExdPhysicalPathInfo>(8);
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
        String name = util.getGuidance("UVM", "EXT_PATHGROUP");
        int pathGrpId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().getPathGroupID();
        pathGrpLabel.setLabel(name + Integer.toString(pathGrpId));
        this.updateTable(this.selectPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID());
        SJctrAvailableExternalPathTableModel availableTable = (SJctrAvailableExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectedExternalPathTableModel selectedTable = (SJctrSelectedExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        int[] pathIdList = this.selectPathGrpInfo.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        ArrayList<SJmoExdPhysicalPathInfo> selectList = new ArrayList<SJmoExdPhysicalPathInfo>(8);
        for (int index = 0; index < pathIdList.length && (pathId = pathIdList[index]) != -1; ++index) {
            SJmoExdPhysicalPathInfo physicalPathInfo = physicalPathMgr.getPhysicalPathInfo(pathId);
            selectList.add(physicalPathInfo);
            this.priorityInfo.add(physicalPathInfo);
        }
        availableTable.removeRowData(selectList);
        selectedTable.setBasicDataList(selectList);
        SJctrExternalStorageSystemDataModel storage = (SJctrExternalStorageSystemDataModel)this.getDataObjectModel(KEY_EXTSTORAGE);
        int subsystemId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID();
        storage.selectComboBoxItem(subsystemId);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> targetList = this.getCache(SJctrEditExtPathGrpsSubWizard.EDIT_EXT_PATHGRPS_DATA);
        if (targetList == null || targetList.size() == 0) {
            errorCode = 107001;
        } else {
            for (Object targetObj : targetList) {
                if (targetObj instanceof SJmoExdPathGroupInfo) continue;
                errorCode = 107001;
            }
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        this.selectPathGrpInfo = (SJmoExdPathGroupInfo)targetList.get(0);
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJcException exp;
        boolean result = true;
        int errorCode = RESULT_NORMAL;
        SJmoRSGgetAllRsgs allRsgInfo = (SJmoRSGgetAllRsgs)this.getCache(SJmoGetRSGgetAllRsgs.class).get(0);
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJctrPathGroupManager pathGrpMgr = this.getManager(SJctrPathGroupManager.class);
        SJctrExternalVolumeManager volumeMgr = this.getManager(SJctrExternalVolumeManager.class);
        this.availableTableKeyList = new ArrayList<SJmoExdPathGroupInfo>();
        int subsystemId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID();
        SJmoExdSubsystemInfo subsystemInfo = subsystemMgr.getSubsystemInfo(subsystemId);
        if (subsystemInfo == null) {
            this.logUty.putlog("checkConstructData", "Changed Config ");
            errorCode = 106086;
            result = false;
        }
        if (result) {
            int pathGrpId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().getPathGroupID();
            SJmoExdPathGroupInfo pathGrpInfo = pathGrpMgr.getPathGroupInfo(pathGrpId);
            if (pathGrpInfo != null) {
                this.availableTableKeyList.add(pathGrpInfo);
                if (!this.isUsablePathGroupRSG(pathGrpInfo)) {
                    this.logUty.putlog("checkConstructData", "PathGroup No." + pathGrpId + "is Unusable");
                    errorCode = 105268;
                    result = false;
                }
            } else {
                this.logUty.putlog("checkConstructData", "PathGroup No." + pathGrpId + "is Not Equip");
                errorCode = 106527;
                result = false;
            }
            if (result) {
                SJmoExdVolumeInfoOnPathGroup exdvolOnpathGp = volumeMgr.getExternalVolumeInfo(pathGrpId);
                ArrayList volumeInfoList = exdvolOnpathGp.getAlExdVolumeInfo();
                ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>(volumeInfoList.size());
                for (SJmoExdVolumeInfo volInfo : volumeInfoList) {
                    EXDExternalVolume rmiExdVol = volInfo.getRmiExdVolumeInfo();
                    SJmoPgIndex pgIndex = new SJmoPgIndex();
                    pgIndex.setFB4(rmiExdVol.getIFB4());
                    pgIndex.setPG(rmiExdVol.getIPG());
                    pgList.add(pgIndex);
                }
                if (this.rsgUtil.extractImpossiblePg(pgList).size() > 0) {
                    this.logUty.putlog("checkConstructData", "PG. is Unusable");
                    errorCode = 105275;
                    result = false;
                }
            }
        }
        if (!result) {
            SJctrError err = new SJctrError(6, 22, errorCode);
            exp = err.createException();
            throw exp;
        }
        this.ptITPathList = this.getCache(SJmoGetPortIscsiTargetPathInfo.class);
        if (this.ptITPathList == null) {
            SJctrError err = new SJctrError(6, 22, 107018);
            exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> rowData = selectedTable.getAllRowData();
        if (rowData.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 105235);
            SJcException exp = err.createException();
            throw exp;
        }
        this.createConfirmData();
        return true;
    }

    public List<SJctrEditExtPathGrpsConfirmData> createConfirmData() {
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        SJctrPathGroupManager pathGrpMgr = this.getManager(SJctrPathGroupManager.class);
        SJctrExternalVolumeManager volumeMgr = this.getManager(SJctrExternalVolumeManager.class);
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        List<?> moPortDetailList = this.getCache(SJmoGetPortDetail.class);
        Collections.sort(moPortDetailList);
        List<?> moVirtualPgInfoList = this.getCache(SJmoGetExDVirtualPgInfo.class);
        SJmoExDVirtualPgInfo moVirtualPgInfo = (SJmoExDVirtualPgInfo)moVirtualPgInfoList.get(0);
        SJmoExdPathGroupInfo setPathGrpInfo = null;
        try {
            setPathGrpInfo = (SJmoExdPathGroupInfo)this.selectPathGrpInfo.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogUty().putlog("selectPathGroupInfo", "PathGroupInfo clone fail", e, 40000);
        }
        EXDPathGroup exdPathGroup = setPathGrpInfo.getRmiExdPathGroupInfo();
        int[] pathList = exdPathGroup.referAllPhysicalPathList();
        for (int priority = 0; priority < pathList.length; ++priority) {
            int physicalPathId;
            if (priority >= this.priorityInfo.size()) {
                pathList[priority] = -1;
                continue;
            }
            SJmoExdPhysicalPathInfo physicalPathInfo = this.priorityInfo.get(priority);
            pathList[priority] = physicalPathId = physicalPathInfo.getRmiExdPhysicalPathInfo().getId();
        }
        EXDgetDiscoveryDevice_OUT rmiOutputData = null;
        List<PortWwnInfo> portwwnList = this.getDiscoveryDeviceInData(setPathGrpInfo);
        if (portwwnList.size() != 0) {
            rmiOutputData = this.getDiscoveryDeviceOutData(portwwnList);
        }
        this.checkAlternatePath(this.selectPathGrpInfo.getRmiExdPathGroupInfo().referAllPhysicalPathList(), pathList);
        EXDPathGroup _exdPathGroup = setPathGrpInfo.getRmiExdPathGroupInfo();
        int[] _pathList = _exdPathGroup.referAllPhysicalPathList();
        _pathList = pathList;
        SJctrEditExtPathGrpsConfirmData confirmData = new SJctrEditExtPathGrpsConfirmData();
        ArrayList<SJctrExdPathGroupPhysicalPathInfoTableKey> setTableKeyList = new ArrayList<SJctrExdPathGroupPhysicalPathInfoTableKey>();
        ArrayList<SJmoExdTargetPortInfo> targetPortList = new ArrayList<SJmoExdTargetPortInfo>(8);
        for (int pathIndex = 0; pathIndex < pathList.length; ++pathIndex) {
            if (pathList[pathIndex] == -1) continue;
            SJmoExdPhysicalPathInfo physicalPathInfo = physicalPathMgr.getPhysicalPathInfo(pathList[pathIndex]);
            SJctrExdPathGroupPhysicalPathInfoTableKey tableKey = new SJctrExdPathGroupPhysicalPathInfoTableKey(setPathGrpInfo, physicalPathInfo);
            setTableKeyList.add(tableKey);
            int targetPortId = physicalPathInfo.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPortInfo = targetPortMgr.getTargetPortInfo(targetPortId);
            targetPortList.add(targetPortInfo);
        }
        SJmoExdTargetPortInfoMgr moTargePortMgr = new SJmoExdTargetPortInfoMgr(targetPortList);
        ArrayList<SJmoExdTargetPortInfoMgr> setTargetPortMgrList = new ArrayList<SJmoExdTargetPortInfoMgr>(1);
        setTargetPortMgrList.add(moTargePortMgr);
        confirmData.setTargetPortMgr(setTargetPortMgrList);
        confirmData.setPathInfo(setTableKeyList);
        int pathGrpId = setPathGrpInfo.getRmiExdPathGroupInfo().getPathGroupID();
        SJmoExdVolumeInfoOnPathGroup volumeInfoOnPathGrp = volumeMgr.getExternalVolumeInfo(pathGrpId);
        ArrayList volumeInfoList = volumeInfoOnPathGrp.getAlExdVolumeInfo();
        ArrayList<SJmoExdVolumeInfo> copyVolumeInfoList = new ArrayList<SJmoExdVolumeInfo>(volumeInfoList.size());
        for (SJmoExdVolumeInfo volumeInfo : volumeInfoList) {
            SJmoExdVolumeInfo copyVolumeInfo = new SJmoExdVolumeInfo(volumeInfo.getRmiExdVolumeInfo());
            try {
                copyVolumeInfo = (SJmoExdVolumeInfo)volumeInfo.clone();
                copyVolumeInfoList.add(copyVolumeInfo);
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("selelctVolumeInfo", "ExdVolumeInfo clone fail", e, 40000);
            }
        }
        for (SJmoExdVolumeInfo copyVolumeInfo : copyVolumeInfoList) {
            EXDLogicalPath[] copyLogicalPath = copyVolumeInfo.getRmiExdVolumeInfo().getLogicalPathList();
            for (int priority = 0; priority < pathList.length; ++priority) {
                if (pathList[priority] == -1) {
                    copyLogicalPath[priority] = null;
                    continue;
                }
                String identify2 = copyVolumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().getIdentity2();
                SJmoExdPhysicalPathInfo physicalPath = physicalPathMgr.getPhysicalPathInfo(pathList[priority]);
                int portId = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
                int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
                SJmoExdTargetPortInfo targetPort = targetPortMgr.getTargetPortInfo(wwnId);
                String wwn = targetPort.getRmiExdTargetPortInfo().getDispTargetPortAddress();
                if (rmiOutputData == null) {
                    SJctrError err = new SJctrError(6, 22, 105244);
                    SJcException exp = err.createException();
                    throw exp;
                }
                EXDDiscoveryDevice[] discoveryDeviceOut = rmiOutputData.getDiscoveryDevice((short)portId, wwn);
                boolean found = false;
                for (int out = 0; out < discoveryDeviceOut.length; ++out) {
                    String outIdentify2 = discoveryDeviceOut[out].getExternalDevice().getIdentity2();
                    if (!outIdentify2.equals(identify2)) continue;
                    copyLogicalPath[priority] = discoveryDeviceOut[out].getLogicalPath();
                    if (pathList[priority] >= 0) {
                        copyLogicalPath[priority].setPhysicalpathID(pathList[priority]);
                    }
                    copyLogicalPath[priority].setPriority((byte)priority);
                    found = true;
                    break;
                }
                if (found) continue;
                SJctrError err = new SJctrError(6, 22, 105244);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        confirmData.setExtVolumeInfo(copyVolumeInfoList);
        int subsystemId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID();
        SJmoExdSubsystemInfo systemInfo = subsystemMgr.getSubsystemInfo(subsystemId);
        ArrayList<SJmoExdSubsystemInfo> systemInfoList = new ArrayList<SJmoExdSubsystemInfo>();
        systemInfoList.add(systemInfo);
        SJmoExdSubsystemInfoMgr systemMgr = new SJmoExdSubsystemInfoMgr(systemInfoList);
        ArrayList<SJmoExdSubsystemInfoMgr> systemMgrList = new ArrayList<SJmoExdSubsystemInfoMgr>();
        systemMgrList.add(systemMgr);
        confirmData.setSubsystemMgr(systemMgrList);
        int profileId = systemInfo.getRmiExdSubsystemInfo().referProfileId();
        SJmoExdProfileInfo profileInfo = subsystemMgr.getProfileInfo(profileId);
        ArrayList<SJmoExdProfileInfo> profileInfoList = new ArrayList<SJmoExdProfileInfo>();
        profileInfoList.add(profileInfo);
        SJmoExdProfileInfoMgr profileMgr = new SJmoExdProfileInfoMgr(profileInfoList);
        ArrayList<SJmoExdProfileInfoMgr> profileMgrList = new ArrayList<SJmoExdProfileInfoMgr>();
        profileMgrList.add(profileMgr);
        confirmData.setProfileMgr(profileMgrList);
        ArrayList<PortWwnInfo> getInfoList = new ArrayList<PortWwnInfo>();
        getInfoList.addAll(this.discoveryDeviceMap.values());
        ArrayList<SJmoPortDetail> portDetailList = new ArrayList<SJmoPortDetail>();
        ArrayList<SJmoPortIscsiTargetPathInfo> confirmPtITPathList = new ArrayList<SJmoPortIscsiTargetPathInfo>();
        HashSet<Short> portIDSet = new HashSet<Short>();
        SJmoPortIndex port = new SJmoPortIndex();
        for (PortWwnInfo info : getInfoList) {
            int itPathIndex;
            short portId = (short)info.getPortId();
            if (!portIDSet.add(portId)) continue;
            port.setSPort(portId);
            int portIndex = Collections.binarySearch(moPortDetailList, port);
            if (portIndex >= 0) {
                SJmoPortDetail portDetail = (SJmoPortDetail)moPortDetailList.get(portIndex);
                portDetailList.add(portDetail);
            }
            if ((itPathIndex = Collections.binarySearch(this.ptITPathList, port)) < 0) continue;
            SJmoPortIscsiTargetPathInfo ptItPathInfo = this.ptITPathList.get(itPathIndex);
            confirmPtITPathList.add(ptItPathInfo);
        }
        Collections.sort(portDetailList);
        Collections.sort(confirmPtITPathList);
        confirmData.setPortDtlInfo(portDetailList);
        confirmData.setiSCSITargetPathInfo(confirmPtITPathList);
        ArrayList exdPgInfoList = moVirtualPgInfo.getAlVpgForExd();
        Collections.sort(exdPgInfoList);
        confirmData.setExdPgInfo(exdPgInfoList);
        ArrayList<SJctrEditExtPathGrpsConfirmData> confirmDataList = new ArrayList<SJctrEditExtPathGrpsConfirmData>(1);
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditExtPathGrpsConfirmData.EDIT_EXT_PATHGRPS_CONFIRM_DATA, confirmDataList);
        return confirmDataList;
    }

    @Override
    public void restoreControlData() {
    }

    private void discoverNewStorageSystem() {
        HashMap map = new HashMap();
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrDiscoverNewStorageSystemDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrEditExtPathGrpsDC.this.exitDiscoverAction(map);
                }
            }
        });
        this.addMessageEventListener(EDIT_EXTPATHGRP_MSG.RAISE_PRIORITY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditExtPathGrpsDC.this.risePriorityAction();
            }
        });
        this.addMessageEventListener(EDIT_EXTPATHGRP_MSG.LOWER_PRIORITY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditExtPathGrpsDC.this.lowerPriorityAction();
            }
        });
    }

    private void risePriorityAction() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        ArrayList<SJmoExdPhysicalPathInfo> newPriorityInfo = new ArrayList<SJmoExdPhysicalPathInfo>(16);
        for (SJmoExdPhysicalPathInfo priority : this.priorityInfo) {
            newPriorityInfo.add(priority);
        }
        List<Object> selectRowList = selectedTable.getSelectedRowData();
        Collections.sort(selectRowList, DIS_PHYSICALPATH_COMP);
        int lowPriority = this.priorityInfo.size() - 1;
        int newPriority = lowPriority + 1;
        for (int priority = lowPriority; priority >= 0; --priority) {
            SJmoExdPhysicalPathInfo pathInfo = this.priorityInfo.get(priority);
            int index = Collections.binarySearch(selectRowList, pathInfo, DIS_PHYSICALPATH_COMP);
            if (index >= 0) continue;
            newPriorityInfo.add(newPriority, pathInfo);
            int topIndex = newPriorityInfo.indexOf(pathInfo);
            newPriority = priority == 0 ? 0 : priority;
            newPriorityInfo.remove(topIndex);
        }
        newPriorityInfo.trimToSize();
        this.setpriorityInfo(newPriorityInfo);
        this.updateTableRowData(newPriorityInfo, selectedTable);
        selectedTable.doRefresh("COM_COL_PRIORITY");
        this.getWizardWindow().rollback();
    }

    private void lowerPriorityAction() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        ArrayList<SJmoExdPhysicalPathInfo> newPriorityInfo = new ArrayList<SJmoExdPhysicalPathInfo>(16);
        for (SJmoExdPhysicalPathInfo priority : this.priorityInfo) {
            newPriorityInfo.add(priority);
        }
        int newPriority = 0;
        List<Object> selectRowList = selectedTable.getSelectedRowData();
        Collections.sort(selectRowList, DIS_PHYSICALPATH_COMP);
        for (int priority = 0; priority < this.priorityInfo.size(); ++priority) {
            SJmoExdPhysicalPathInfo pathInfo = this.priorityInfo.get(priority);
            int index = Collections.binarySearch(selectRowList, pathInfo, DIS_PHYSICALPATH_COMP);
            if (index >= 0) continue;
            newPriorityInfo.add(newPriority, pathInfo);
            int lastIndex = newPriorityInfo.lastIndexOf(pathInfo);
            newPriorityInfo.remove(lastIndex);
            newPriority = priority == this.priorityInfo.size() - 1 ? priority : priority + 1;
        }
        newPriorityInfo.trimToSize();
        this.setpriorityInfo(newPriorityInfo);
        this.updateTableRowData(newPriorityInfo, selectedTable);
        selectedTable.doRefresh("COM_COL_PRIORITY");
        this.getWizardWindow().rollback();
    }

    private void updateTableRowData(List<SJmoExdPhysicalPathInfo> newPriorityInfo, SJctrTableDataModel selectedTable) {
        ArrayList<SJmoExdPhysicalPathInfo> changeRowDataList = new ArrayList<SJmoExdPhysicalPathInfo>(newPriorityInfo.size());
        List<Object> rowDataList = selectedTable.getAllRowData();
        block0: for (int priority = 0; priority < newPriorityInfo.size(); ++priority) {
            for (Object rowData : rowDataList) {
                SJmoExdPhysicalPathInfo path = (SJmoExdPhysicalPathInfo)rowData;
                if (newPriorityInfo.get(priority).getRmiExdPhysicalPathInfo().getId() != path.getRmiExdPhysicalPathInfo().getId()) continue;
                changeRowDataList.add(path);
                continue block0;
            }
        }
        selectedTable.clearRowData();
        selectedTable.addRowData(changeRowDataList);
    }

    private void exitDiscoverAction(Map<String, List<?>> carryMap) {
        List<SJmoPortIndex> getList = carryMap.get(KEY_DISCOVERY_PORTLIST);
        if (getList == null || getList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoPortIndex> portList = this.getExecutList(getList);
        if (portList.size() == 0) {
            return;
        }
        List<EXDDiscoveryTargetPort> discoveryInfo = this.getDiscoveryTargetPort(portList);
        this.createModelData(discoveryInfo);
        SJctrExternalStorageSystemDataModel comboBox = (SJctrExternalStorageSystemDataModel)this.getDataObjectModel(KEY_EXTSTORAGE);
        int subsystemId = comboBox.getSelectId();
        if (subsystemId == SJctrExternalStorageSystemDataModel.INVALID_VALUE) {
            this.logUty.putlog("SubsystemId", "subsystemId is Invalid subsystemId = " + subsystemId);
            return;
        }
        ArrayList<SJmoExdPhysicalPathInfo> pathList = new ArrayList<SJmoExdPhysicalPathInfo>(256);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        List<SJmoExdTargetPortInfo> targetPortList = this.getAllTargetPortListOfSubsystemId(subsystemId);
        SJctrAvailableExternalPathTableModel availableTable = (SJctrAvailableExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectedExternalPathTableModel selectedTable = (SJctrSelectedExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedList = selectedTable.getAllRowData();
        Collections.sort(selectedList);
        for (SJmoExdTargetPortInfo targetPort : targetPortList) {
            int targetPortId = targetPort.getRmiExdTargetPortInfo().getId();
            List<SJmoExdPhysicalPathInfo> physicalPathlist = this.getAllPhysicalPathListOfTargetPortId(targetPortId);
            for (SJmoExdPhysicalPathInfo physicalPath : physicalPathlist) {
                int portId = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort((short)portId);
                ArrayList<SJmoPortIndex> portindexList = new ArrayList<SJmoPortIndex>();
                portindexList.add(portIndex);
                if (this.rsgUtil.extractPort(portindexList).size() == 0 || Collections.binarySearch(selectedList, physicalPath) >= 0) continue;
                pathList.add(physicalPath);
            }
        }
        availableTable.setBasicDataList(pathList);
    }

    private void createModelData(List<EXDDiscoveryTargetPort> discoverList) {
        SJctrExternalStorageSystemDataModel subsysCmbo = (SJctrExternalStorageSystemDataModel)this.getDataObjectModel(KEY_EXTSTORAGE);
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        for (EXDDiscoveryTargetPort discoveryData : discoverList) {
            EXDSubsystem subsystemInfo = discoveryData.getSubsystem();
            SJmoExdSubsystemInfo moSubsystem = subsystemMgr.createDiscoveryProductInfo(subsystemInfo);
            if (moSubsystem == null) {
                SJctrError err = new SJctrError(6, 22, 106086);
                SJcException exp = err.createException();
                throw exp;
            }
            subsysCmbo.upDateComboBoxItem(moSubsystem.getRmiExdSubsystemInfo().getId());
            EXDTargetPort_Fiber targetPortInfo = (EXDTargetPort_Fiber)discoveryData.getTargetPort();
            targetPortInfo.setSubsystemId(moSubsystem.getRmiExdSubsystemInfo().getId());
            SJmoExdTargetPortInfo moTargePort = targetPortMgr.createDiscoveryTargetPortInfo(targetPortInfo);
            if (moTargePort == null) {
                SJctrError err = new SJctrError(6, 22, 106086);
                SJcException exp = err.createException();
                throw exp;
            }
            EXDPhysicalPath physicalPathInfo = discoveryData.getPhysicalPath();
            physicalPathInfo.setTargetPortId(moTargePort.getRmiExdTargetPortInfo().getId());
            SJmoExdPhysicalPathInfo moPhysicalPath = physicalPathMgr.createDiscoveryPhysicalPathInfo(physicalPathInfo);
            if (moPhysicalPath != null) continue;
            SJctrError err = new SJctrError(6, 22, 106086);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private List<SJmoPortIndex> getExecutList(List<SJmoPortIndex> portList) {
        ArrayList<SJmoPortIndex> retList = new ArrayList<SJmoPortIndex>(portList.size());
        for (SJmoPortIndex port : portList) {
            retList.add(port);
        }
        return retList;
    }

    public void updateTable(int subsystemId) {
        SJctrAvailableExternalPathTableModel avaliableTable = (SJctrAvailableExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectedExternalPathTableModel selectedTable = (SJctrSelectedExternalPathTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedList = selectedTable.getAllRowData();
        Collections.sort(selectedList, DIS_PHYSICALPATH_COMP);
        List<SJmoExdTargetPortInfo> targetPortList = this.getAllTargetPortListOfSubsystemId(subsystemId);
        ArrayList<SJmoExdPhysicalPathInfo> addList = new ArrayList<SJmoExdPhysicalPathInfo>(256);
        for (SJmoExdTargetPortInfo targetPort : targetPortList) {
            List<SJmoExdPhysicalPathInfo> physicalPathlist = this.getAllPhysicalPathListOfTargetPortId(targetPort.getRmiExdTargetPortInfo().getId());
            for (SJmoExdPhysicalPathInfo physicalPath : physicalPathlist) {
                int index;
                int portId = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort((short)portId);
                ArrayList<SJmoPortIndex> portindexList = new ArrayList<SJmoPortIndex>();
                portindexList.add(portIndex);
                if (this.rsgUtil.extractPort(portindexList).size() == 0 || (index = Collections.binarySearch(selectedList, physicalPath, DIS_PHYSICALPATH_COMP)) >= 0) continue;
                addList.add(physicalPath);
            }
        }
        avaliableTable.setBasicDataList(addList);
    }

    private void addAction() {
        int selectedRowCount;
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        int availableSelectRowCount = avaliableTable.getSelectedRowCount();
        if (availableSelectRowCount + (selectedRowCount = selectedTable.getRowCount()) > 8) {
            SJctrError err = new SJctrError(6, 22, 105239);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> list = avaliableTable.removeSelectedRowData();
        this.priorityInfo.addAll(list);
        selectedTable.addRowData(list, 0);
        this.updateTableRowData(this.priorityInfo, selectedTable);
        selectedTable.setRowSelectionList(list);
        avaliableTable.setSortColumn(null, Boolean.FALSE);
        selectedTable.setSortColumn(null, Boolean.FALSE);
        selectedTable.doRefresh("COM_COL_PRIORITY");
        this.getWizardWindow().rollback();
    }

    private void removeAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = selectedTable.removeSelectedRowData();
        this.priorityInfo.removeAll(list);
        avaliableTable.addRowDataTop(list);
        selectedTable.doRefresh("COM_COL_PRIORITY");
        this.getWizardWindow().rollback();
    }

    private List<EXDDiscoveryTargetPort> getDiscoveryTargetPort(List<SJmoPortIndex> portList) {
        ArrayList<EXDDiscoveryTargetPort> discoveryInfo = new ArrayList<EXDDiscoveryTargetPort>(256);
        EXDgetDiscoveryTargetPort_IN input = new EXDgetDiscoveryTargetPort_IN();
        for (SJmoPortIndex port : portList) {
            input.setInitiatorPort(port.getSPort());
        }
        SJctrGetExdDiscoveryTargetPort kind = new SJctrGetExdDiscoveryTargetPort(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)this.getModelData(wrapper).get(0);
        EXDgetDiscoveryTargetPort_OUT output = (EXDgetDiscoveryTargetPort_OUT)rmiObj.getObjRmi();
        int subsystemId = this.selectPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID();
        SJctrSubsytemManager subsystemMgr = this.getManager(SJctrSubsytemManager.class);
        SJmoExdSubsystemInfo subsystemInfo = subsystemMgr.getSubsystemInfo(subsystemId);
        String serialId = subsystemInfo.getRmiExdSubsystemInfo().getSerialId();
        int profileId = subsystemInfo.getRmiExdSubsystemInfo().referProfileId();
        for (SJmoPortIndex port : portList) {
            EXDDiscoveryTargetPort[] discoveryList = output.getDiscoveryTargetPort(port.getSPort());
            if (discoveryList == null) continue;
            for (int index = 0; index < discoveryList.length; ++index) {
                EXDSubsystem subsystem = discoveryList[index].getSubsystem();
                if (!serialId.equals(subsystem.getSerialId()) || profileId != subsystem.referProfileId()) continue;
                discoveryInfo.add(discoveryList[index]);
            }
        }
        return discoveryInfo;
    }

    private List<PortWwnInfo> getDiscoveryDeviceInData(SJmoExdPathGroupInfo setPathGrpInfo) {
        int physicalPathId;
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        ArrayList<PortWwnInfo> portwwnList = new ArrayList<PortWwnInfo>();
        int[] physicalPathList = setPathGrpInfo.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        for (int index = 0; index < physicalPathList.length && (physicalPathId = physicalPathList[index]) != -1; ++index) {
            SJmoExdPhysicalPathInfo physicalPath = physicalPathMgr.getPhysicalPathInfo(physicalPathId);
            if (physicalPath == null) {
                SJctrError err = new SJctrError(6, 22, 107018);
                SJcException exp = err.createException();
                throw exp;
            }
            int wwnId = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfo targetPortInfo = targetPortMgr.getTargetPortInfo(wwnId);
            if (targetPortInfo == null) {
                SJctrError err = new SJctrError(6, 22, 107018);
                SJcException exp = err.createException();
                throw exp;
            }
            int initiatorPortID = physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            String wwn = targetPortInfo.getRmiExdTargetPortInfo().getDispTargetPortAddress();
            PortWwnInfo portwwn = new PortWwnInfo(initiatorPortID, wwn);
            portwwnList.add(portwwn);
        }
        return portwwnList;
    }

    private EXDgetDiscoveryDevice_OUT getDiscoveryDeviceOutData(List<PortWwnInfo> portwwnList) {
        EXDgetDiscoveryDevice_IN input = new EXDgetDiscoveryDevice_IN();
        for (PortWwnInfo portwwn : portwwnList) {
            input.setPhysicalPath((short)portwwn.getPortId(), portwwn.getWwn());
        }
        SJctrGetExdDiscoveryDevice kind = new SJctrGetExdDiscoveryDevice(input);
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)this.getModelData(wrapper).get(0);
        EXDgetDiscoveryDevice_OUT output = (EXDgetDiscoveryDevice_OUT)rmiObj.getObjRmi();
        if (output != null) {
            for (PortWwnInfo portwwn : portwwnList) {
                this.discoveryDeviceMap.put(portwwn.getIndexKey(), portwwn);
            }
        }
        return output;
    }

    public List<?> getpriorityInfo() {
        return this.priorityInfo;
    }

    private void setpriorityInfo(List<SJmoExdPhysicalPathInfo> priorityInfo) {
        this.priorityInfo = priorityInfo;
    }

    private List<SJmoExdTargetPortInfo> getAllTargetPortListOfSubsystemId(int subsystemId) {
        SJctrTargetPortManager targetPortMgr = this.getManager(SJctrTargetPortManager.class);
        ArrayList<SJmoExdTargetPortInfo> ret = null;
        List<SJmoExdTargetPortInfo> mapList = targetPortMgr.getTargetPortListOfSubsystemId(subsystemId);
        List<SJmoExdTargetPortInfo> unMapList = targetPortMgr.getUnmapTargetPortListOfSubsystemId(subsystemId);
        if (mapList.isEmpty()) {
            mapList = new ArrayList<SJmoExdTargetPortInfo>(0);
        }
        ret = new ArrayList<SJmoExdTargetPortInfo>(mapList.size() + unMapList.size());
        ret.addAll(mapList);
        ret.addAll(unMapList);
        return ret;
    }

    private List<SJmoExdPhysicalPathInfo> getAllPhysicalPathListOfTargetPortId(int wwnId) {
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        ArrayList<SJmoExdPhysicalPathInfo> ret = null;
        List<SJmoExdPhysicalPathInfo> mapList = physicalPathMgr.getPhysicalPathListOfTargetPortId(wwnId);
        List<SJmoExdPhysicalPathInfo> unMapList = physicalPathMgr.getUnmapPhysicalPathListOfTargetPortId(wwnId);
        if (mapList.isEmpty()) {
            mapList = new ArrayList<SJmoExdPhysicalPathInfo>(0);
        }
        ret = new ArrayList<SJmoExdPhysicalPathInfo>(mapList.size() + unMapList.size());
        ret.addAll(mapList);
        ret.addAll(unMapList);
        return ret;
    }

    private void checkAlternatePath(int[] beforePathList, int[] afterPathList) {
        SJctrExternalPathStatusManager pathStatusMgr = this.getManager(SJctrExternalPathStatusManager.class);
        int errorCode = RESULT_ERROR;
        boolean found = false;
        for (int before = 0; before < beforePathList.length; ++before) {
            if (beforePathList[before] == -1) continue;
            for (int after = 0; after < afterPathList.length; ++after) {
                int physicalPathId;
                SJmoExdPathStatusInfo statusInfo;
                int status;
                if (afterPathList[after] == -1 || beforePathList[before] != afterPathList[after] || (status = (statusInfo = pathStatusMgr.getExternalPathStatusInfo(physicalPathId = afterPathList[after])).getRmiExdPathStatusInfo().getPhysicalPathStatus().getStatus()) != 1) continue;
                errorCode = RESULT_NORMAL;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            SJctrError err = new SJctrError(6, 22, 105258);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private void initManager() {
        this.addManager(SJctrSubsytemManager.class);
        this.addManager(SJctrPhysicalPathManager.class);
        this.addManager(SJctrTargetPortManager.class);
        this.addManager(SJctrPathGroupManager.class);
        this.addManager(SJctrExternalVolumeManager.class);
        this.addManager(SJctrExternalPathStatusManager.class);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExDVirtualPgInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    boolean isUsablePathGroupRSG(SJmoExdPathGroupInfo pathGrpInfo) {
        boolean result = true;
        EXDPathGroup rmiPathGrp = pathGrpInfo.getRmiExdPathGroupInfo();
        int[] pysicalPathIdList = rmiPathGrp.referAllPhysicalPathList();
        SJctrPhysicalPathManager physicalPathMgr = this.getManager(SJctrPhysicalPathManager.class);
        ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>(pysicalPathIdList.length);
        for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
            int physicalPathId = pysicalPathIdList[portcnt];
            SJmoExdPhysicalPathInfo phsicalPathInfo = physicalPathMgr.getPhysicalPathInfo(physicalPathId);
            int portId = phsicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort((short)portId);
            portList.add(portIndex);
        }
        List<SJmoPortIndex> unUsableList = this.rsgUtil.extractImpossiblePort(portList);
        if (unUsableList.size() != 0) {
            result = false;
        }
        return result;
    }

    private class PortWwnInfo {
        private int portId;
        private String wwn;

        public PortWwnInfo(int portId, String wwn) {
            this.portId = portId;
            this.wwn = wwn;
        }

        public int getPortId() {
            return this.portId;
        }

        public String getWwn() {
            return this.wwn;
        }

        public String getIndexKey() {
            String key = SJctrComUtility.toPaddingZeroString(this.portId, 5) + this.wwn;
            return key;
        }
    }

    public static enum EDIT_EXTPATHGRP_MSG implements SJctrNotifyState
    {
        RAISE_PRIORITY,
        LOWER_PRIORITY;

    }
}

