/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.volumemigration.migratevolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVolumeMigrationUtility;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public abstract class SJctrAvailableVolumesData {
    protected HashMap<String, Object> availableVolDataMap = new HashMap();
    protected List<SJmoHDPRelation> dpVolList = null;
    protected SJctrComUtility comUtil = null;
    protected List<SJmoLdevDetail> delVolList = new ArrayList<SJmoLdevDetail>();
    protected List<SJmoPgScatteredInfo> pgScatList = null;
    protected List<SJmoLdevDetail> m_lsLdevDtl = null;

    public SJctrAvailableVolumesData(List<SJmoHDPRelation> dpVolList, SJctrComUtility comUtil, List<SJmoPgScatteredInfo> pgScatList, List<SJmoLdevDetail> ldvDtlList) {
        if (comUtil == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructor", "ComUtility null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (dpVolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructor", "dpVolList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (pgScatList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructor", "pgScatList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (ldvDtlList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructor", "ldvDtlList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        this.comUtil = comUtil;
        this.dpVolList = dpVolList;
        this.pgScatList = pgScatList;
        this.m_lsLdevDtl = ldvDtlList;
    }

    public abstract void removeVolData(SJmoLdevDetail var1, SJmoLdevDetail var2);

    public abstract void addVolData(SJmoLdevDetail var1, SJmoLdevDetail var2);

    public void setVolData(SJmoLdevDetail ldev, int iVolStructFlg) {
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setVolData", "ldev null.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        String keyStr = SJctrVolumeMigrationUtility.getStrEmuCapaKey(ldev, this.comUtil);
        this.setEmuCapData(this.availableVolDataMap, keyStr, ldev, iVolStructFlg);
    }

    protected void setEmuCapData(HashMap<String, Object> setMap, String strKey, SJmoLdevDetail setData, int iVolStructFlg) {
        if (setMap == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setEmuCapData", "setMap null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (strKey == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setEmuCapData", "strKey null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (setData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setEmuCapData", "setData null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        HashMap pgPoolMap = null;
        if (setMap.containsKey(strKey)) {
            pgPoolMap = (HashMap)setMap.get(strKey);
        } else {
            pgPoolMap = new HashMap();
            setMap.put(strKey, pgPoolMap);
        }
        this.setPgPoolData(setData, pgPoolMap, iVolStructFlg);
    }

    protected void setPgPoolData(SJmoLdevDetail ldev, HashMap<String, Object> setMap, int iVolStructFlg) {
        if (setMap == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setPgPoolData", "setMap null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setPgPoolData", "ldev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        String strKey = this.getPgPoolIDKey(ldev);
        HashMap tmpSetMap = setMap;
        List<SJmoLdevDetail> ldevList = null;
        if (strKey.indexOf("POOLID") != -1) {
            HashMap poolMap = null;
            String strDp = this.comUtil.getGuidance("THP");
            if (tmpSetMap.containsKey(strDp)) {
                if (iVolStructFlg == 0) {
                    poolMap = setMap;
                    strKey = strDp;
                } else {
                    poolMap = (HashMap)tmpSetMap.get(strDp);
                }
            } else if (iVolStructFlg == 0) {
                poolMap = setMap;
                strKey = strDp;
            } else {
                poolMap = new HashMap();
                tmpSetMap.put(this.comUtil.getGuidance("THP"), poolMap);
            }
            tmpSetMap = poolMap;
        }
        if (tmpSetMap.containsKey(strKey)) {
            ldevList = (List)tmpSetMap.get(strKey);
        } else {
            ldevList = new ArrayList();
            tmpSetMap.put((String)strKey, ldevList);
        }
        int iPoint = Collections.binarySearch(ldevList, ldev);
        if (iPoint >= 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setPgPoolData", "Duplication element.");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        iPoint = -iPoint - 1;
        ldevList.add(iPoint, ldev);
    }

    protected String getPgPoolIDKey(SJmoLdevDetail ldev) {
        String strKey = null;
        if (ldev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPgPoolIDKey", "LDEV Detail = null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        switch (ldev.getByVolumeType()) {
            case 0: 
            case 1: 
            case 4: {
                strKey = SJctrVolumeMigrationUtility.getProvisoningTypeDispString(ldev, this.comUtil);
                break;
            }
            case 3: {
                int iPoint = Collections.binarySearch(this.dpVolList, ldev);
                if (iPoint < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getPgPoolIDKey", "DPVOL Info not found.");
                    throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                }
                SJmoHDPRelation dpVol = this.dpVolList.get(iPoint);
                strKey = this.makePoolIDKey(dpVol.getIPoolId());
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPgPoolIDKey", "ProvTypeValue Invalid.");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
        }
        return strKey;
    }

    protected String makePoolIDKey(int iPoolId) {
        StringBuffer strKey = new StringBuffer();
        strKey.append("POOLID");
        strKey.append(Integer.toString(iPoolId));
        return strKey.toString();
    }

    protected boolean removePgPoolData(SJmoLdevDetail ldev, String strPgPoolKey, HashMap<String, Object> pgPoolMap, int iVolFlg) {
        boolean bRemove = false;
        HashMap tmpMap = null;
        if (strPgPoolKey.indexOf("POOLID") != -1) {
            if (iVolFlg == 0) {
                tmpMap = pgPoolMap;
                strPgPoolKey = this.comUtil.getGuidance("THP");
            } else {
                tmpMap = pgPoolMap.containsKey(this.comUtil.getGuidance("THP")) ? (HashMap)pgPoolMap.get(this.comUtil.getGuidance("THP")) : new HashMap();
            }
        } else {
            tmpMap = pgPoolMap;
        }
        if (tmpMap.containsKey(strPgPoolKey)) {
            List ldevList = (List)tmpMap.get(strPgPoolKey);
            int iRemovePoint = Collections.binarySearch(ldevList, ldev);
            if (iRemovePoint >= 0) {
                ldevList.remove(iRemovePoint);
                bRemove = true;
                if (ldevList.isEmpty()) {
                    tmpMap.remove(strPgPoolKey);
                    if (strPgPoolKey.indexOf("POOLID") != -1 && tmpMap.isEmpty()) {
                        pgPoolMap.remove(this.comUtil.getGuidance("THP"));
                    }
                }
            }
            if (bRemove) {
                int iPoint = Collections.binarySearch(this.delVolList, ldev);
                if (iPoint >= 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "removePgPoolData", "Deplication.");
                    throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                }
                iPoint = -iPoint - 1;
                this.delVolList.add(iPoint, ldev);
            }
        }
        return bRemove;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.availableVolDataMap != null) {
            this.availableVolDataMap.clear();
            this.availableVolDataMap = null;
        }
    }

    public HashMap<String, Object> getAvailableVolDataMap() {
        return this.availableVolDataMap;
    }
}

