/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.createclpr;

import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrCreateClprSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_CLPR = "COM_CLPR";
    public static final String KEY_GENERAL = "COM_GENERAL";
    public static final String KEY_RESIDENT = "COM_RESIDENT";
    public static final String KEY_TOTAL_SIZE = "COM_TOTAL_SIZE";
    public static final String KEY_NUM_OF_RESIDENT = "COM_NUM_OF_RESIDENT";
    private SJmoClprInfo baseClprinfo = null;
    private SJmoClprInfo defaultClprinfo = null;

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        this.makeSummary();
    }

    public void initSummary(SJmoClprInfo baseClprinfo, SJmoClprInfo defaultClprinfo) {
        this.baseClprinfo = baseClprinfo;
        this.defaultClprinfo = defaultClprinfo;
    }

    public void updateSummary(SJmoClprInfo defaultClprinfo) {
        this.defaultClprinfo = defaultClprinfo;
        this.makeSummary();
        this.setDirty();
    }

    public void makeSummary() {
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        String strCLPRName = SJctrVpmUtility.toClprNameIdDisplay(this.baseClprinfo);
        String strGeneralCasheSize = SJctrVpmUtility.toDiffParamDisplay(this.baseClprinfo.getICacheCapacity() - this.baseClprinfo.getIDCRCapacity(), this.defaultClprinfo.getICacheCapacity() - this.defaultClprinfo.getIDCRCapacity(), capUtil, SJctrCapacityUtility.UNIT.MB);
        String strResidentCasheSize = SJctrVpmUtility.toDiffParamDisplay(this.baseClprinfo.getIDCRCapacity(), this.defaultClprinfo.getIDCRCapacity(), capUtil, SJctrCapacityUtility.UNIT.MB);
        int tortalCapa_Bef = this.baseClprinfo.getICacheCapacity();
        int tortalCapa_Aft = this.defaultClprinfo.getICacheCapacity();
        String strTotalChaseSize = SJctrVpmUtility.toDiffParamDisplay(tortalCapa_Bef, tortalCapa_Aft, capUtil, SJctrCapacityUtility.UNIT.MB);
        String strResidentExtNum = SJctrVpmUtility.toDiffParamDisplay(this.baseClprinfo.getIDCRExtentLimit(), this.defaultClprinfo.getIDCRExtentLimit());
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_CLPR, strCLPRName);
        ((SJctrDataObject)summaryData).setData(KEY_GENERAL, strGeneralCasheSize);
        ((SJctrDataObject)summaryData).setData(KEY_RESIDENT, strResidentCasheSize);
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_SIZE, strTotalChaseSize);
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_RESIDENT, strResidentExtNum);
    }
}

