/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.editclpr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.column.vpm.SJctrClprColumDiffInterface;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.vpm.com.SJctrClprTotalCacheArea;
import sanproject.sn2.controller.wizard.vpm.editclpr.SJctrEditClprClprNameArea;
import sanproject.sn2.controller.wizard.vpm.editclpr.SJctrEditClprNumofResidentExtentsArea;
import sanproject.sn2.controller.wizard.vpm.editclpr.SJctrEditClprResidentCacheArea;
import sanproject.sn2.controller.wizard.vpm.editclpr.SJctrEditClprTotalCacheArea;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprSummary;
import sanproject.sn2.model.connector.kind.SJmoGetDcrCacheInfo;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoClprSummary;
import sanproject.sn2.model.data.system.SJmoDcrCacheInfo;

public class SJctrEditClprDC
extends SJctrWizardDataController
implements SJctrClprColumDiffInterface {
    private static final int DISP_ID = 17831713;
    private static final String GUID_TITLE = "EDIT_CLPR";
    private SJctrEditClprClprNameArea editClprNameArea = null;
    private SJctrEditClprTotalCacheArea editTotalCasheArea = null;
    private SJctrEditClprResidentCacheArea editResidentCacheArea = null;
    private SJctrEditClprNumofResidentExtentsArea editNumofResidentExtentsArea = null;
    private SJctrFooterDataModel footer = null;
    private SJmoClprInfo defaultClprinfo = null;
    private SJmoClprInfo editClprInfo = null;
    private SJmoDcrCacheInfo editClprforDcr = null;
    private SJmoClprSummary clprSummary = null;
    private List<SJmoClprInfo> baseClprinfoList = null;
    private List<SJmoDcrCacheInfo> baseDcrCacheInfoList = null;
    private boolean checkEndFlg = true;

    public SJctrEditClprDC() throws SJcException {
        super(17831713);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        List<?> clprIndexList = this.getCache("KEY_SELECT_CLPR_INDEX");
        if (clprIndexList == null || clprIndexList.isEmpty()) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkStartData", "Argument Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJmoClprIndex clprIndex;
        int iSearch;
        if (SJctrDataController.isHM()) {
            this.getComUtility().getVPMUtility();
        }
        this.baseClprinfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        List<?> clprSummaryList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_SUMMARY);
        if (!SJctrDataController.isHM()) {
            this.baseDcrCacheInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_DCR_CACHEINFO);
        }
        List<?> dkcInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_DKC_INFO);
        if (!SJctrDataController.isHM()) {
            if (this.baseClprinfoList == null || this.baseClprinfoList.isEmpty() || clprSummaryList == null || clprSummaryList.isEmpty() || this.baseDcrCacheInfoList == null || this.baseDcrCacheInfoList.isEmpty() || dkcInfoList == null || dkcInfoList.isEmpty()) {
                SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "Model Data Illegal");
                SJctrVpmUtility.makeErrorDialog(107002);
            }
        } else if (this.baseClprinfoList == null || this.baseClprinfoList.isEmpty() || clprSummaryList == null || clprSummaryList.isEmpty() || dkcInfoList == null || dkcInfoList.isEmpty()) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "Model Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        this.clprSummary = (SJmoClprSummary)clprSummaryList.get(0);
        List<?> clprIndexList = this.getCache("KEY_SELECT_CLPR_INDEX");
        if (clprIndexList == null || clprIndexList.isEmpty()) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "Model Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if ((iSearch = Collections.binarySearch(this.baseClprinfoList, clprIndex = (SJmoClprIndex)clprIndexList.get(0))) >= 0) {
            try {
                this.editClprInfo = (SJmoClprInfo)this.baseClprinfoList.get(iSearch).clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "SJmoClprInfo clone Error");
                SJctrVpmUtility.makeErrorDialog(107002);
            }
        } else {
            SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "Search failure for CLPR. CLPRID:" + clprIndex.getSClpr());
            SJctrVpmUtility.makeErrorDialog(107001);
        }
        if (!SJctrDataController.isHM()) {
            int iDcrSearch = Collections.binarySearch(this.baseDcrCacheInfoList, clprIndex);
            if (iDcrSearch >= 0) {
                this.editClprforDcr = this.baseDcrCacheInfoList.get(iDcrSearch);
            } else {
                SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "Search failure for DCR. CLPRID:" + clprIndex.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107001);
            }
        }
        try {
            this.defaultClprinfo = (SJmoClprInfo)this.baseClprinfoList.get(0).clone();
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkConstructData", "SJmoClprInfo clone Error");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        ArrayList<SJmoClprInfo> defaultClprinfoList = new ArrayList<SJmoClprInfo>();
        defaultClprinfoList.add(this.defaultClprinfo);
        ArrayList<SJmoClprInfo> editClprInfoList = new ArrayList<SJmoClprInfo>();
        editClprInfoList.add(this.editClprInfo);
        this.putCache("KEY_GET_SELECTED_CLPRINFO", editClprInfoList);
        this.putCache("KEY_GET_DEFAULT_CLPRINFO", defaultClprinfoList);
        this.putCache("KEY_GET_BASE_CLPRINFO", this.baseClprinfoList);
        return true;
    }

    private void initDataModel() {
        this.editClprNameArea = new SJctrEditClprClprNameArea();
        this.addDataObjectModel("COM_CLPR_NAME_INF", this.editClprNameArea);
        this.editTotalCasheArea = new SJctrEditClprTotalCacheArea();
        this.addDataObjectModel("COM_TOTAL_CACHE", this.editTotalCasheArea);
        this.editResidentCacheArea = new SJctrEditClprResidentCacheArea();
        this.addDataObjectModel("COM_RESIDENT_CACHE", this.editResidentCacheArea);
        this.editNumofResidentExtentsArea = new SJctrEditClprNumofResidentExtentsArea();
        this.addDataObjectModel("COM_NUM_OF_EXTENTS_INF", this.editNumofResidentExtentsArea);
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrClprTotalCacheArea.TOTALCAPA_MSG.CHG_CAPA, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditClprDC.this.changeTotalCacheEvent();
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprSummary();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetDcrCacheInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetAllDKCInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void makeDataModel() {
        String strClprId = SJctrComUtility.toDecString(this.editClprInfo.getSClpr());
        this.getManageData().setData("COM_CLPR_ID", strClprId);
        if (this.editClprInfo.getSClpr() != 0) {
            this.editClprNameArea.initClprNameArea(this.editClprInfo.getStrClprName());
            int iTotalCacheSize = this.defaultClprinfo.getICacheCapacity() / SJctrVpmUtility.CLPR_CACHE_DIV_UNIT * SJctrVpmUtility.CLPR_CACHE_DIV_UNIT + this.editClprInfo.getICacheCapacity() - SJctrVpmUtility.CLPR_CACHE_MIN;
            if (iTotalCacheSize < SJctrVpmUtility.CLPR_CACHE_MIN) {
                iTotalCacheSize = SJctrVpmUtility.CLPR_CACHE_MIN;
            }
            if (!SJctrDataController.isHM()) {
                this.editTotalCasheArea.initClprTotalCacheArea(iTotalCacheSize, SJctrVpmUtility.CLPR_CACHE_MIN + SJctrVpmUtility.getSecureDcrSpaceSize(this.editClprforDcr));
            } else {
                this.editTotalCasheArea.initClprTotalCacheArea(iTotalCacheSize, SJctrVpmUtility.CLPR_CACHE_MIN);
            }
            this.editTotalCasheArea.setSelection(String.valueOf(this.editClprInfo.getICacheCapacity() / 1024));
            int iResidentCacheSize = 0;
            if (!SJctrDataController.isHM()) {
                iResidentCacheSize = this.defaultClprinfo.getIDCRCapacity() / SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT * SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT + this.editClprInfo.getIDCRCapacity();
            }
            if (iResidentCacheSize < 0) {
                iResidentCacheSize = 0;
            }
            if (!SJctrDataController.isHM()) {
                this.editResidentCacheArea.initClprResidentCacheArea(iResidentCacheSize, SJctrVpmUtility.getSecureDcrSpaceSizeForResident(this.editClprforDcr));
            } else {
                this.editResidentCacheArea.initClprResidentCacheArea(iResidentCacheSize, 0);
                this.editResidentCacheArea.setActivityArea(false);
            }
            this.changeTotalCacheEvent();
            if (!SJctrDataController.isHM()) {
                this.editNumofResidentExtentsArea.initClprResidentExtentsArea(SJctrComUtility.toDecString(this.editClprInfo.getIDCRExtentLimit()), SJctrComUtility.toDecString(this.editClprforDcr.getIDcrUsed()), SJctrComUtility.toDecString(this.editClprInfo.getIDCRExtentLimit() - this.editClprforDcr.getIDcrUsed() + this.defaultClprinfo.getIDCRExtentLimit() - this.baseDcrCacheInfoList.get(0).getIDcrUsed()));
            } else {
                this.editNumofResidentExtentsArea.initClprResidentExtentsArea(SJctrComUtility.toDecString(this.editClprInfo.getIDCRExtentLimit()), SJctrComUtility.toDecString(0), SJctrComUtility.toDecString(this.editClprInfo.getIDCRExtentLimit() + this.defaultClprinfo.getIDCRExtentLimit()));
                this.editNumofResidentExtentsArea.setActivityArea(false);
            }
            this.editResidentCacheArea.setSelection(String.valueOf(new Float(this.editClprInfo.getIDCRCapacity()).floatValue() / new Float(1024.0f).floatValue()));
        } else {
            this.editClprNameArea.initClprNameArea(this.editClprInfo.getStrClprName());
            this.editTotalCasheArea.setActivityArea(false);
            this.editResidentCacheArea.setActivityArea(false);
            this.editNumofResidentExtentsArea.setActivityArea(false);
        }
        super.makeDataModel();
        this.editTotalCasheArea.initListener();
    }

    private void changeTotalCacheEvent() {
        if (!SJctrDataController.isHM()) {
            int iResidentCacheSize = -1;
            int iResidentCacheSizeMin = 0;
            int totalCapa = this.editTotalCasheArea.getSelectCapa();
            if (totalCapa >= 0) {
                int iDiffCacheSize;
                int iDcrCacheSizeMin;
                iResidentCacheSize = totalCapa - SJctrVpmUtility.CLPR_CACHE_MIN;
                int iResidentCacheSizeMax = (this.defaultClprinfo.getIDCRCapacity() - SJctrVpmUtility.getSecureDcrSpaceSizeForResident(this.baseDcrCacheInfoList.get(0))) / SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT * SJctrVpmUtility.CLPR_RESIDENT_CACHE_DEV_UNIT + (this.editClprInfo.getIDCRCapacity() - SJctrVpmUtility.getSecureDcrSpaceSizeForResident(this.editClprforDcr));
                if (iResidentCacheSize > iResidentCacheSizeMax) {
                    iResidentCacheSize = iResidentCacheSizeMax;
                }
                if ((iDcrCacheSizeMin = (iDiffCacheSize = this.defaultClprinfo.getICacheCapacity() / SJctrVpmUtility.CLPR_CACHE_DIV_UNIT * SJctrVpmUtility.CLPR_CACHE_DIV_UNIT + this.editClprInfo.getICacheCapacity() - totalCapa) - (SJctrVpmUtility.CLPR_CACHE_MIN + SJctrVpmUtility.getSecureDcrSpaceSize(this.defaultClprinfo) - SJctrVpmUtility.getSecureDcrSpaceSize(this.editClprInfo))) < 0) {
                    iResidentCacheSizeMin = -iDcrCacheSizeMin;
                }
            }
            this.editResidentCacheArea.setIValueMin(iResidentCacheSizeMin);
            this.editResidentCacheArea.updateClprResidentCacheArea(iResidentCacheSize);
            this.editResidentCacheArea.setDirtyAll();
        }
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(GUID_TITLE);
    }

    @Override
    public boolean checkEndData() {
        SJmoClprInfo diffClprInfo = null;
        SJmoClprInfo diffSelectClprInfo = null;
        try {
            diffClprInfo = (SJmoClprInfo)this.defaultClprinfo.clone();
            diffSelectClprInfo = (SJmoClprInfo)this.editClprInfo.clone();
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkEndData", "SJmoClprInfo clone Error");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if (this.editClprNameArea.isSelCheckBox()) {
            diffSelectClprInfo.setStrClprName(this.editClprNameArea.getTextValue());
            SJctrVpmUtility.chkClprName(diffSelectClprInfo.getStrClprName(), diffSelectClprInfo, this.baseClprinfoList);
        }
        if (this.editTotalCasheArea.isSelCheckBox()) {
            int iSetTotalCahceSize = this.editTotalCasheArea.getSelectCapa();
            diffClprInfo.setICacheCapacity(diffClprInfo.getICacheCapacity() + diffSelectClprInfo.getICacheCapacity() - iSetTotalCahceSize);
            diffSelectClprInfo.setICacheCapacity(iSetTotalCahceSize);
            SJctrVpmUtility.chkTotalCacheSize(diffSelectClprInfo.getICacheCapacity(), this.clprSummary);
            if (!this.editResidentCacheArea.isSelCheckBox()) {
                if (diffSelectClprInfo.getICacheCapacity() - SJctrVpmUtility.CLPR_CACHE_MIN < diffSelectClprInfo.getIDCRCapacity()) {
                    SJctrLogUty.warn("SJctrEditClprDC", "checkEndData", "Invalid value for TotalCache. Argument:Total" + diffSelectClprInfo.getICacheCapacity() + ",Redident" + diffSelectClprInfo.getIDCRCapacity());
                    SJctrVpmUtility.makeErrorDialog(105005);
                }
                int iDefCache = diffClprInfo.getICacheCapacity();
                int iDefDcrCache = diffClprInfo.getIDCRCapacity();
                if (iDefCache - SJctrVpmUtility.getSecureDcrSpaceSize(diffClprInfo) < SJctrVpmUtility.CLPR_CACHE_MIN) {
                    SJctrLogUty.warn("SJctrEditClprDC", "checkEndData", "Default Clpr Cache is Invalid value. Cache:" + iDefCache + ",dcrCache:" + iDefDcrCache);
                    SJctrVpmUtility.makeErrorDialog(105005);
                }
            }
        }
        if (this.editResidentCacheArea.isSelCheckBox()) {
            int iSetResidentCacheSize = this.editResidentCacheArea.getSelectCapa();
            diffClprInfo.setIDCRCapacity(diffClprInfo.getIDCRCapacity() + diffSelectClprInfo.getIDCRCapacity() - iSetResidentCacheSize);
            diffSelectClprInfo.setIDCRCapacity(iSetResidentCacheSize);
            if (!this.editTotalCasheArea.isSelCheckBox() && diffSelectClprInfo.getICacheCapacity() - SJctrVpmUtility.CLPR_CACHE_MIN < diffSelectClprInfo.getIDCRCapacity()) {
                SJctrLogUty.warn("SJctrEditClprDC", "checkEndData", "Invalid value for ResidentCache. Argument:Total" + diffSelectClprInfo.getICacheCapacity() + ",Redident" + diffSelectClprInfo.getIDCRCapacity());
                SJctrVpmUtility.makeErrorDialog(105006);
            }
            SJctrVpmUtility.chkResidentCacheSize(diffSelectClprInfo.getIDCRCapacity(), this.clprSummary);
        }
        if (this.editNumofResidentExtentsArea.isSelCheckBox()) {
            int iSetResidentExts = this.editNumofResidentExtentsArea.getValue();
            diffClprInfo.setIDCRExtentLimit(diffClprInfo.getIDCRExtentLimit() + diffSelectClprInfo.getIDCRExtentLimit() - iSetResidentExts);
            diffSelectClprInfo.setIDCRExtentLimit(iSetResidentExts);
            SJctrVpmUtility.chkNumofResidentExts(diffSelectClprInfo.getIDCRExtentLimit() - this.editClprforDcr.getIDcrUsed());
        }
        int iDefCache = diffClprInfo.getICacheCapacity();
        int iDefDcrCache = diffClprInfo.getIDCRCapacity();
        if (iDefCache - SJctrVpmUtility.getSecureDcrSpaceSize(diffClprInfo) < SJctrVpmUtility.CLPR_CACHE_MIN) {
            SJctrLogUty.warn("SJctrEditClprDC", "checkEndData", "Default Clpr Cache is Invalid value. Cache:" + iDefCache + ",dcrCache:" + iDefDcrCache);
            SJctrVpmUtility.makeErrorDialog(105006);
        }
        ArrayList<SJmoClprInfo> diffClprInfoList = new ArrayList<SJmoClprInfo>();
        diffClprInfoList.add(diffClprInfo);
        this.putCache(KEY_CLASS_DIFF_CLPR_INFO_LIST, diffClprInfoList);
        ArrayList<SJmoClprInfo> editClprInfoList = new ArrayList<SJmoClprInfo>();
        editClprInfoList.add(diffSelectClprInfo);
        this.putCache("KEY_GET_SELECTED_CLPRINFO", editClprInfoList);
        return true;
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        List<?> defaultClprList;
        boolean bReturn = false;
        boolean msgFlg = false;
        this.checkEndFlg = true;
        if (this.checkEndFlg) {
            this.checkEndData();
            this.checkEndFlg = false;
        }
        if (!(((SJmoClprInfo)(defaultClprList = this.getCache(KEY_CLASS_DIFF_CLPR_INFO_LIST)).get(0)).getICacheCapacity() == this.baseClprinfoList.get(0).getICacheCapacity() && ((SJmoClprInfo)defaultClprList.get(0)).getIDCRCapacity() == this.baseClprinfoList.get(0).getIDCRCapacity() || this.checkEndFlg)) {
            List<?> createClprList = this.getCache("KEY_GET_SELECTED_CLPRINFO");
            ArrayList<SJmoClprInfo> applyList = new ArrayList<SJmoClprInfo>();
            applyList.add((SJmoClprInfo)defaultClprList.get(0));
            applyList.addAll(createClprList);
            List<SJmoAllDKCInfo> dkcInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_DKC_INFO);
            msgFlg = SJctrVpmUtility.chkClprLowCacheSize(dkcInfoList, applyList);
            if (msgFlg) {
                SJctrRelatedDispDataObject related = this.createMsgDialog(SJctrVpmUtility.getWarningMsg(105022));
                SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
                msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrEditClprDC.this.finishEvent(msgEvent, dstModel);
                    }
                });
                msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
                this.addUpdateDisp(related);
                bReturn = true;
            }
        }
        return bReturn;
    }
}

