/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.migrateclprresources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.column.vpm.SJctrClprColumDiffInterface;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyDialogDC;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprAvailablePgTableModel;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprAvailableVVolTableModel;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetDCRInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoDiskAddress;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrMigrateClprDC
extends SJctrWizardDataController
implements SJctrClprColumDiffInterface {
    private static final int DISP_ID = 17831537;
    private static final String GUID_TITLE = "MIGRATE_CLPR";
    public static final String KEY_FILTER_CLPR_PG = "KEY_FILTER_CLPR_PG";
    public static final String KEY_FILTER_CLPR_VVOL = "KEY_FILTER_CLPR_VVOL";
    private SJctrComboBoxDataModel clprComboBox = null;
    private SJctrComboBoxDataModel cuComboBox = null;
    private SJctrMigrateClprAvailablePgTableModel pgTable = null;
    private SJctrMigrateClprAvailableVVolTableModel vVolTable = null;
    private SJctrMigrateClprTableModel clprTable = null;
    private SJctrFooterDataModel footer = null;
    private List<SJmoClprInfo> migClprInfoList = new ArrayList<SJmoClprInfo>();
    private List<SJmoPgDetail> migPgDtlList = new ArrayList<SJmoPgDetail>();
    private List<SJmoLdevDetail> migLdevDtlList = new ArrayList<SJmoLdevDetail>();
    private List<SJmoClprInfo> baseClprInfoList = new ArrayList<SJmoClprInfo>();
    private List<SJmoPgDetail> basePgDtlList = new ArrayList<SJmoPgDetail>();
    private List<SJmoLdevDetail> baseLdevDtlList = new ArrayList<SJmoLdevDetail>();

    public SJctrMigrateClprDC() throws SJcException {
        super(17831537);
        this.initDataModel();
    }

    @Override
    public boolean checkConstructData() {
        if (SJctrDataController.isHM()) {
            this.getComUtility().getVPMUtility();
        }
        this.baseClprInfoList = this.getCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        this.basePgDtlList = this.getCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL);
        this.baseLdevDtlList = this.getCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL);
        List<SJmoPgScatteredInfo> pgScatteredList = this.getCache(SJctrVpmUtility.KEY_CLASS_PG_SCATTERED_INFO);
        List<SJmoVdevDetail> vdevList = this.getCache(SJctrVpmUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPdevDetail> pdevList = this.getCache(SJctrVpmUtility.KEY_CLASS_PDEV_DETAIL);
        List<?> dcrList = this.getCache(SJctrVpmUtility.KEY_CLASS_DCR_INFO);
        List<?> allRsgsList = this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_RSG);
        if (this.baseClprInfoList == null || this.baseClprInfoList.isEmpty() || this.basePgDtlList == null || pgScatteredList == null || this.baseLdevDtlList == null || dcrList == null || allRsgsList == null || allRsgsList.isEmpty()) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkConstructData", "Model Data Illegal");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        if (this.baseClprInfoList.size() <= 1) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkConstructData", "Immovable for CLPR.");
            SJctrVpmUtility.makeErrorDialog(106008);
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)allRsgsList.get(0));
        List<SJmoPgIndex> usablePgDtlList = rsgUtil.extractPg(this.basePgDtlList);
        List<SJmoLdevIndex> usableLdevDtlList = SJctrVpmUtility.getVVolList(this.baseLdevDtlList);
        usableLdevDtlList = rsgUtil.extractLdev(usableLdevDtlList);
        if (usablePgDtlList.size() + usableLdevDtlList.size() == 0) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkConstructData", "Immovable for Resource.");
            SJctrVpmUtility.makeErrorDialog(106007);
        }
        List<SJctrPGDetail> ctrPgDtlList = SJctrVpmUtility.toCtrPgDetailList(usablePgDtlList, this.basePgDtlList, pgScatteredList, vdevList, pdevList, this.baseLdevDtlList);
        ArrayList<SJctrPGDetail> noScPgDtlList = new ArrayList<SJctrPGDetail>();
        for (SJctrPGDetail ctrPgDtl : ctrPgDtlList) {
            if (!ctrPgDtl.isScTopPG()) continue;
            noScPgDtlList.add(ctrPgDtl);
        }
        try {
            for (SJmoClprInfo clpr : this.baseClprInfoList) {
                this.migClprInfoList.add((SJmoClprInfo)clpr.clone());
            }
            for (SJctrPGDetail pgDtl : noScPgDtlList) {
                this.migPgDtlList.add((SJctrPGDetail)pgDtl.clone());
            }
            for (SJmoLdevIndex ldevIdx : usableLdevDtlList) {
                this.migLdevDtlList.add((SJmoLdevDetail)ldevIdx.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkConstructData", "Model Data clone Error");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        this.putCache(SJctrVpmUtility.KEY_CLASS_CLPR_INFO, this.migClprInfoList);
        this.putCache(SJctrVpmUtility.KEY_CLASS_PG_DETAIL, this.migPgDtlList);
        this.putCache(SJctrVpmUtility.KEY_CLASS_LDEV_DETAIL, this.migLdevDtlList);
        this.putCache("KEY_GET_BASE_CLPRINFO", this.baseClprInfoList);
        this.putCache("KEY_GET_SELECTED_CLPRINFO_ALL", this.migClprInfoList);
        return true;
    }

    private void initDataModel() {
        this.clprComboBox = new SJctrComboBoxDataModel();
        this.clprComboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrMigrateClprDC.this.changeClprEvent();
                }
            }
        });
        this.addDataObjectModel("COM_CLPR_CMB", this.clprComboBox);
        this.cuComboBox = new SJctrComboBoxDataModel();
        this.cuComboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrMigrateClprDC.this.changeCuEvent();
                }
            }
        });
        this.addDataObjectModel("COM_CU_CMB", this.cuComboBox);
        this.pgTable = new SJctrMigrateClprAvailablePgTableModel();
        this.addDataObjectModel("COM_TABLE_PG", this.pgTable);
        this.vVolTable = new SJctrMigrateClprAvailableVVolTableModel();
        this.addDataObjectModel("COM_TABLE_VVOL", this.vVolTable);
        this.clprTable = new SJctrMigrateClprTableModel();
        this.addDataObjectModel("COM_TABLE_CLPR", this.clprTable);
        SJctrButtonDataModel setBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_SET_BTN", setBtn);
        setBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMigrateClprDC.this.setAction();
            }
        });
        SJctrButtonDataModel detailBtn = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_DETAIL", detailBtn);
        detailBtn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMigrateClprDC.this.detailAction();
            }
        });
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetDCRInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgScatteredInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetVdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void makeDataModel() {
        HashMap clprPgMap = new HashMap();
        for (SJmoPgDetail pgDtl : this.migPgDtlList) {
            short sKey = pgDtl.getCLPR();
            if (clprPgMap.get(sKey) == null) {
                clprPgMap.put(sKey, new ArrayList());
            }
            ((List)clprPgMap.get(sKey)).add(pgDtl);
        }
        ArrayList putPgList = new ArrayList();
        putPgList.add(clprPgMap);
        this.putCache(KEY_FILTER_CLPR_PG, putPgList);
        HashMap clprVvolMap = new HashMap();
        for (SJmoLdevDetail ldevDtl : this.migLdevDtlList) {
            short sClprKey = ldevDtl.getSCLPR();
            if (clprVvolMap.get(sClprKey) == null) {
                clprVvolMap.put(sClprKey, new ArrayList());
            }
            ((List)clprVvolMap.get(sClprKey)).add(ldevDtl);
        }
        ArrayList putVvolList = new ArrayList();
        putVvolList.add(clprVvolMap);
        this.putCache(KEY_FILTER_CLPR_VVOL, putVvolList);
        this.clprComboBox.addItem(this.getComUtility().getGuidance("ANY"));
        for (SJmoClprInfo clprInfo : this.migClprInfoList) {
            this.clprComboBox.addItem(SJctrVpmUtility.toClprNameIdDisplay(clprInfo));
        }
        this.clprComboBox.setEnable(true);
        this.cuComboBox.setEnable(true);
        this.clprComboBox.setSelectedIndex(0);
        this.clprTable.setBasicData(KEY_CLASS_DIFF_CLPR_INFO_LIST, this.migClprInfoList);
        this.pgTable.setTableKeyList(this.migPgDtlList);
        this.pgTable.setBasicData(SJctrVpmUtility.KEY_CLASS_ALL_RSG, this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_RSG));
        this.vVolTable.setTableKeyList(this.migLdevDtlList);
        this.vVolTable.setBasicData(SJctrVpmUtility.KEY_CLASS_ALL_RSG, this.getCache(SJctrVpmUtility.KEY_CLASS_ALL_RSG));
        this.clprTable.setTableKeyList(this.baseClprInfoList);
        super.makeDataModel();
    }

    private void setAction() {
        SJmoClprInfo moveClpr;
        Map clprPgMap = (Map)this.getCache(KEY_FILTER_CLPR_PG).get(0);
        Map clprVvolMap = (Map)this.getCache(KEY_FILTER_CLPR_VVOL).get(0);
        List<Object> clprDataList = this.clprTable.getSelectedRowData();
        List<Object> pgDataList = this.pgTable.getSelectedRowData();
        List<Object> ldevDataList = this.vVolTable.getSelectedRowData();
        if (pgDataList.size() == 0 && ldevDataList.size() == 0) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Invalid value for Resource Table");
            SJctrVpmUtility.makeErrorDialog(105018);
        }
        if (clprDataList.size() != 1) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Invalid value for CLPR Table");
            SJctrVpmUtility.makeErrorDialog(105019);
        }
        List<SJmoClprInfo> clprInfoList = this.migClprInfoList;
        List<?> pgScatteredList = this.getCache(SJctrVpmUtility.KEY_CLASS_PG_SCATTERED_INFO);
        List<SJmoDCRInfo> dcrList = this.getCache(SJctrVpmUtility.KEY_CLASS_DCR_INFO);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoPgDetail sJmoPgDetail : new ArrayList<Object>(pgDataList)) {
            if (SJctrVpmUtility.chkMigClprForDcrCache(sJmoPgDetail, this.baseLdevDtlList, dcrList)) continue;
            SJctrVpmUtility.makeErrorList(errList, sJmoPgDetail, 105014);
        }
        if (errList.size() > 0) {
            SJctrRelatedDispDataObject relDisp = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController sJctrErrorDataController = (SJctrErrorDataController)this.getOwner().getDataController(relDisp);
            sJctrErrorDataController.setParameter(this.pgTable, errList);
            SJctrError representErrorInfo = sJctrErrorDataController.getRepresentativeError(errList);
            SJcException sJcException = representErrorInfo.createException();
            sJcException.setErrDisp(relDisp);
            throw sJcException;
        }
        int iSearch = Collections.binarySearch(clprInfoList, clprDataList.get(0));
        if (iSearch < 0) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Search failure for CLPR. CLPRID:" + ((SJmoClprInfo)clprDataList.get(0)).getSClpr());
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        SJmoClprInfo sJmoClprInfo = clprInfoList.get(iSearch);
        for (SJmoPgDetail sJmoPgDetail : new ArrayList<Object>(pgDataList)) {
            moveClpr = new SJmoClprInfo();
            moveClpr.setSClpr(sJmoPgDetail.getCLPR());
            iSearch = Collections.binarySearch(clprInfoList, moveClpr);
            if (iSearch < 0) {
                SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Search failure for PG-CLPR. PG:" + sJmoPgDetail.getIndex() + ",CLPRID:" + moveClpr.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            if (sJmoClprInfo.equals(moveClpr = clprInfoList.get(iSearch))) continue;
            ArrayList<SJmoPgDetail> migPgIdxList = new ArrayList<SJmoPgDetail>();
            migPgIdxList.add(sJmoPgDetail);
            iSearch = Collections.binarySearch(pgScatteredList, sJmoPgDetail);
            if (iSearch >= 0) {
                migPgIdxList.addAll(((SJmoPgScatteredInfo)pgScatteredList.get(iSearch)).getAlPgIndex());
            }
            for (SJmoPgIndex sJmoPgIndex : migPgIdxList) {
                iSearch = Collections.binarySearch(moveClpr.getDiskAddressList(), sJmoPgIndex);
                if (iSearch < 0) {
                    SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Search failure for CLPR-DISK(PG). DISK:" + sJmoPgDetail.getIndex() + ",CLPRID:" + moveClpr.getSClpr());
                    SJctrVpmUtility.makeErrorDialog(107002);
                }
                SJmoDiskAddress migDiskAdr = moveClpr.getDiskAddressList().get(iSearch);
                moveClpr.getDiskAddressList().remove(iSearch);
                sJmoClprInfo.getDiskAddressList().add(migDiskAdr);
                List clprPgList = (List)clprPgMap.get(sJmoPgDetail.getCLPR());
                clprPgList.remove(clprPgList.indexOf(sJmoPgDetail));
                if (clprPgList.isEmpty()) {
                    clprPgMap.remove(sJmoPgDetail.getCLPR());
                }
                sJmoPgDetail.setCLPR(sJmoClprInfo.getSClpr());
                if (!((SJctrPGDetail)sJmoPgDetail).isScTopPG()) continue;
                List clprList = (List)clprPgMap.get(sJmoPgDetail.getCLPR());
                if (clprList == null) {
                    clprPgMap.put(sJmoPgDetail.getCLPR(), new ArrayList());
                }
                ((List)clprPgMap.get(sJmoPgDetail.getCLPR())).add(sJmoPgDetail);
            }
        }
        for (SJmoLdevDetail sJmoLdevDetail : new ArrayList<Object>(ldevDataList)) {
            moveClpr = new SJmoClprInfo();
            moveClpr.setSClpr(sJmoLdevDetail.getSCLPR());
            iSearch = Collections.binarySearch(clprInfoList, moveClpr);
            if (iSearch < 0) {
                SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Search failure for VVOL-CLPR. VVOL:" + sJmoLdevDetail.getIndex() + " CLPRID:" + moveClpr.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            if (sJmoClprInfo.equals(moveClpr = clprInfoList.get(iSearch))) continue;
            SJmoPgIndex setPgIndex = new SJmoPgIndex();
            setPgIndex.setFB4(sJmoLdevDetail.getIFB4());
            setPgIndex.setPG(sJmoLdevDetail.getIPG());
            iSearch = Collections.binarySearch(moveClpr.getDiskAddressList(), setPgIndex);
            if (iSearch < 0) {
                SJctrLogUty.warn("SJctrMigrateClprDC", "setAction", "Search failure for CLPR-DISK(VVOL). DISK:" + setPgIndex.getIndex() + ",CLPRID:" + moveClpr.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            SJmoDiskAddress migDiskAdr = moveClpr.getDiskAddressList().get(iSearch);
            moveClpr.getDiskAddressList().remove(iSearch);
            sJmoClprInfo.getDiskAddressList().add(migDiskAdr);
            List list = (List)clprVvolMap.get(sJmoLdevDetail.getSCLPR());
            list.remove(list.indexOf(sJmoLdevDetail));
            if (list.isEmpty()) {
                clprVvolMap.remove(sJmoLdevDetail.getSCLPR());
            }
            sJmoLdevDetail.setSCLPR(sJmoClprInfo.getSClpr());
            List clprList = (List)clprVvolMap.get(sJmoLdevDetail.getSCLPR());
            if (clprList == null) {
                clprVvolMap.put(sJmoLdevDetail.getSCLPR(), new ArrayList());
            }
            ((List)clprVvolMap.get(sJmoLdevDetail.getSCLPR())).add(sJmoLdevDetail);
        }
        Collections.sort(sJmoClprInfo.getDiskAddressList());
        Iterator<Object> i$ = clprPgMap.keySet().iterator();
        while (i$.hasNext()) {
            short s = (Short)i$.next();
            Collections.sort((List)clprPgMap.get(s));
        }
        i$ = clprVvolMap.keySet().iterator();
        while (i$.hasNext()) {
            short s = (Short)i$.next();
            Collections.sort((List)clprVvolMap.get(s));
        }
        ArrayList<Map> pgSetList = new ArrayList<Map>();
        pgSetList.add(clprPgMap);
        this.putCache(KEY_FILTER_CLPR_PG, pgSetList);
        ArrayList<Map> arrayList = new ArrayList<Map>();
        arrayList.add(clprVvolMap);
        this.putCache(KEY_FILTER_CLPR_VVOL, arrayList);
        this.changeClprEvent();
        this.changeCuEvent();
        this.pgTable.doRefresh();
        this.pgTable.addRowSelectionList(pgDataList);
        this.vVolTable.doRefresh();
        this.vVolTable.addRowSelectionList(ldevDataList);
        this.clprTable.doRefresh();
        this.clprTable.addRowSelectionList(clprDataList);
        this.getWizardWindow().rollback();
    }

    public void detailAction() {
        if (this.clprTable.getSelectedRowCount() != 1) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "detailAction", "Invalid value for Table:" + this.clprTable.getSelectedRowCount());
            SJctrVpmUtility.makeErrorDialog(105002);
        }
        List<Object> basicDataList = this.clprTable.getSelectedRowDataOrder();
        HashMap transDataMap = new HashMap();
        Collections.sort(this.migClprInfoList);
        Collections.sort(this.migPgDtlList);
        Collections.sort(this.migLdevDtlList);
        transDataMap.put("KEY_SELECT_CLPR_INDEX", basicDataList);
        transDataMap.put("KEY_GET_BASE_CLPRINFO", this.baseClprInfoList);
        transDataMap.put("KEY_DETAIL_CLPR_DETAIL", this.migClprInfoList);
        transDataMap.put("KEY_DETAIL_PG_DETAIL", this.migPgDtlList);
        transDataMap.put("KEY_DETAIL_LDEV_DETAIL", this.migLdevDtlList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrClprPropertyDialogDC.class, transDataMap);
        this.addUpdateDisp(relatedObj);
    }

    private void changeClprEvent() {
        Map clprPgMap = (Map)this.getCache(KEY_FILTER_CLPR_PG).get(0);
        Map clprVvolMap = (Map)this.getCache(KEY_FILTER_CLPR_VVOL).get(0);
        ArrayList<SJmoPgDetail> pgDataList = new ArrayList();
        ArrayList<SJmoLdevDetail> ldevDataList = new ArrayList();
        String strSelectClpr = this.clprComboBox.getSelection();
        if (!strSelectClpr.equals(this.getComUtility().getGuidance("ANY"))) {
            short sSelClpr = -1;
            for (SJmoClprInfo clprInfo : this.migClprInfoList) {
                if (!SJctrVpmUtility.toClprNameIdDisplay(clprInfo).equals(strSelectClpr)) continue;
                sSelClpr = clprInfo.getSClpr();
                break;
            }
            if (clprPgMap.get(sSelClpr) != null) {
                pgDataList = (List)clprPgMap.get(sSelClpr);
            }
            if (clprVvolMap.get(sSelClpr) != null) {
                ldevDataList = (List)clprVvolMap.get(sSelClpr);
            }
        } else {
            short sClpr;
            Iterator i$ = clprPgMap.keySet().iterator();
            while (i$.hasNext()) {
                sClpr = (Short)i$.next();
                pgDataList.addAll((Collection)clprPgMap.get(sClpr));
            }
            i$ = clprVvolMap.keySet().iterator();
            while (i$.hasNext()) {
                sClpr = (Short)i$.next();
                ldevDataList.addAll((Collection)clprVvolMap.get(sClpr));
            }
            Collections.sort(pgDataList);
            Collections.sort(ldevDataList);
        }
        ArrayList<Short> cuList = new ArrayList<Short>();
        for (SJmoLdevDetail LdevDtl : ldevDataList) {
            short sCuKey = LdevDtl.getSCu();
            if (cuList.contains(sCuKey)) continue;
            cuList.add(sCuKey);
        }
        String defSelCu = this.cuComboBox.getSelection();
        this.cuComboBox.removeAllItems();
        this.cuComboBox.addItem(this.getComUtility().getGuidance("ANY"));
        for (Short sCu : cuList) {
            this.cuComboBox.addItem(SJctrComUtility.toHexString(sCu.shortValue(), 2, true));
        }
        if (defSelCu == null || !this.cuComboBox.setSelection(defSelCu)) {
            this.cuComboBox.setSelectedIndex(0);
        }
        this.pgTable.setTableKeyList(pgDataList);
        this.pgTable.doRefresh();
        this.vVolTable.setTableKeyList(ldevDataList);
        this.vVolTable.doRefresh();
        this.changeCuEvent();
        this.cuComboBox.setDirty();
    }

    private void changeCuEvent() {
        ArrayList<SJmoLdevDetail> ldevCuFilterList = new ArrayList<SJmoLdevDetail>();
        Map clprVvolMap = (Map)this.getCache(KEY_FILTER_CLPR_VVOL).get(0);
        String strAny = this.getComUtility().getGuidance("ANY");
        List ldevDataList = new ArrayList();
        String strSelectClpr = this.clprComboBox.getSelection();
        if (!strSelectClpr.equals(this.getComUtility().getGuidance("ANY"))) {
            short sSelClpr = -1;
            for (SJmoClprInfo clprInfo : this.migClprInfoList) {
                if (!SJctrVpmUtility.toClprNameIdDisplay(clprInfo).equals(strSelectClpr)) continue;
                sSelClpr = clprInfo.getSClpr();
                break;
            }
            if (clprVvolMap.get(sSelClpr) != null) {
                ldevDataList = (List)clprVvolMap.get(sSelClpr);
            }
        } else {
            Iterator i$ = clprVvolMap.keySet().iterator();
            while (i$.hasNext()) {
                short sClpr = (Short)i$.next();
                ldevDataList.addAll((Collection)clprVvolMap.get(sClpr));
            }
            Collections.sort(ldevDataList);
        }
        String strSelectCu = this.cuComboBox.getSelection();
        if (strSelectCu != null && !strSelectCu.equals(strAny)) {
            short sSelCu = Short.parseShort(strSelectCu, 16);
            for (SJmoLdevDetail ldevDtl : ldevDataList) {
                if (ldevDtl.getSCu() != sSelCu) continue;
                ldevCuFilterList.add(ldevDtl);
            }
        } else {
            ldevCuFilterList = ldevDataList;
        }
        this.vVolTable.setTableKeyList(ldevCuFilterList);
        this.vVolTable.doRefresh();
    }

    @Override
    public boolean checkEndData() {
        if (this.clprTable.getAllRowData().size() == 0) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkEndData", "Contradiction extraction");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        int iPgCnt = 0;
        int iVvolCnt = 0;
        for (SJmoClprInfo clprInfo : this.migClprInfoList) {
            iPgCnt += SJctrVpmUtility.getPgListCnt(clprInfo, this.migPgDtlList);
            iVvolCnt += SJctrVpmUtility.getVVolList(clprInfo, this.migLdevDtlList).size();
        }
        int iSetPgCnt = 0;
        ArrayList<SJmoPgDetail> ctrPGList = new ArrayList<SJmoPgDetail>(this.migPgDtlList);
        for (SJctrPGDetail sJctrPGDetail : ctrPGList) {
            ++iSetPgCnt;
            if (!sJctrPGDetail.isScTopPG()) continue;
            iSetPgCnt += sJctrPGDetail.getPGScatteredList().size();
        }
        int iSetVvolCnt = 0;
        for (SJmoClprInfo clprInfo : this.baseClprInfoList) {
            iSetVvolCnt += SJctrVpmUtility.getVVolList(clprInfo, this.migLdevDtlList).size();
        }
        if (iSetPgCnt != iPgCnt || iSetVvolCnt != iVvolCnt) {
            SJctrLogUty.warn("SJctrMigrateClprDC", "checkEndData", "Contradiction extraction for CLPR. PG:" + iPgCnt + ",iSetPgCnt:" + iSetPgCnt + ",Vvol:" + iVvolCnt + ",iSetVvolCnt:" + iSetVvolCnt);
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        return true;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(GUID_TITLE);
    }
}

