/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.migrateclprresources;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashSet;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprAC;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprConfirmDC;
import sanproject.sn2.controller.wizard.vpm.migrateclprresources.SJctrMigrateClprDC;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoDiskAddress;

public class SJctrMigrateClprSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "MIGRATE_CLPR";
    private static final Class<?> CONFIRM_DC = SJctrMigrateClprConfirmDC.class;
    public static final String KEY_GET_SELECTED_CLPRINFO_ALL = "KEY_GET_SELECTED_CLPRINFO_ALL";
    public static final String KEY_GET_BASE_CLPRINFO = "KEY_GET_BASE_CLPRINFO";

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{SJctrMigrateClprDC.class};
        return clsList;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrRelatedDispDataObject related;
        SJctrUserController uc = wizard.getOwner();
        SJctrMigrateClprDC dc = (SJctrMigrateClprDC)uc.getDataController(related = uc.getRelatedDispData(SJctrMigrateClprDC.class));
        if (dc == null) {
            SJctrLogUty.warn("SJctrMigrateClprSubWizard", "constructConfirmData", "Contradiction extraction");
            SJctrVpmUtility.makeErrorDialog(107002);
        }
        ArrayList<SJmoClprInfo> beforClprInfoList = new ArrayList<SJmoClprInfo>(dc.getCache(KEY_GET_BASE_CLPRINFO));
        ArrayList<SJmoClprInfo> afterDataList = new ArrayList<SJmoClprInfo>(dc.getCache(KEY_GET_SELECTED_CLPRINFO_ALL));
        ArrayList<SJmoClprInfo> targetList = new ArrayList<SJmoClprInfo>();
        for (SJmoClprInfo migClpr : afterDataList) {
            int iSearch = Collections.binarySearch(afterDataList, (Object)migClpr);
            if (iSearch < 0) {
                SJctrLogUty.warn("SJctrMigrateClprSubWizard", "constructConfirmData", "Search failure for CLPR.  CLPRID:" + migClpr.getSClpr());
                SJctrVpmUtility.makeErrorDialog(107002);
            }
            HashSet<Integer> chkBeforResSet = new HashSet<Integer>();
            HashSet<Integer> chkAfterResSet = new HashSet<Integer>();
            for (SJmoDiskAddress beforDiskAdr : ((SJmoClprInfo)beforClprInfoList.get(iSearch)).getDiskAddressList()) {
                chkBeforResSet.add(beforDiskAdr.getIndex());
            }
            for (SJmoDiskAddress afterDiskAdr : migClpr.getDiskAddressList()) {
                chkAfterResSet.add(afterDiskAdr.getIndex());
            }
            if (chkBeforResSet.containsAll(chkAfterResSet) && chkBeforResSet.size() == chkAfterResSet.size()) continue;
            targetList.add(migClpr);
        }
        Collections.sort(targetList);
        SJctrMigrateClprAC ac = new SJctrMigrateClprAC();
        ac.setApplyList(afterDataList, targetList, beforClprInfoList);
        SJctrRelatedDispDataObject confirmRelated = uc.getRelatedDispData(CONFIRM_DC);
        wizard.addConfirmData(ac, confirmRelated);
    }
}

