/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.com;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.httpcli.com.SJhtclStringUty;

public class SJhtclRelocationLogUty {
    private static final String SPACE = " ";
    private static final String CHANGE_LINE = "\n";
    private static final String DIRECTORY_NAME = "hdtlogcli";
    private static final String ASTERISK = ".*";
    private static final String EXTENSION_TGZ = "\\.tgz$";
    public static final String CREATE_TIME_FORMAT_YYYYMMDDHHMMSS = "yyyy/MM/dd-HH:mm:ss";
    public static final String FORMAT_YYMMDD = "yyMMdd";
    public static final String RELOCATIONLOG_FORMAT_DEFAULT = "%s-%s-RelocationLog";

    public static String createResponseContents(HashMap<String, Date> logMap, SJbaseUserSessionInterface session) {
        SJcGuidanceHandleInterface guidHandler = session.getGuidanceInfo();
        String strGuidRelocationLogName = guidHandler.getGuidance("HDT_CLI_RELOCATION_LOG_NAME");
        String strGuidCreateTime = guidHandler.getGuidance("XPDT_CLI_CREATE_TIME");
        String strResult = SJhtclStringUty.treatString(strGuidRelocationLogName, 32) + SPACE + SJhtclStringUty.treatString(strGuidCreateTime, 19);
        strResult = strResult + CHANGE_LINE;
        if (null != logMap) {
            List<Map.Entry<String, Date>> entries = SJhtclRelocationLogUty.sortRelocationLogAtCreateTimeDesc(logMap);
            for (Map.Entry<String, Date> entry : entries) {
                String strLogName = entry.getKey();
                SimpleDateFormat df = new SimpleDateFormat(CREATE_TIME_FORMAT_YYYYMMDDHHMMSS);
                String strCreateTime = df.format(entry.getValue());
                strResult = strResult + SJhtclStringUty.treatString(strLogName, 32) + SPACE + SJhtclStringUty.treatString(strCreateTime, 19);
                strResult = strResult + CHANGE_LINE;
            }
        }
        return strResult;
    }

    public static List<Map.Entry<String, Date>> sortRelocationLogAtCreateTimeDesc(HashMap<String, Date> logMap) {
        ArrayList<Map.Entry<String, Date>> entries = new ArrayList<Map.Entry<String, Date>>();
        if (null != logMap) {
            entries.addAll(logMap.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Date>>(){

                @Override
                public int compare(Map.Entry<String, Date> o1, Map.Entry<String, Date> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
        }
        return entries;
    }

    public static List<String> getRelocationLogFileList() throws FileNotFoundException {
        ArrayList<String> strFileList = new ArrayList<String>();
        String strRegex = ASTERISK.concat(EXTENSION_TGZ);
        String strRelocationLogPath = SJhtclRelocationLogUty.getRelocationLogBasePath();
        File fileRelocationLogDirectoryPath = new File(strRelocationLogPath);
        if (!fileRelocationLogDirectoryPath.isDirectory()) {
            throw new FileNotFoundException(fileRelocationLogDirectoryPath.toString());
        }
        String[] strFileLists = fileRelocationLogDirectoryPath.list();
        if (strFileLists != null) {
            for (String strFile : strFileLists) {
                String strFileName;
                if (!strFile.matches(strRegex) || 32 < (strFileName = strFile.replaceAll(EXTENSION_TGZ, "")).length()) continue;
                strFileList.add(strFile);
            }
        }
        return strFileList;
    }

    public static HashMap<String, Date> makeRelocationLogInfo(List<String> fileList) throws SJcException {
        HashMap<String, Date> logInfMap = new HashMap<String, Date>();
        String strRelocationLogPath = SJhtclRelocationLogUty.getRelocationLogBasePath();
        for (String strFile : fileList) {
            Path path = Paths.get(strRelocationLogPath.concat(strFile), new String[0]);
            BasicFileAttributes attr = null;
            try {
                attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ex) {
                SJcException sjcEx = new SJcException("205", "25", "107010");
                throw sjcEx;
            }
            logInfMap.put(strFile.replaceAll(EXTENSION_TGZ, ""), new Date(attr.creationTime().toMillis()));
        }
        return logInfMap;
    }

    public static String getRelocationLogBasePath() {
        return SJcFileUty.setEndPathSeparator(SJcEnvUty.getSnBasePath().concat(DIRECTORY_NAME));
    }
}

