/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.request;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.request.inf.SJhtclRequestInterface;

public class SJhtclRequestBase
implements SJhtclRequestInterface {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclRequestBase.class.getSimpleName();
    protected static SJcLoggerInterface htclLogger = null;

    public SJhtclRequestBase() {
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    public HashMap<String, Object> processRequest(HttpServletRequest req) {
        String LOG_SUBTITLE = "processRequest";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "Start.");
        HashMap responseMap = null;
        String sessionId = req.getParameter("GlobalSessionID");
        SJbaseUserSessionInterface session = SJhtclHttpCliUty.getUserSession(sessionId);
        if (session != null) {
            HashMap<String, String[]> requestParams = new HashMap<String, String[]>();
            requestParams.putAll(req.getParameterMap());
            for (String key : requestParams.keySet()) {
                String param = SJhtclParameterUty.getStrFromMap(requestParams, key);
                if (param == null) continue;
                requestParams.put(key, new String[]{param.trim()});
            }
            String raidinfVer = req.getHeader("User-Agent");
            raidinfVer = raidinfVer.replace("HSS-CLI/", "");
            requestParams.put("raidinf-version", new String[]{raidinfVer});
            SJctrRequestDataObject reqObj = new SJctrRequestDataObject();
            HashMap<String, Object> reqMap = reqObj.getDataMap();
            reqMap.put("RequestKey", requestParams);
            try {
                SJctrRequestDataObject resData = session.post("HttpCliExecute", reqObj);
                HashMap<String, Object> resMap = resData.getDataMap();
                responseMap = (HashMap)resMap.get("ResponseKey");
            }
            catch (SJcException sjce) {
                responseMap = SJhtclHttpCliUty.getErrorMap(sjce.getMsg());
            }
            catch (Exception e) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "processRequest", "Native exception occurred.", e);
                responseMap = SJhtclHttpCliUty.getErrorMapBase("107001");
            }
        } else {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "processRequest", "User session is not found. -GlobalSessionID:" + sessionId);
            responseMap = SJhtclHttpCliUty.getErrorMapBase("107005");
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "processRequest", "End.");
        return responseMap;
    }
}

