/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.communicate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import sanproject.serverux.ssl.uty.SSLUty;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.exception.KMSConfigException;
import sanproject.sn2.kms.kmip.client.exception.KmsCommunicationException;
import sanproject.sn2.kms.kmip.client.exception.ReadPropertyFileException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVFactory;
import sanproject.sn2.kms.kmip.client.util.KmsConfiguration;
import sanproject.sn2.kms.kmip.client.util.KmsConfigurationFactory;
import sanproject.sn2.kms.util.SJkmsKeystoreUty;
import sanproject.sn2.kms.util.SJkmsLogUtil;
import sanproject.sn2.kms.util.SJkmsTRlog;

public class ConnectKmsModule {
    private static final String module = "ConnectKmsModule";
    boolean secondaryKMSFlag = true;
    public KmsConfiguration[] confAry = null;
    private SSLSocket sslSocket;
    InputStream netInputStream;
    OutputStream netOutputStream;
    private boolean keyStoreUpdateMode = false;
    private boolean trustStoreUpdateMode = false;
    private String password = null;

    public ConnectKmsModule(Properties properties, boolean _keyStoreUpdateMode, boolean _trustStoreUpdateMode, String _password) throws KMSConfigException, ReadPropertyFileException {
        String method = "constructor";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        this.keyStoreUpdateMode = _keyStoreUpdateMode;
        this.trustStoreUpdateMode = _trustStoreUpdateMode;
        this.password = _password;
        this.confAry = KmsConfigurationFactory.getConfigrations(properties);
        STD_LOGGER.info(module, method, " - ", " - end");
        if (this.confAry == null || this.confAry.length == 0) {
            STD_LOGGER.info(module, method, " - check the configuration objectes", " - invalid");
            throw new KMSConfigException();
        }
    }

    public void getConnection(int i) throws KmsCommunicationException {
        String method = "getConnection";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        try {
            List<String> servernames = KmsConfigurationFactory.getServerNames(this.confAry);
            HashMap<String, KeyManager[]> keymanager = SJkmsKeystoreUty.getKeyManager(servernames, this.keyStoreUpdateMode, this.password);
            HashMap<String, TrustManager[]> trustmanager = SJkmsKeystoreUty.getTrustManager(servernames, this.trustStoreUpdateMode);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            String servername = this.confAry[i].getServerName();
            sslContext.init(keymanager.get(servername), trustmanager.get(servername), null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            this.sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.confAry[i].getHost(), this.confAry[i].getPort());
            STD_LOGGER.info(module, method, " - Create SSLSocket", " - done sslSocket[host = " + this.sslSocket.getInetAddress() + ",targetport = " + this.sslSocket.getPort() + ",localaddress = " + this.sslSocket.getLocalAddress() + ",localport = " + this.sslSocket.getLocalPort() + "]");
            try {
                SSLUty.setEnabledCipherSuites(this.sslSocket);
            }
            catch (Exception e) {
                STD_LOGGER.info(module, method + e, " - " + e.getMessage(), ":" + this.confAry[i].getKmsName());
                SJkmsTRlog.outputTRlog(0, "");
                throw new KmsCommunicationException();
            }
            try {
                SSLUty.setEnabledProtocols(this.sslSocket);
            }
            catch (Exception e) {
                STD_LOGGER.info(module, method + e, " - " + e.getMessage(), ":" + this.confAry[i].getKmsName());
                SJkmsTRlog.outputTRlog(0, "");
                throw new KmsCommunicationException();
            }
            this.sslSocket.startHandshake();
            STD_LOGGER.info(module, method, " - Handshake", " - done session = " + this.sslSocket.getSession());
            STD_LOGGER.info(module, method, " Establishment of Communication", this.confAry[i].getKmsName());
        }
        catch (Exception e) {
            STD_LOGGER.info(module, method + e, " - " + e.getMessage(), ":" + this.confAry[i].getKmsName());
            throw new KmsCommunicationException();
        }
    }

    public void closeConnection() {
        String method = "closeConnection";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        try {
            if (this.netOutputStream != null) {
                this.netOutputStream.close();
            }
            if (this.netInputStream != null) {
                this.netInputStream.close();
            }
        }
        catch (IOException e) {
            STD_LOGGER.info(module, method, " - Communucate with KMS", " - error", e);
        }
        STD_LOGGER.info(module, method, " - ", " - end");
    }

    public TTLV communicateObject(TTLV t) throws ResponseException {
        String method = "communicateObject";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        byte[] resvData = null;
        try {
            this.netOutputStream = this.sslSocket.getOutputStream();
            STD_LOGGER.info(module, method, "\tCreate ObjectOutputStream", " done objectOutputStream = " + this.netOutputStream.toString());
            byte[] sendList = new byte[t.getBinaryDataSize()];
            t.makeSendData(sendList);
            STD_LOGGER.debug(module, method, " - ", " - " + t.printTTLV(0));
            STD_LOGGER.debug(module, method, " - ", " - Sent Request Message" + TTLV.printBinaryData(sendList));
            STD_LOGGER.info(module, method, " Sent Request Message \"XXXXXX\" ", sendList.length + " bytes");
            this.netOutputStream.write(sendList);
            this.netOutputStream.flush();
            ArrayList<ReadData> resultList = new ArrayList<ReadData>();
            int goal = Integer.MAX_VALUE;
            int readLength = 0;
            block2: while (readLength < goal) {
                this.netInputStream = this.sslSocket.getInputStream();
                ReadData rd = new ReadData();
                while ((rd.len = this.netInputStream.read(rd.data)) != -1) {
                    if (goal == Integer.MAX_VALUE) {
                        goal = TTLV.parseLength(rd.data, 0);
                    }
                    resultList.add(rd);
                    readLength += rd.len;
                    rd = new ReadData();
                    int ave = this.netInputStream.available();
                    if (ave != 0) continue;
                    continue block2;
                }
            }
            ByteBuffer ba = ByteBuffer.allocate(readLength);
            for (int i = 0; i < resultList.size(); ++i) {
                ReadData rd = (ReadData)resultList.get(i);
                if (rd.len == rd.data.length) {
                    ba.put(rd.data);
                    continue;
                }
                if (rd.len <= 0) continue;
                ba.put(rd.data, 0, rd.len);
            }
            resvData = ba.array();
        }
        catch (IOException e) {
            STD_LOGGER.info(module, method, " - Communucate with KMS", " - error" + e);
        }
        TTLV resultTTLV = TTLVFactory.makeTTLVByBinary(resvData);
        STD_LOGGER.debug(module, method, " - ", " - Received Responce Message" + TTLV.printBinaryData(resvData));
        if (resultTTLV != null) {
            STD_LOGGER.debug(module, method, " - ", " - " + resultTTLV.printTTLV(0));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return resultTTLV;
    }

    public class ReadData {
        public static final int READ_SIZE = 512;
        public byte[] data = new byte[512];
        public int len = 0;
    }
}

