/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.ApplicationSpecificInfo;
import sanproject.sn2.kms.kmip.client.info.common.ExtensionInformation;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterQuery
extends Converter {
    private static final String module = "ConverterQuery";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        ArrayList<Integer> queryTarget = ii.getQueryTargetList();
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = new TTLVStructure(15);
        tReq.addValue(tBI);
        tBI.addValue(new TTLVEnumeration(92, 24));
        TTLVStructure tRP = new TTLVStructure(121);
        tBI.addValue(tRP);
        for (int i = 0; i < queryTarget.size(); ++i) {
            tRP.addValue(new TTLVEnumeration(116, (int)queryTarget.get(i)));
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        OutputInfo oi = new OutputInfo();
        this.checkValue(resvTTLV, (byte)15, (byte)1, 1);
        TTLVStructure tRP = this.checkBatchItem((TTLVStructure)resvTTLV.getValueList((byte)15).get(0), oi);
        if (tRP != null) {
            ArrayList<Integer> queryTarget = ki.getInputInfo().getQueryTargetList();
            if (queryTarget == null) {
                throw new ResponseException();
            }
            block7: for (int i = 0; i < queryTarget.size(); ++i) {
                switch (queryTarget.get(i)) {
                    case 1: {
                        HashMap<Integer, Integer> hOpe = new HashMap<Integer, Integer>();
                        ArrayList<TTLV> al = tRP.getValueList((byte)92);
                        for (int j = 0; j < al.size(); ++j) {
                            if (al.get(j).getType() != 5) {
                                STD_LOGGER.info(module, method, " - check Type of Operation", " - invalid");
                                throw new ResponseException();
                            }
                            TTLVEnumeration tOp = (TTLVEnumeration)al.get(j);
                            Integer op = tOp.getValue();
                            hOpe.put(op, op);
                        }
                        oi.setSupportedOperation(hOpe);
                        continue block7;
                    }
                    case 2: {
                        HashMap<Integer, Integer> hOj = new HashMap<Integer, Integer>();
                        ArrayList<TTLV> al = tRP.getValueList((byte)87);
                        for (int j = 0; j < al.size(); ++j) {
                            if (al.get(j).getType() != 5) {
                                STD_LOGGER.info(module, method, " - check Type of Object", " - invalid");
                                throw new ResponseException();
                            }
                            TTLVEnumeration tOj = (TTLVEnumeration)al.get(j);
                            Integer op = tOj.getValue();
                            hOj.put(op, op);
                        }
                        oi.setSupportedObject(hOj);
                        continue block7;
                    }
                    case 3: {
                        this.checkValue(tRP, (byte)-99, (byte)7, 1);
                        TTLVTextString tt = (TTLVTextString)tRP.getValueList((byte)-99).get(0);
                        oi.setVendorID(tt.getValue());
                        this.checkValue(tRP, (byte)-120, (byte)1, 1);
                        oi.setServerInfo((TTLVStructure)tRP.getValueList((byte)-120).get(0));
                        continue block7;
                    }
                    case 4: {
                        ArrayList<TTLV> al2 = tRP.getValueList((byte)3);
                        if (al2 == null) continue block7;
                        ArrayList<ApplicationSpecificInfo> appSpecInfoList = new ArrayList<ApplicationSpecificInfo>();
                        for (int k = 0; k < al2.size(); ++k) {
                            if (al2.get(k).getType() != 7) {
                                STD_LOGGER.info(module, method, " - check Type of NameSpace", " - invalid");
                                throw new ResponseException();
                            }
                            ApplicationSpecificInfo asi = new ApplicationSpecificInfo();
                            TTLVStructure tAN = (TTLVStructure)al2.get(k);
                            this.checkValue(tAN, (byte)3, (byte)7, 1);
                            TTLVTextString tANS = (TTLVTextString)tAN.getValueList((byte)3).get(0);
                            asi.setApplicationNamespace(tANS.getValue());
                            appSpecInfoList.add(asi);
                        }
                        oi.setApplicationSpecificInfoList(appSpecInfoList);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        ArrayList<TTLV> al3 = tRP.getValueList((byte)-92);
                        if (al3 == null) continue block7;
                        ArrayList<ExtensionInformation> exInfoList = new ArrayList<ExtensionInformation>();
                        for (int k = 0; k < al3.size(); ++k) {
                            if (al3.get(k).getType() != 1) {
                                STD_LOGGER.info(module, method, " - check Type of Extention Infomation", " - invalid");
                                throw new ResponseException();
                            }
                            TTLVStructure tEI = (TTLVStructure)al3.get(k);
                            ExtensionInformation ei = new ExtensionInformation();
                            this.checkValue(tEI, (byte)-91, (byte)7, 1);
                            TTLVTextString tEIN = (TTLVTextString)tEI.getValueList((byte)-91).get(0);
                            ei.setName(tEIN.getValue());
                            this.checkValue(tEI, (byte)-90, (byte)2, 1);
                            TTLVInteger tEITag = (TTLVInteger)tEI.getValueList((byte)-90).get(0);
                            ei.setTag(tEITag.getValue());
                            this.checkValue(tEI, (byte)-89, (byte)2, 1);
                            TTLVInteger tEIType = (TTLVInteger)tEI.getValueList((byte)-89).get(0);
                            ei.setType(tEIType.getValue());
                            exInfoList.add(ei);
                        }
                        oi.setExtensionInformation(exInfoList);
                        continue block7;
                    }
                    default: {
                        STD_LOGGER.info(module, method, " - check Type of Query Function", " - invalid");
                        throw new ResponseException();
                    }
                }
            }
        }
        oiList.add(oi);
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

