/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.ttlv;

import java.util.ArrayList;
import java.util.Hashtable;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class TTLVStructure
extends TTLV {
    private static final String module = "TTLVStructure";
    protected ArrayList<TTLV> value;
    protected Hashtable<Byte, ArrayList<TTLV>> valueHash;

    public TTLVStructure(byte tag) {
        super(tag);
    }

    public TTLVStructure(byte[] data, int pos) {
        super(data, pos);
    }

    @Override
    protected void init() {
        String method = "init";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 0;
        this.value = new ArrayList();
        this.valueHash = new Hashtable();
    }

    @Override
    public byte getType() {
        String method = "getType";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return 1;
    }

    @Override
    public void makeSendData(byte[] data, int pos) {
        String method = "makeSendData";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        int childPos = pos + 8;
        this.length = 0;
        for (int i = 0; i < this.value.size(); ++i) {
            TTLV t = this.value.get(i);
            t.makeSendData(data, childPos);
            int j = t.getBinaryDataSize();
            childPos += j;
            this.length += j;
        }
        this.makeTTL(data, pos);
    }

    @Override
    public int getBinaryDataSize() {
        String method = "getBinaryDataSize";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.length = 0;
        for (int i = 0; i < this.value.size(); ++i) {
            this.length += this.value.get(i).getBinaryDataSize();
        }
        return this.length + 8;
    }

    public void addValue(TTLV ttlv) {
        String method = "addValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.value.add(ttlv);
        Byte key = ttlv.getTag();
        if (this.valueHash.containsKey(key)) {
            this.valueHash.get(key).add(ttlv);
        } else {
            ArrayList<TTLV> al = new ArrayList<TTLV>();
            al.add(ttlv);
            this.valueHash.put(key, al);
        }
    }

    public void addValue(int index, TTLV ttlv) {
        String method = "addValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        this.value.add(index, ttlv);
        Byte key = ttlv.getTag();
        if (this.valueHash.containsKey(key)) {
            this.valueHash.get(key).add(ttlv);
        } else {
            ArrayList<TTLV> al = new ArrayList<TTLV>();
            al.add(ttlv);
            this.valueHash.put(key, al);
        }
    }

    public int getValueSize() {
        String method = "getValueSize";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return this.value.size();
    }

    public TTLV getValue(int index) {
        String method = "getValue";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        return this.value.get(index);
    }

    public int getValueSize(byte tag) {
        String method = "getValueSize";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        Byte key = tag;
        if (this.valueHash.containsKey(key)) {
            return this.valueHash.get(key).size();
        }
        return 0;
    }

    public ArrayList<TTLV> getValueList(byte tag) {
        String method = "getValueList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        Byte key = tag;
        if (this.valueHash.containsKey(key)) {
            return (ArrayList)this.valueHash.get(key).clone();
        }
        return null;
    }

    @Override
    public String printTTLV(int level) {
        int i;
        String msg = "";
        for (int i2 = 0; i2 < level; ++i2) {
            msg = msg + "\t";
        }
        byte[] data = new byte[this.getBinaryDataSize()];
        this.makeSendData(data, 0);
        for (i = 0; i < 8; ++i) {
            msg = msg + String.format(" %02X", data[i]);
        }
        msg = msg + "\n";
        for (i = 0; i < this.value.size(); ++i) {
            msg = msg + this.value.get(i).printTTLV(level + 1);
        }
        return msg;
    }
}

