/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.local;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import sanproject.serverux.dataimpl.MRCFgetPairInfEx;
import sanproject.serverux.dataimpl.MRCFgetPairLdev;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoLocalReplicationPairVolInfo
extends SJmoReplicationPairVolInfo
implements SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = -9190682277199814248L;
    private int iFcRelation = -1;
    private short sPairStatus = (short)-1;
    private Date snapShotDate = new Date();
    private short sMuNum = (short)-1;
    private short sCtgId = (short)-1;
    private int iSVolPoolId = -1;
    private short sCopyPace = (short)-1;
    private short sWriteHist = (short)-1;
    private short sHideMode = (short)-1;
    private short sSnapshotPoolStatus = (short)-1;
    private long lPVolUsedPool = -1L;
    private long lSVolUsedPool = -1L;
    private short sPairRate = (short)-1;
    private int iSnapshotInfo = -1;
    private int iSnapshotSetId = -1;
    private boolean siPFlg = false;
    private boolean siSFlg = false;
    private boolean qsPFlg = false;
    private boolean qsSFlg = false;
    private short sStatOpt = 0;
    private short sStatusOpt = (short)-1;
    private short sTierRebalanceTIPVolStatus = (short)-1;
    private short sTierShrinkTIPVolStatus = (short)-1;
    private boolean bCascade = false;
    private boolean bClone = false;
    private SJmoLdevIndex rootLdev = null;

    public SJmoLocalReplicationPairVolInfo(MRCFgetPairLdev pairPvol) {
        ArrayList<SJmoLdevIndex> ldIdxList;
        if (null != pairPvol) {
            ldIdxList = new ArrayList<SJmoLdevIndex>();
            this.setLdevIndex(pairPvol.getSLDKC(), pairPvol.getSCU(), pairPvol.getSLDEV());
            this.iFcRelation = pairPvol.getIFcRelation();
            for (int iPairCnt = 0; iPairCnt < pairPvol.getAlPairInf().size(); ++iPairCnt) {
                if (null != pairPvol.getAlPairInf().get(iPairCnt)) {
                    MRCFgetPairInfEx pairInf = (MRCFgetPairInfEx)pairPvol.getAlPairInf().get(iPairCnt);
                    if (pairInf.getKind() == 2) continue;
                    SJmoLdevIndex ldIdx = new SJmoLdevIndex();
                    ldIdx.setLdevIndex(pairInf.getSLDKC(), pairInf.getSCU(), pairInf.getSLDEV());
                    ldIdxList.add(ldIdx);
                    continue;
                }
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor(MRCFgetPairLdev)", "S-VOL Info null");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLocalReplicationPairVolInfo", "SJmoLocalReplicationPairVolInfo(MRCFgetPairLdev)");
        }
        Collections.sort(ldIdxList);
        super.setAlSVolIndex(ldIdxList);
        this.siPFlg = true;
    }

    public SJmoLocalReplicationPairVolInfo(MRCFgetPairInfEx pairSVol) {
        if (null == pairSVol) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLocalReplicationPairVolInfo", "SJmoLocalReplicationPairVolInfo(MRCFgetPairInfEx)");
        }
        this.setLdevIndex(pairSVol.getSLDKC(), pairSVol.getSCU(), pairSVol.getSLDEV());
        this.setSMuNum(pairSVol.getMuNum());
        this.setSPairStatus(pairSVol.getPairStatus());
        this.setSWriteHist(pairSVol.getWriteHist());
        this.setSCopyPace(pairSVol.getCopyPace());
        this.setSHideMode(pairSVol.getHideMode());
        this.setSCtgId(pairSVol.getSplitGrp());
        this.setStatOpt((short)(pairSVol.getSStatOpt() & 0xFFFE));
        this.setSStatusOpt((short)(pairSVol.getSStatOpt() & 1));
        this.siSFlg = true;
    }

    public SJmoLocalReplicationPairVolInfo(SanObject tiPairInf, SJmoTiPvolInfo rootLdevInfo, boolean pFlg, boolean sFlg) {
        if (tiPairInf == null) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoLocalReplicationPairVolInfo", "SJmoLocalReplicationPairVolInfo(TiPair)");
        }
        try {
            int[] iSVolId;
            int[] iPVolId;
            SJmoLdevIndex ldIdx = null;
            SanObject sanObjPVolInf = tiPairInf.getObj("PrimaryVolume");
            SanObject sanObjSVolInf = tiPairInf.getObj("SecondaryVolume");
            if (pFlg) {
                iPVolId = sanObjPVolInf.getObj("Ldev").getIntArray("Id");
                this.setLdevIndex((short)iPVolId[0], (short)iPVolId[1], (short)iPVolId[2]);
                if (rootLdevInfo != null) {
                    this.setLPVolUsedPool(rootLdevInfo.getPoolslt());
                }
                this.iSnapshotInfo = 1;
                ldIdx = new SJmoLdevIndex();
                iSVolId = sanObjSVolInf.getObj("Ldev").getIntArray("Id");
                ldIdx.setLdevIndex((short)iSVolId[0], (short)iSVolId[1], (short)iSVolId[2]);
                this.getAlSVolIndex().add(ldIdx);
                Collections.sort(this.getAlSVolIndex());
                this.qsPFlg = true;
            }
            if (sFlg) {
                iPVolId = sanObjPVolInf.getObj("Ldev").getIntArray("Id");
                ldIdx = new SJmoLdevIndex();
                ldIdx.setLdevIndex((short)iPVolId[0], (short)iPVolId[1], (short)iPVolId[2]);
                this.setPVolIndex(ldIdx);
                iSVolId = sanObjSVolInf.getObj("Ldev").getIntArray("Id");
                this.setLdevIndex((short)iSVolId[0], (short)iSVolId[1], (short)iSVolId[2]);
                this.setSWriteHist((short)sanObjSVolInf.getInt("WriteHistory"));
                this.rootLdev = new SJmoLdevIndex();
                int[] iRootId = tiPairInf.getObj("RootLdev").getIntArray("Id");
                this.rootLdev.setLdevIndex((short)iRootId[0], (short)iRootId[1], (short)iRootId[2]);
                this.setSMuNum((short)tiPairInf.getInt("MirrorUnit"));
                int[] isnapDate = tiPairInf.getIntArray("SnapshotDate");
                boolean bFlg = false;
                for (int i = 0; i < isnapDate.length; ++i) {
                    if (isnapDate[i] == 0) continue;
                    bFlg = true;
                    break;
                }
                if (bFlg) {
                    Calendar calSnap = Calendar.getInstance();
                    calSnap.setTimeZone(TimeZone.getTimeZone("GMT"));
                    calSnap.set(isnapDate[0], isnapDate[1] - 1, isnapDate[2], isnapDate[3], isnapDate[4], isnapDate[5]);
                    this.setSnapShotDate(calSnap.getTime());
                } else {
                    this.setSnapShotDate(null);
                }
                this.setSPairStatus((short)tiPairInf.getInt("Status"));
                this.sPairRate = (short)tiPairInf.getInt("SynchronousRate");
                if (tiPairInf.getMember("Ctg") != null) {
                    SanObject objCtg = tiPairInf.getObj("Ctg");
                    this.setSCtgId((short)objCtg.getInt("Id"));
                }
                if (tiPairInf.getMember("SnapshotGroup") != null) {
                    SanObject objSnapshotG = tiPairInf.getObj("SnapshotGroup");
                    this.setISnapshotSetId(objSnapshotG.getInt("Id"));
                }
                this.setBCascade(tiPairInf.getBoolean("Cascade"));
                this.setBClone(tiPairInf.getBoolean("Clone"));
                this.setSCopyPace((short)tiPairInf.getInt("CopyPace"));
                this.setISnapshotInfo(1);
                if (rootLdevInfo != null) {
                    this.setISVolPoolId(rootLdevInfo.getPoolid());
                }
                this.qsSFlg = true;
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.error("SJmoLocalReplicationPairVolInfo", "getMessageId", e.getMessage());
            throw SJmoUtility.getException(201, 23, 107002, SJmoLocalReplicationPairVolInfo.class.getSimpleName(), "Constructor(TIpair)");
        }
    }

    public SJmoLocalReplicationPairVolInfo(byte byDiffKind) {
        this.setIDataMode(byDiffKind);
    }

    public short getSPairStatus() {
        return this.sPairStatus;
    }

    public void setSPairStatus(short pairStatus) {
        this.sPairStatus = pairStatus;
    }

    public Date getSnapShotDate() {
        return this.snapShotDate;
    }

    public void setSnapShotDate(Date snapShotDate) {
        this.snapShotDate = snapShotDate;
    }

    public short getSMuNum() {
        return this.sMuNum;
    }

    public void setSMuNum(short muNum) {
        this.sMuNum = muNum;
    }

    public short getSCtgId() {
        return this.sCtgId;
    }

    public void setSCtgId(short ctgId) {
        this.sCtgId = ctgId;
    }

    public int getISVolPoolId() {
        return this.iSVolPoolId;
    }

    public void setISVolPoolId(int volPoolId) {
        this.iSVolPoolId = volPoolId;
    }

    public short getSCopyPace() {
        return this.sCopyPace;
    }

    public void setSCopyPace(short copyPace) {
        this.sCopyPace = copyPace;
    }

    public short getSWriteHist() {
        return this.sWriteHist;
    }

    public void setSWriteHist(short writeHist) {
        this.sWriteHist = writeHist;
    }

    public short getSHideMode() {
        return this.sHideMode;
    }

    public void setSHideMode(short hideMode) {
        this.sHideMode = hideMode;
    }

    public long getLPVolUsedPool() {
        return this.lPVolUsedPool;
    }

    public void setLPVolUsedPool(long volUsedPool) {
        this.lPVolUsedPool = volUsedPool;
    }

    @Deprecated
    public long getLSVolUsedPool() {
        return this.lSVolUsedPool;
    }

    @Deprecated
    public void setLSVolUsedPool(long volUsedPool) {
        this.lSVolUsedPool = volUsedPool;
    }

    public short getSPairRate() {
        return this.sPairRate;
    }

    public void setSPairRate(short pairRate) {
        this.sPairRate = pairRate;
    }

    public void setISnapshotInfo(int snapshotInfo) {
        this.iSnapshotInfo = snapshotInfo;
    }

    public int getISnapshotSetId() {
        return this.iSnapshotSetId;
    }

    public void setISnapshotSetId(int snapshotSetId) {
        this.iSnapshotSetId = snapshotSetId;
    }

    public short getStatOpt() {
        return this.sStatOpt;
    }

    public void setStatOpt(short statOpt) {
        this.sStatOpt = statOpt;
    }

    public short getSStatusOpt() {
        return this.sStatusOpt;
    }

    public void setSStatusOpt(short StatusOpt) {
        this.sStatusOpt = StatusOpt;
    }

    public boolean isFcStatus(int iChkMask) {
        return SJmoDataUtility.chkAllBitOn(iChkMask, this.iFcRelation);
    }

    @Deprecated
    public boolean isSnapshotPoolStatus(short sChkMask) {
        int iMask = 65535;
        int iChkMask = sChkMask & 0xFFFF;
        int iPoolStat = this.sSnapshotPoolStatus & 0xFFFF;
        return SJmoDataUtility.chkAllBitOn(iChkMask, iPoolStat);
    }

    public boolean isExSnapshotInfo(int iChkMask) {
        return SJmoDataUtility.chkAllBitOn(iChkMask, this.iSnapshotInfo);
    }

    public void setSiPVolData(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (null != pairInfo) {
            this.iFcRelation = pairInfo.iFcRelation;
            this.getAlSVolIndex().addAll(pairInfo.getAlSVolIndex());
            Collections.sort(this.getAlSVolIndex());
            this.siPFlg = true;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setSiPVolData", "pairInfo = null");
        }
    }

    public void setQsPVolData(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (null != pairInfo) {
            this.setLPVolUsedPool(pairInfo.getLPVolUsedPool());
            this.iSnapshotInfo = pairInfo.iSnapshotInfo;
            this.getAlSVolIndex().addAll(pairInfo.getAlSVolIndex());
            Collections.sort(this.getAlSVolIndex());
            this.qsPFlg = true;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setQsPVolData", "pairInfo = null");
        }
    }

    public void setPVolData(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (null != pairInfo) {
            if (pairInfo.siPFlg) {
                this.iFcRelation = pairInfo.iFcRelation;
            }
            if (pairInfo.qsPFlg) {
                this.setLPVolUsedPool(pairInfo.getLPVolUsedPool());
                this.iSnapshotInfo = pairInfo.iSnapshotInfo;
            }
            this.setAlSVolIndex(pairInfo.getAlSVolIndex());
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setPVolData", "pairInfo = null");
        }
    }

    public void setSVolData(SJmoLocalReplicationPairVolInfo pairInfo) {
        if (null != pairInfo) {
            if (pairInfo.siSFlg) {
                this.setSHideMode(pairInfo.getSHideMode());
                this.setStatOpt(pairInfo.getStatOpt());
                this.setSStatusOpt(pairInfo.getSStatusOpt());
            }
            if (pairInfo.qsSFlg) {
                this.setSnapShotDate(pairInfo.getSnapShotDate());
                this.setISVolPoolId(pairInfo.getISVolPoolId());
                this.sSnapshotPoolStatus = pairInfo.sSnapshotPoolStatus;
                this.setSPairRate(pairInfo.getSPairRate());
                this.iSnapshotInfo = pairInfo.iSnapshotInfo;
                this.setISnapshotSetId(pairInfo.getISnapshotSetId());
                this.setBClone(pairInfo.isBClone());
                this.setBCascade(pairInfo.isBCascade());
                this.setRootLdev(pairInfo.getRootLdev());
            }
            this.setSCopyPace(pairInfo.getSCopyPace());
            this.setSPairStatus(pairInfo.getSPairStatus());
            this.setSWriteHist(pairInfo.getSWriteHist());
            this.setSMuNum(pairInfo.getSMuNum());
            this.setSCtgId(pairInfo.getSCtgId());
            this.setPVolIndex(pairInfo.getPVolIndex());
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setSVolData", "pairInfo = null");
        }
    }

    public void allFlgOff() {
        this.siPFlg = false;
        this.siSFlg = false;
        this.qsPFlg = false;
        this.qsSFlg = false;
    }

    public short getSTierRebalanceTIPVolStatus() {
        return this.sTierRebalanceTIPVolStatus;
    }

    public void setSTierRebalanceTIPVolStatus(short tierRebalanceTIPVolStatus) {
        this.sTierRebalanceTIPVolStatus = tierRebalanceTIPVolStatus;
    }

    public short getSTierShrinkTIPVolStatus() {
        return this.sTierShrinkTIPVolStatus;
    }

    public void setSTierShrinkTIPVolStatus(short tierShrinkTIPVolStatus) {
        this.sTierShrinkTIPVolStatus = tierShrinkTIPVolStatus;
    }

    public boolean isBCascade() {
        return this.bCascade;
    }

    public void setBCascade(boolean cascade) {
        this.bCascade = cascade;
    }

    public boolean isBClone() {
        return this.bClone;
    }

    public void setBClone(boolean clone) {
        this.bClone = clone;
    }

    public SJmoLdevIndex getRootLdev() {
        return this.rootLdev;
    }

    public void setRootLdev(SJmoLdevIndex ldev) {
        this.rootLdev = ldev;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoLocalReplicationPairVolInfo retObj = (SJmoLocalReplicationPairVolInfo)super.clone();
        if (null != retObj.getSnapShotDate()) {
            retObj.setSnapShotDate((Date)retObj.getSnapShotDate().clone());
        }
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

