/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.local.manager;

import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.inf.SJmoDataMgr_IF;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetIndex;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.util.SJmoReplicationUtility;

public class SJmoSnapshotSetInfoMgr
extends SJmoModelData_Base
implements SJmoDataMgr_IF {
    private static final long serialVersionUID = -2024054719663308815L;
    private SJmoSnapshotSetInfo[] snapShotSetInfoList = new SJmoSnapshotSetInfo[2048];

    public SJmoSnapshotSetInfoMgr(SJmoSnapshotSetInfo[] snapshotSetInfoList) {
        if (null == snapshotSetInfoList) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.snapShotSetInfoList = snapshotSetInfoList;
    }

    public SJmoSnapshotSetInfo getSnapshotSetInfo(int iSnapshotSetId) {
        SJmoSnapshotSetInfo retSnapshotSetInfo = null;
        if (SJmoReplicationUtility.isValidSnapshotSetId(iSnapshotSetId)) {
            retSnapshotSetInfo = this.snapShotSetInfoList[iSnapshotSetId];
        }
        return retSnapshotSetInfo;
    }

    public SJmoSnapshotSetInfo getSnapshotSetInfo(SJmoSnapshotSetIndex snapshotSetIdx) {
        return this.getSnapshotSetInfo(snapshotSetIdx.getIndex());
    }

    public SJmoSnapshotSetInfo[] getSnapshotSetInfoList() {
        return this.snapshotSetInfoListCopy(this.snapShotSetInfoList);
    }

    public void setSnapshotSetInfoList(SJmoSnapshotSetInfo[] snapshotSetList) {
        this.snapShotSetInfoList = snapshotSetList;
    }

    public void setSnapshotSetInfo(SJmoSnapshotSetInfo snapshotSetInfo) {
        if (SJmoReplicationUtility.isValidSnapshotSetId(snapshotSetInfo.getIndex())) {
            this.snapShotSetInfoList[snapshotSetInfo.getIndex()] = snapshotSetInfo;
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "setSnapshotSetInfo", "SnapshotSet Index = " + snapshotSetInfo.getIndex());
        }
    }

    private SJmoSnapshotSetInfo[] getShallowSnapshotSetnfoList() {
        return this.snapShotSetInfoList;
    }

    private SJmoSnapshotSetInfo[] snapshotSetInfoListCopy(SJmoSnapshotSetInfo[] snapshotSetInfoList) {
        return this.snapshotSetInfoListClone(snapshotSetInfoList, false);
    }

    private SJmoSnapshotSetInfo[] snapshotSetInfoListDeepCopy(SJmoSnapshotSetInfo[] snapshotSetInfoList) {
        return this.snapshotSetInfoListClone(snapshotSetInfoList, true);
    }

    private SJmoSnapshotSetInfo[] snapshotSetInfoListClone(SJmoSnapshotSetInfo[] srcList, boolean bSnapshotSetnfoDeepCopy) {
        SJmoSnapshotSetInfo[] retList = null;
        if (null != srcList) {
            retList = new SJmoSnapshotSetInfo[srcList.length];
            for (int iSrcCnt = 0; iSrcCnt < srcList.length; ++iSrcCnt) {
                if (bSnapshotSetnfoDeepCopy) {
                    if (null == srcList[iSrcCnt]) continue;
                    try {
                        retList[iSrcCnt] = (SJmoSnapshotSetInfo)srcList[iSrcCnt].clone();
                    }
                    catch (Exception exp) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "snapshotSetInfoListClone", "clone failed iSrcCnt = " + iSrcCnt + exp.toString());
                    }
                    continue;
                }
                retList[iSrcCnt] = srcList[iSrcCnt];
            }
        } else {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "snapshotSetInfoListClone", "srcList is null.");
        }
        return retList;
    }

    @Override
    public Object getToOutSideObj() {
        Object retObj = null;
        try {
            retObj = super.clone();
        }
        catch (Exception e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "getToOutSideObj", "clone failed" + e.toString());
        }
        return retObj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoSnapshotSetInfoMgr retObj = (SJmoSnapshotSetInfoMgr)super.clone();
        retObj.setSnapshotSetInfoList(retObj.snapshotSetInfoListDeepCopy(retObj.getShallowSnapshotSetnfoList()));
        return retObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

