/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJmoHAPairVolInfo
extends SJmoReplicationPairVolInfo {
    private static final long serialVersionUID = 1854877182944538621L;
    private int iPairLDEV = -1;
    private int iAttribute = -1;
    private int iPairLDEVAttribute = -1;
    private String strPairSN = "";
    private int iPairSSID = -1;
    private int iPairControllerID = -1;
    private int iCopyProgress = -1;
    private SJmoLuIndex pairLU = null;
    private int iPairStatus = -1;
    private int iPathGroup = -1;
    private boolean bBelongSyncCTG = false;
    private int iSyncCTG = -1;
    private int iCopyPace = -1;
    private Date daPairCreateTime = null;
    private Date daPairRenewTime = null;
    private long lPairCopyTime = -1L;
    private boolean bQuorumDisabled = false;
    private int iQuorumID = -1;
    private int iSSWS = -1;
    private int iIOMode = -1;
    private int iHAErrInf = -1;
    private int iMuNo = -1;
    private int iInitialSetting = -1;
    private int iSuspended = -1;
    private boolean bQueue = false;
    private int[] iArrHAOption = null;
    private int iGroupStatus = -1;
    private int iBlockadeMode = -1;
    private String strIndexKey = "";

    public SJmoHAPairVolInfo() {
    }

    public SJmoHAPairVolInfo(RJiHAget1PairSummary rmiPairSummary) {
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        if (rmiPairSummary != null) {
            this.setSLdkc((short)(rmiPairSummary.getPairLDEV() >> 16 & 0xFF));
            this.setSCu((short)(rmiPairSummary.getPairLDEV() >> 8 & 0xFF));
            this.setSLdev((short)(rmiPairSummary.getPairLDEV() & 0xFF));
            this.setIPairLDEV(rmiPairSummary.getPairLDEV());
            this.setIAttribute(rmiPairSummary.getAttr());
            this.setIPairLDEVAttribute(rmiPairSummary.getPairLDEVAttr());
            this.setStrPairSN(rmiPairSummary.getPairSN());
            this.setIPairSSID(rmiPairSummary.getPairSSID());
            this.setIPairModel(rmiPairSummary.getPairModel());
            SJmoLuIndex luIndex = new SJmoLuIndex();
            luIndex.setSPort((short)rmiPairSummary.getPairLU().getPortNo());
            luIndex.setSHostGroup((short)rmiPairSummary.getPairLU().getGroupNo());
            luIndex.setILUN(rmiPairSummary.getPairLU().getLUN());
            this.setPairLU(luIndex);
            this.setIPairStatus(rmiPairSummary.getPairStatus());
            this.setIPathGroup(rmiPairSummary.getPathGrp());
            this.setBHasGroup(rmiPairSummary.hasGroup());
            this.setIGroup(rmiPairSummary.getGroup());
            this.setICorrespondRate(rmiPairSummary.getCorrespondRate());
            this.setICopyPace(rmiPairSummary.getCopyPace());
            if (rmiPairSummary.getCreatePairAt() != null) {
                Date daPairCreateTime = ((DateFormat)df).parse(rmiPairSummary.getCreatePairAt(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaPairCreateTime(daPairCreateTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "CreatePairAt is Null.");
            }
            if (rmiPairSummary.getStatusChangeAt() != null) {
                pos.setIndex(0);
                Date daPairRenewTime = ((DateFormat)df).parse(rmiPairSummary.getStatusChangeAt(), pos);
                if (pos.getErrorIndex() == -1) {
                    this.setDaPairRenewTime(daPairRenewTime);
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "StatusChangeAt is Null.");
            }
            String strPairCopyTime = rmiPairSummary.getCopyCompleteTime();
            if (strPairCopyTime != null) {
                String[] strAry = strPairCopyTime.split(":");
                if (strAry.length == 3 && strAry[0].length() != 0 && strAry[1].length() != 0 && strAry[2].length() != 0) {
                    try {
                        long lHour = Long.parseLong(strAry[0]);
                        long lMin = Long.parseLong(strAry[1]);
                        long lSec = Long.parseLong(strAry[2]);
                        long lPairCopyTime = lSec + lMin * 60L + lHour * 60L * 60L;
                        this.setLPairCopyTime(lPairCopyTime);
                    }
                    catch (NumberFormatException e) {
                        SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "CopyCompleteTime is invalid. (" + rmiPairSummary.getCopyCompleteTime() + ")");
                    }
                }
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "PairCopyTime is Null.");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setBQuorumDisabled(rmiPairSummary.isQuorumDisabled());
        this.setIQuorumID(rmiPairSummary.getQuorumID());
        this.setISSWS(rmiPairSummary.isSSWS());
        this.setIIOMode(rmiPairSummary.getIOMode());
        this.setIObstacle(rmiPairSummary.getObstacle());
        this.setIMuNo(rmiPairSummary.getMirror());
        this.setIInitialSetting(rmiPairSummary.getiInitialSetting());
        this.setISuspended(rmiPairSummary.getiSuspended());
        this.setBQueue(rmiPairSummary.isQueue());
        this.setOption(rmiPairSummary.getOption());
        this.setIGroupStatus(rmiPairSummary.getGroupStatus());
        this.setIBlockadeMode(rmiPairSummary.getBlockadeMode());
    }

    public int getIPairLDEV() {
        return this.iPairLDEV;
    }

    public int getIAttribute() {
        return this.iAttribute;
    }

    public int getIPairLDEVAttribute() {
        return this.iPairLDEVAttribute;
    }

    public String getStrPairSN() {
        return this.strPairSN;
    }

    public int getIPairSSID() {
        return this.iPairSSID;
    }

    public int getIPairModel() {
        return this.iPairControllerID;
    }

    public SJmoLuIndex getPairLU() {
        return this.pairLU;
    }

    public int getIPairStatus() {
        return this.iPairStatus;
    }

    public int getIPathGroup() {
        return this.iPathGroup;
    }

    public boolean hasGroup() {
        return this.bBelongSyncCTG;
    }

    public int getIGroup() {
        return this.iSyncCTG;
    }

    public int getICorrespondRate() {
        return this.iCopyProgress;
    }

    public int getICopyPace() {
        return this.iCopyPace;
    }

    public Date getDaPairCreateTime() {
        return this.daPairCreateTime;
    }

    public Date getDaPairRenewTime() {
        return this.daPairRenewTime;
    }

    public long getLPairCopyTime() {
        return this.lPairCopyTime;
    }

    public boolean isQuorumDisabled() {
        return this.bQuorumDisabled;
    }

    public int getIQuorumID() {
        return this.iQuorumID;
    }

    public int getISSWS() {
        return this.iSSWS;
    }

    public int getIIOMode() {
        return this.iIOMode;
    }

    public int getIObstacle() {
        return this.iHAErrInf;
    }

    public int getIMuNo() {
        return this.iMuNo;
    }

    public int getIInitialSetting() {
        return this.iInitialSetting;
    }

    public int getISuspended() {
        return this.iSuspended;
    }

    public boolean isQueue() {
        return this.bQueue;
    }

    public int[] getOption() {
        return this.iArrHAOption;
    }

    public int getIGroupStatus() {
        return this.iGroupStatus;
    }

    public int getIBlockadeMode() {
        return this.iBlockadeMode;
    }

    @Override
    public void setSLdkc(short ldkc) {
        super.setSLdkc(ldkc);
        this.strIndexKey = "";
    }

    @Override
    public void setSCu(short cu) {
        super.setSCu(cu);
        this.strIndexKey = "";
    }

    @Override
    public void setSLdev(short sLdev) {
        super.setSLdev(sLdev);
        this.strIndexKey = "";
    }

    @Override
    public void setAlPVolIndex(ArrayList<? extends SJmoLdevIndex> alPVolIndex) {
        super.setAlPVolIndex(alPVolIndex);
        this.strIndexKey = "";
    }

    public void setIPairLDEV(int pairLDEV) {
        this.iPairLDEV = pairLDEV;
    }

    public void setIAttribute(int attribute) {
        this.iAttribute = attribute;
    }

    public void setIPairLDEVAttribute(int pairLDEVAttribute) {
        this.iPairLDEVAttribute = pairLDEVAttribute;
    }

    public void setStrPairSN(String strPairSN) {
        this.strPairSN = strPairSN;
        this.strIndexKey = "";
    }

    public void setIPairSSID(int pairSSID) {
        this.iPairSSID = pairSSID;
    }

    public void setIPairModel(int iPairControllerID) {
        this.iPairControllerID = iPairControllerID;
        this.strIndexKey = "";
    }

    public void setPairLU(SJmoLuIndex pairLU) {
        this.pairLU = pairLU;
    }

    public void setIPairStatus(int pairStatus) {
        this.iPairStatus = pairStatus;
    }

    public void setIPathGroup(int pathGroup) {
        this.iPathGroup = pathGroup;
    }

    public void setBHasGroup(boolean belongSyncCTG) {
        this.bBelongSyncCTG = belongSyncCTG;
    }

    public void setIGroup(int syncCTG) {
        this.iSyncCTG = syncCTG;
    }

    public void setICorrespondRate(int copyProgress) {
        this.iCopyProgress = copyProgress;
    }

    public void setICopyPace(int copyPace) {
        this.iCopyPace = copyPace;
    }

    public void setDaPairCreateTime(Date daPairCreateTime) {
        this.daPairCreateTime = daPairCreateTime;
    }

    public void setDaPairRenewTime(Date daPairRenewTime) {
        this.daPairRenewTime = daPairRenewTime;
    }

    public void setLPairCopyTime(long pairCopyTime) {
        this.lPairCopyTime = pairCopyTime;
    }

    public void setBQuorumDisabled(boolean quorumDisabled) {
        this.bQuorumDisabled = quorumDisabled;
    }

    public void setIQuorumID(int quorumID) {
        this.iQuorumID = quorumID;
    }

    public void setISSWS(int ssws) {
        this.iSSWS = ssws;
    }

    public void setIIOMode(int IOMode) {
        this.iIOMode = IOMode;
    }

    public void setIObstacle(int haErrInf) {
        this.iHAErrInf = haErrInf;
    }

    public void setIMuNo(int muNo) {
        this.iMuNo = muNo;
    }

    public void setIInitialSetting(int initialSetting) {
        this.iInitialSetting = initialSetting;
    }

    public void setISuspended(int suspended) {
        this.iSuspended = suspended;
    }

    public void setBQueue(boolean queue) {
        this.bQueue = queue;
    }

    public void setOption(int[] option) {
        this.iArrHAOption = option;
    }

    public void setIGroupStatus(int groupStatus) {
        this.iGroupStatus = groupStatus;
    }

    public void setIBlockadeMode(int blockadeMode) {
        this.iBlockadeMode = blockadeMode;
    }

    @Override
    public int compareTo(Object keyObj) {
        int iRet = 0;
        if (keyObj instanceof SJmoHAPairVolInfo) {
            try {
                int iKeySN;
                int iSn;
                SJmoHAPairVolInfo target = (SJmoHAPairVolInfo)keyObj;
                iRet = this.iPairControllerID - target.iPairControllerID;
                if (iRet == 0 && (iRet = (iSn = Integer.parseInt(this.strPairSN)) - (iKeySN = Integer.parseInt(target.strPairSN))) == 0 && (iRet = this.getIndex() - target.getIndex()) == 0 && this.getPVolIndex() != null) {
                    iRet = this.getPVolIndex().getIndex() - target.getPVolIndex().getIndex();
                }
            }
            catch (NumberFormatException e) {
                iRet = this.toString().compareTo(keyObj.toString());
            }
        } else {
            iRet = this.toString().compareTo(keyObj.toString());
        }
        return iRet;
    }

    @Override
    public String toString() {
        if (this.strIndexKey.length() != 0) {
            return this.strIndexKey;
        }
        try {
            String strPairModel = SJmoUtility.itoh(this.iPairControllerID, 2);
            String strSn = SJmoUtility.itoh(Integer.parseInt(this.strPairSN), 8);
            String strPVolIndex = "";
            if (this.getPVolIndex() != null) {
                strPVolIndex = this.getPVolIndex().getIndexKey();
            }
            this.strIndexKey = strPairModel + strSn + this.getIndexKey() + strPVolIndex;
        }
        catch (NumberFormatException e) {
            SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "toString", "strPairSN is invalid. (" + this.strPairSN + ")");
        }
        return this.strIndexKey;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoHAPairVolInfo cloneObj = (SJmoHAPairVolInfo)super.clone();
        cloneObj.setPairLU((SJmoLuIndex)cloneObj.getPairLU().clone());
        return cloneObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

