/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.replication.remote;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import sanproject.serverux.dataimpl.HURget1ECTGrp;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.replication.SJmoExConsistencyGroupIndex;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorEXCTGJnlGrp;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.util.SJmoRemoteReplicationUtility;

public class SJmoUniversalReplicatorEXCTG
extends SJmoExConsistencyGroupIndex {
    private static final long serialVersionUID = -1359103423668350117L;
    private int iUsed = -1;
    private int iAttribute = -1;
    private int iConsistency = -1;
    private String strCt = "";
    private Date daCt = null;
    private int iCtMillis = -1;
    private int iLdkc = -1;
    private ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> alJnlGrp = null;

    public SJmoUniversalReplicatorEXCTG() {
    }

    public SJmoUniversalReplicatorEXCTG(HURget1ECTGrp rmiExCTGrp) {
        if (rmiExCTGrp == null) {
            throw SJmoUtility.getException(201, 23, 107000, this.getClass().getSimpleName(), "Constructor");
        }
        this.setIExCtgId(rmiExCTGrp.ectg);
        this.setUsed(rmiExCTGrp.used);
        this.setAttribute(rmiExCTGrp.attr);
        this.setConsistency(rmiExCTGrp.consistency);
        this.setStrCt(rmiExCTGrp.ct);
        if (rmiExCTGrp.ct != null && this.getConsistency() != 0) {
            ParsePosition pos = new ParsePosition(0);
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            Date daCt = ((DateFormat)df).parse(rmiExCTGrp.ct, pos);
            if (pos.getErrorIndex() == -1) {
                this.setCt(daCt);
                this.setCtMillis(Integer.parseInt(rmiExCTGrp.ct.substring(20, 26)));
            } else {
                SJmoUtility.putLogDetail(this.getClass().getSimpleName(), "Constructor", "SJmoUniversalReplicatorEXCTG[" + this.getIExCtgId() + "] is invalid. C/T:(" + rmiExCTGrp.ct + ")");
            }
        }
        this.setLdkc(rmiExCTGrp.ldkcNo);
        this.setJnlGrpList(SJmoRemoteReplicationUtility.makeExCTGJnlGrp(rmiExCTGrp.jnlgInfo));
    }

    public int getUsed() {
        return this.iUsed;
    }

    public int getAttribute() {
        return this.iAttribute;
    }

    public int getConsistency() {
        return this.iConsistency;
    }

    public String getStrCt() {
        return this.strCt;
    }

    public Date getCt() {
        return this.daCt;
    }

    public int getCtMillis() {
        return this.iCtMillis;
    }

    public int getLdkc() {
        return this.iLdkc;
    }

    public ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> getJnlGrpList() {
        return this.alJnlGrp;
    }

    public void setUsed(int used) {
        this.iUsed = used;
    }

    public void setAttribute(int attribute) {
        this.iAttribute = attribute;
    }

    public void setConsistency(int consistency) {
        this.iConsistency = consistency;
    }

    public void setStrCt(String ct) {
        this.strCt = ct;
    }

    public void setCt(Date dact) {
        this.daCt = dact;
    }

    public void setCtMillis(int ctMillis) {
        this.iCtMillis = ctMillis;
    }

    public void setLdkc(int ldkc) {
        this.iLdkc = ldkc;
    }

    public void setJnlGrpList(ArrayList<SJmoUniversalReplicatorEXCTGJnlGrp> alJnlGrp) {
        this.alJnlGrp = alJnlGrp;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SJmoUniversalReplicatorEXCTG cloneObj = (SJmoUniversalReplicatorEXCTG)super.clone();
        if (this.getCt() != null) {
            cloneObj.setCt((Date)cloneObj.getCt().clone());
        }
        cloneObj.setJnlGrpList(SJmoDataUtility.alDeepCopy(cloneObj.getJnlGrpList()));
        return cloneObj;
    }

    @Override
    public Object clone(byte byDataMode) throws CloneNotSupportedException {
        SJmoModelData_Base retObj = (SJmoModelData_Base)this.clone();
        retObj.setIDataMode(byDataMode);
        return retObj;
    }
}

