/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.util;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLoginIscsiNameInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortLoginIscsiNameInfo;
import sanproject.sn2.model.data.util.SJmoPortUtility;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJmoIscsiUtility
implements SJmoKeyValueDefine_IF {
    private static final Comparator<SanObject> ISCSI_NAME_COMP = new Comparator<SanObject>(){

        @Override
        public int compare(SanObject o1, SanObject o2) {
            String iscsiName1 = "";
            String iscsiName2 = "";
            try {
                iscsiName1 = o1.getString("Name");
                iscsiName2 = o2.getString("Name");
            }
            catch (SanDataException sde) {
                throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiUtility-iSCSINameComparator", "compare");
            }
            return iscsiName1.compareTo(iscsiName2);
        }
    };
    private static final Comparator<SanObject> CHAP_USER_COMP = new Comparator<SanObject>(){

        @Override
        public int compare(SanObject o1, SanObject o2) {
            String chapUserName1 = "";
            String chapUserName2 = "";
            try {
                chapUserName1 = o1.getString("UserId");
                chapUserName2 = o2.getString("UserId");
            }
            catch (SanDataException sde) {
                throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiUtility-CHAPUserComparator", "compare");
            }
            return chapUserName1.compareTo(chapUserName2);
        }
    };

    public static Map<String, List<? extends SJmoPortIndex>> makeIscsiTargetInfo(SanResponse iscsiTgHostInfo, SanResponse iscsiTgChapInfo) {
        if (null == iscsiTgHostInfo || null == iscsiTgChapInfo) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiUtility", "makeIscsiTargetInfo");
        }
        HashMap<String, List<? extends SJmoPortIndex>> retMap = new HashMap<String, List<? extends SJmoPortIndex>>();
        ArrayList<SJmoPortIscsiTargetInfo> portIscsiTargetInfoList = new ArrayList<SJmoPortIscsiTargetInfo>();
        ArrayList<SJmoPortIscsiNameInfo> portIscsiNameInfoList = new ArrayList<SJmoPortIscsiNameInfo>();
        ArrayList<SJmoPortLoginIscsiNameInfo> portLoginIscsiNameInfoList = new ArrayList<SJmoPortLoginIscsiNameInfo>();
        ArrayList<SJmoPortChapUserInfo> portChapUserInfoList = new ArrayList<SJmoPortChapUserInfo>();
        try {
            SanList rmiPorts = iscsiTgHostInfo.getList("iScsiPorts");
            for (SanObject rmiPort : rmiPorts) {
                short portId = (short)rmiPort.getInt("Id");
                SanList rmiIscsiTgList = rmiPort.getList("iScsiTargets");
                ArrayList<SJmoIscsiTargetInfo> iscsiTgList = SJmoIscsiUtility.makePortIscsiTargetInfo(portId, rmiIscsiTgList);
                SJmoPortIscsiTargetInfo ptIscsiTgInfo = new SJmoPortIscsiTargetInfo();
                ptIscsiTgInfo.setSPort(portId);
                ptIscsiTgInfo.setAlPortIscsiTarget(iscsiTgList);
                portIscsiTargetInfoList.add(ptIscsiTgInfo);
                SanList rmiIscsiNameList = rmiPort.getList("RemoteiScsiNames");
                HashMap<String, String> iscsiNameInfoMap = new HashMap<String, String>();
                ArrayList<SJmoIscsiName> iscsiNameList = SJmoIscsiUtility.makePortIscsiNameInfo(portId, rmiIscsiNameList, iscsiTgList, iscsiNameInfoMap);
                SJmoPortIscsiNameInfo ptIscsiNameInfo = new SJmoPortIscsiNameInfo();
                ptIscsiNameInfo.setSPort(portId);
                ptIscsiNameInfo.setAlPortIscsiName(iscsiNameList);
                portIscsiNameInfoList.add(ptIscsiNameInfo);
                SanList rmiLoginIscsiNameList = rmiPort.getList("LoginiScsiNamesHistory");
                ArrayList<SJmoIscsiName> loginIscsiNameList = SJmoIscsiUtility.makePortLoginIscsiNameInfo(portId, rmiLoginIscsiNameList, iscsiNameInfoMap);
                SJmoPortLoginIscsiNameInfo ptLoginIscsiNameInfo = new SJmoPortLoginIscsiNameInfo();
                ptLoginIscsiNameInfo.setSPort(portId);
                ptLoginIscsiNameInfo.setAlPortIscsiName(loginIscsiNameList);
                portLoginIscsiNameInfoList.add(ptLoginIscsiNameInfo);
            }
            SanList rmiChapPorts = iscsiTgChapInfo.getList("iScsiPorts");
            for (SanObject rmiPort : rmiChapPorts) {
                short portId = (short)rmiPort.getInt("Id");
                SJmoPortIscsiTargetInfo ptIscsiTgInfo = (SJmoPortIscsiTargetInfo)SJmoPortUtility.getPortInfoByPortId(portIscsiTargetInfoList, portId);
                if (null != ptIscsiTgInfo) {
                    ArrayList<SJmoIscsiTargetInfo> iscsiTgList = ptIscsiTgInfo.getAlPortIscsiTarget();
                    SanList rmiIscsiTgChapList = rmiPort.getList("iScsiTargets");
                    SJmoIscsiUtility.setIscsiTgChapAuthInfo(portId, iscsiTgList, rmiIscsiTgChapList);
                    SanList rmiChapUserList = rmiPort.getList("RemoteiScsiUsers");
                    ArrayList<SJmoChapUserInfo> chapUserList = SJmoIscsiUtility.makePortChapUserInfo(portId, rmiChapUserList, iscsiTgList);
                    SJmoPortChapUserInfo ptChapUserInfo = new SJmoPortChapUserInfo();
                    ptChapUserInfo.setSPort(portId);
                    ptChapUserInfo.setAlPortChapUser(chapUserList);
                    portChapUserInfoList.add(ptChapUserInfo);
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoPortIscsiTargetInfo", "makeIscsiTargetInfo", "The SJmoIscsiTargetInfo information does not exist.");
            }
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiUtility", "makeIscsiTargetInfo");
        }
        retMap.put(SJmoGetPortIscsiTargetInfo.class.getName(), portIscsiTargetInfoList);
        retMap.put(SJmoGetPortIscsiNameInfo.class.getName(), portIscsiNameInfoList);
        retMap.put(SJmoGetPortLoginIscsiNameInfo.class.getName(), portLoginIscsiNameInfoList);
        retMap.put(SJmoGetPortChapUserInfo.class.getName(), portChapUserInfoList);
        return retMap;
    }

    private static ArrayList<SJmoIscsiTargetInfo> makePortIscsiTargetInfo(short portId, SanList rmiIscsiTgList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTgList = new ArrayList<SJmoIscsiTargetInfo>(rmiIscsiTgList.size());
        for (SanObject rmiIscsiTg : rmiIscsiTgList) {
            SJmoIscsiTargetInfo iscsiTgInfo = new SJmoIscsiTargetInfo();
            iscsiTgInfo.setIscsiTgBaseInfo(portId, rmiIscsiTg);
            iscsiTgList.add(iscsiTgInfo);
        }
        return iscsiTgList;
    }

    private static ArrayList<SJmoIscsiName> makePortIscsiNameInfo(short portId, SanList rmiIscsiNameList, ArrayList<SJmoIscsiTargetInfo> assignTargetList, HashMap<String, String> iscsiNameInfoMap) throws SanDataException {
        ArrayList<SanObject> sortedNameList = new ArrayList<SanObject>();
        for (SanObject sanObj : rmiIscsiNameList) {
            sortedNameList.add(sanObj);
        }
        Collections.sort(sortedNameList, ISCSI_NAME_COMP);
        ArrayList<SJmoIscsiName> iscsiNameList = new ArrayList<SJmoIscsiName>(sortedNameList.size());
        for (SanObject rmiIscsiName : sortedNameList) {
            SJmoIscsiName iscsiName = new SJmoIscsiName(portId, rmiIscsiName);
            iscsiNameInfoMap.put(iscsiName.getStrIscsiName(), iscsiName.getStrIscsiNickName());
            SanList rmiAssignTgList = rmiIscsiName.getList("iScsiTargets");
            for (SanObject rmiIscsiTg : rmiAssignTgList) {
                SJmoIscsiTargetIndex iscsiTgIndex = new SJmoIscsiTargetIndex();
                iscsiTgIndex.setSPort(portId);
                iscsiTgIndex.setSIscsiTarget((short)rmiIscsiTg.getInt("Id"));
                iscsiName.getAlIscsiTargets().add(iscsiTgIndex);
                SJmoIscsiTargetInfo iscsiTgInfo = SJmoIscsiUtility.getIscsiTgInfoByIscsiTgIndex(assignTargetList, iscsiTgIndex);
                if (iscsiTgInfo != null) {
                    iscsiTgInfo.getAlIscsiName().add(iscsiName);
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoIscsiUtility", "makePortIscsiNameInfo", "The SJmoIscsiTargetInfo information does not exist.");
            }
            iscsiNameList.add(iscsiName);
        }
        return iscsiNameList;
    }

    private static ArrayList<SJmoIscsiName> makePortLoginIscsiNameInfo(short portId, SanList rmiIscsiNameList, HashMap<String, String> iscsiNameInfoMap) throws SanDataException {
        ArrayList<SanObject> sortedNameList = new ArrayList<SanObject>();
        for (SanObject sanObj : rmiIscsiNameList) {
            sortedNameList.add(sanObj);
        }
        Collections.sort(sortedNameList, ISCSI_NAME_COMP);
        ArrayList<SJmoIscsiName> iscsiNameList = new ArrayList<SJmoIscsiName>(sortedNameList.size());
        for (SanObject rmiIscsiName : sortedNameList) {
            SJmoIscsiName iscsiName = new SJmoIscsiName(portId, rmiIscsiName, false);
            String hostName = iscsiNameInfoMap.get(iscsiName.getStrIscsiName());
            if (hostName != null) {
                iscsiName.setStrIscsiNickName(hostName);
            }
            SanList rmiAssignTgList = rmiIscsiName.getList("iScsiTargets");
            for (SanObject rmiIscsiTg : rmiAssignTgList) {
                SJmoIscsiTargetIndex iscsiTgIndex = new SJmoIscsiTargetIndex();
                iscsiTgIndex.setSPort(portId);
                iscsiTgIndex.setSIscsiTarget((short)rmiIscsiTg.getInt("Id"));
                iscsiName.getAlIscsiTargets().add(iscsiTgIndex);
            }
            iscsiNameList.add(iscsiName);
        }
        return iscsiNameList;
    }

    private static void setIscsiTgChapAuthInfo(short portId, ArrayList<SJmoIscsiTargetInfo> iscsiTgList, SanList rmiIscsiTgChapList) throws SanDataException {
        for (SanObject rmiIscsiTg : rmiIscsiTgChapList) {
            SJmoIscsiTargetIndex iscsiTgIndex = new SJmoIscsiTargetIndex();
            iscsiTgIndex.setSPort(portId);
            iscsiTgIndex.setSIscsiTarget((short)rmiIscsiTg.getInt("Id"));
            SJmoIscsiTargetInfo iscsiTgInfo = SJmoIscsiUtility.getIscsiTgInfoByIscsiTgIndex(iscsiTgList, iscsiTgIndex);
            if (iscsiTgInfo != null) {
                iscsiTgInfo.setIscsiTgChapInfo(rmiIscsiTg);
                continue;
            }
            SJmoUtility.putLogDetail("SJmoIscsiUtility", "setIscsiTgChapAuthInfo", "The SJmoIscsiTargetInfo information does not exist.");
        }
    }

    private static ArrayList<SJmoChapUserInfo> makePortChapUserInfo(short portId, SanList rmiChapUserList, ArrayList<SJmoIscsiTargetInfo> assignTargetList) throws SanDataException {
        ArrayList<SanObject> sortedNameList = new ArrayList<SanObject>();
        for (SanObject sanObj : rmiChapUserList) {
            sortedNameList.add(sanObj);
        }
        Collections.sort(sortedNameList, CHAP_USER_COMP);
        ArrayList<SJmoChapUserInfo> chapUserList = new ArrayList<SJmoChapUserInfo>(sortedNameList.size());
        for (SanObject rmiChapUser : sortedNameList) {
            SJmoChapUserInfo chapUser = new SJmoChapUserInfo(portId, rmiChapUser);
            SanList rmiAssignTgList = rmiChapUser.getList("iScsiTargets");
            for (SanObject rmiIscsiTg : rmiAssignTgList) {
                SJmoIscsiTargetIndex iscsiTgIndex = new SJmoIscsiTargetIndex();
                iscsiTgIndex.setSPort(portId);
                iscsiTgIndex.setSIscsiTarget((short)rmiIscsiTg.getInt("Id"));
                chapUser.getAlIscsiTargets().add(iscsiTgIndex);
                SJmoIscsiTargetInfo iscsiTgInfo = SJmoIscsiUtility.getIscsiTgInfoByIscsiTgIndex(assignTargetList, iscsiTgIndex);
                if (iscsiTgInfo != null) {
                    iscsiTgInfo.getAlUserInfo().add(chapUser);
                    continue;
                }
                SJmoUtility.putLogDetail("SJmoIscsiUtility", "makePortChapUserInfo", "The SJmoIscsiTargetInfo information does not exist.");
            }
            chapUserList.add(chapUser);
        }
        return chapUserList;
    }

    public static List<SJmoPortIscsiTargetPathInfo> makeIscsiTargetPathinfo(SanResponse rmiIscsiPathList) {
        ArrayList<SJmoPortIscsiTargetPathInfo> portIscsiPathList = new ArrayList<SJmoPortIscsiTargetPathInfo>();
        Map<Integer, ArrayList<SJmoIscsiTargetPathInfo>> iscsiPathMap = SJmoIscsiUtility.getIscsiTargetPathMap(rmiIscsiPathList);
        for (int key : iscsiPathMap.keySet()) {
            ArrayList<SJmoIscsiTargetPathInfo> iscsiPathList = iscsiPathMap.get(key);
            Collections.sort(iscsiPathList);
            SJmoPortIscsiTargetPathInfo portIscsiTargetPathInfo = new SJmoPortIscsiTargetPathInfo();
            portIscsiTargetPathInfo.setSPort((short)key);
            portIscsiTargetPathInfo.setAlPortIscsiTargetPath(iscsiPathList);
            portIscsiPathList.add(portIscsiTargetPathInfo);
        }
        Collections.sort(portIscsiPathList);
        return portIscsiPathList;
    }

    private static Map<Integer, ArrayList<SJmoIscsiTargetPathInfo>> getIscsiTargetPathMap(SanResponse rmiIscsiPathList) {
        HashMap<Integer, ArrayList<SJmoIscsiTargetPathInfo>> iscsiPathMap = new HashMap<Integer, ArrayList<SJmoIscsiTargetPathInfo>>();
        try {
            SanList iscsiPathList = rmiIscsiPathList.getList("RemoteiScsiTargets");
            for (SanObject rmiIscsiPathInfo : iscsiPathList) {
                SJmoIscsiTargetPathInfo iscsiPathInfo = new SJmoIscsiTargetPathInfo();
                iscsiPathInfo.setIFunction(rmiIscsiPathInfo.getInt("Function"));
                if (iscsiPathInfo.getIFunction() == 1) {
                    iscsiPathInfo.setSRemoteExtPort((short)rmiIscsiPathInfo.getInt("PortLocationNumber"));
                }
                int ipType = rmiIscsiPathInfo.getInt("IpType");
                iscsiPathInfo.setIIpType(ipType);
                if (ipType == 0) {
                    iscsiPathInfo.setIIpv4Address(rmiIscsiPathInfo.getIntArray("Ipv4Address"));
                } else if (ipType == 1) {
                    iscsiPathInfo.setIIpv6Address(rmiIscsiPathInfo.getIntArray("Ipv6Address"));
                }
                iscsiPathInfo.setITcpPortNumber(rmiIscsiPathInfo.getInt("TcpPortNumber"));
                iscsiPathInfo.setStrTargetName(rmiIscsiPathInfo.getString("Name"));
                if (iscsiPathInfo.getIFunction() != 1) {
                    SanObject chapUserInfo = rmiIscsiPathInfo.getObj("iScsiUser");
                    iscsiPathInfo.setIAuthentSwitch(chapUserInfo.getInt("AuthSwitch"));
                    iscsiPathInfo.setIAuthentMode(chapUserInfo.getInt("AuthMode"));
                    iscsiPathInfo.setStrTargetUserName(chapUserInfo.getString("UserId"));
                    iscsiPathInfo.setStrTargetSecret(chapUserInfo.getString("Secret"));
                }
                SanList portList = rmiIscsiPathInfo.getList("iScsiPorts");
                for (SanObject portInfo : portList) {
                    int iPort = portInfo.getInt("Id");
                    iscsiPathInfo.setSPort((short)iPort);
                    SanList vPortList = portInfo.getList("iScsiVirtualPorts");
                    if (0 == vPortList.size()) {
                        SJmoIscsiTargetPathInfo iscsiPathCloneInfo = (SJmoIscsiTargetPathInfo)iscsiPathInfo.clone();
                        iscsiPathCloneInfo.setITargetPathIndex(rmiIscsiPathInfo.getInt("Index"));
                        SJmoIscsiUtility.putMapIscsiTargetPathList(iscsiPathMap, iPort, iscsiPathCloneInfo);
                    }
                    for (SanObject vPortInfo : vPortList) {
                        SJmoIscsiTargetPathInfo iscsiPathCloneInfo = (SJmoIscsiTargetPathInfo)iscsiPathInfo.clone();
                        int iVPort = vPortInfo.getInt("Id");
                        iscsiPathCloneInfo.setIVirtualPortID(iVPort);
                        int index = rmiIscsiPathInfo.getInt("Index");
                        iscsiPathCloneInfo.setITargetPathIndex(index += iVPort << 16);
                        SJmoIscsiUtility.putMapIscsiTargetPathList(iscsiPathMap, iPort, iscsiPathCloneInfo);
                    }
                }
            }
        }
        catch (SanDataException sdEx) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoIscsiUtility", "makeIscsiTargetPathinfo");
        }
        catch (CloneNotSupportedException cnsEx) {
            SJmoUtility.putLog("[SJmoIscsiUtility][checkErrorInfo].");
        }
        return iscsiPathMap;
    }

    private static void putMapIscsiTargetPathList(Map<Integer, ArrayList<SJmoIscsiTargetPathInfo>> iscsiPathMap, int iPort, SJmoIscsiTargetPathInfo addPathInfo) {
        ArrayList<SJmoIscsiTargetPathInfo> mapIscsiTargetPathList = iscsiPathMap.get(iPort);
        if (null == mapIscsiTargetPathList) {
            mapIscsiTargetPathList = new ArrayList();
            iscsiPathMap.put(iPort, mapIscsiTargetPathList);
        }
        mapIscsiTargetPathList.add(addPathInfo);
    }

    public static SJmoIscsiTargetInfo getIscsiTgInfoByIscsiTgIndex(List<SJmoIscsiTargetInfo> iscsiTgList, SJmoIscsiTargetIndex iscsiTgIndex) {
        SJmoIscsiTargetInfo retInfo = null;
        int searchIndex = Collections.binarySearch(iscsiTgList, (Object)iscsiTgIndex);
        if (searchIndex >= 0) {
            retInfo = iscsiTgList.get(searchIndex);
        }
        return retInfo;
    }

    public static void checkErrorInfo(SanResponse response, String strClass, String strMethod) {
        block5: {
            try {
                SanObject errInfo = response.getObj("ErrorInfo");
                if (errInfo != null) {
                    int[] msgIdList = errInfo.getIntArray("MessageId");
                    if (msgIdList != null && msgIdList.length == 2) {
                        int funcModCode = msgIdList[0];
                        int errorCode = msgIdList[1];
                        if (errorCode != 0) {
                            throw SJmoUtility.getException(funcModCode / 100, funcModCode % 100, errorCode, strClass, strMethod);
                        }
                        break block5;
                    }
                    SJmoUtility.putLog("[SJmoIscsiUtility][checkErrorInfo]Error information array is invalid.");
                    throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
                }
                SJmoUtility.putLog("[SJmoIscsiUtility][checkErrorInfo]Error information is null.");
                throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
            }
            catch (SanDataException sde) {
                SJmoUtility.putLog("[SJmoIscsiUtility][checkErrorInfo]SanDataException occurred. [code:" + sde.getCode() + "]" + sde.getMessage());
                throw SJmoUtility.getException(201, 23, 107000, strClass, strMethod);
            }
        }
    }
}

