/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.modelver;

import sanproject.serverux.dataimpl.DKCSystemOptionEx;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.modelver.SJmoVersionMgr;

public class SJmoVerPoller
extends Thread {
    private long m_lPollTime = 0L;
    private boolean m_bPoll = true;
    private String m_strLog;
    private boolean m_bRestart = false;

    public SJmoVerPoller(boolean bRestart) {
        if (this.m_lPollTime <= 0L) {
            this.m_lPollTime = 60000L;
        }
        this.m_bRestart = bRestart;
    }

    public void startScadule() {
        this.m_bPoll = true;
    }

    public void canselScadule() {
        this.m_bPoll = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lExeTime = 0L;
        long lStartTime = 0L;
        long lEndTime = 0L;
        long lSleepTime = 0L;
        int iMsRet = 0;
        this.m_strLog = "SJmoVerPoller Thread Start";
        this.putLog(this.m_strLog);
        if (this.m_bRestart) {
            try {
                SJmoVerPoller.sleep(60000L);
            }
            catch (InterruptedException interExp) {
                SJmoUtility.putLogDetail("SJmoVerPoller", "run", "Thread Interrupt.");
            }
        }
        try {
            while (this.m_bPoll && this.m_bPoll) {
                lStartTime = System.nanoTime();
                int iModelStatus = SJmoModelMgr.getModelMgr().getStatus().getPhase();
                SJmoVersionMgr verMgr = SJmoVersionMgr.getInstance();
                verMgr.refSystemOption(true);
                DKCSystemOptionEx sysOpt = verMgr.getSystemOption();
                try {
                    SJdsSupplierMgr supMgr = SJdsSupplierMgr.getSupplierMgr();
                    if (SJmoVersionMgr.isDataPolling(sysOpt, iModelStatus) && (iMsRet = verMgr.poller()) != 0) {
                        this.m_strLog = "polling refresh failed(" + iMsRet + ")";
                        this.putLog(this.m_strLog);
                    }
                }
                catch (SJmoException moExp) {
                    this.m_strLog = "Lock Check Failed";
                    this.putLog(this.m_strLog);
                }
                lEndTime = System.nanoTime();
                lExeTime = lEndTime - lStartTime;
                if (!this.m_bPoll) {
                    break;
                }
                lSleepTime = this.m_lPollTime - (lExeTime /= 1000000L);
                if (lSleepTime < 0L) {
                    lSleepTime = 0L;
                }
                if (lSleepTime >= this.m_lPollTime) {
                    lSleepTime = this.m_lPollTime;
                }
                Thread.sleep(lSleepTime);
            }
        }
        catch (InterruptedException ie) {
            this.m_strLog = "Thread sleep failed(" + ie.toString() + ")";
            this.putLog(this.m_strLog);
        }
        catch (Exception e) {
            this.m_strLog = "Thread sleep failed(" + e.toString() + ")";
            this.putLog(this.m_strLog);
        }
        finally {
            this.m_strLog = "SJmoVerPoller Thread End";
            this.putLog(this.m_strLog);
        }
    }

    private void putLog(String strLog) {
        SJmoUtility.putLogDetail("Ver_Polling", "run", strLog);
    }
}

