/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv.wrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtPdevInfoCSVWrapper
extends SJdtCSVWrapperBase {
    private static final String csvName = "PdevInfo";

    @Override
    public String getCsvName() {
        return csvName;
    }

    public List<String> getDkaValueSet(List<String> eccGroupList) {
        String[] getTargetColumnArray = this.getSearchTargetColumnArray();
        return this.getMatchedAllRecordColumnValueSet(eccGroupList, "ECC Group", getTargetColumnArray);
    }

    public Map<String, String> getEccGroupWithoutSpareDriveValueSet() {
        Map<String, String> map = this.getAllRecordColumnValueSetMap("ECC Group");
        map.remove("Spare Drive");
        map.remove("Free Drive");
        return map;
    }

    public List<String> getEccGroupValueSet(String searchStr) {
        LinkedHashMap map = new LinkedHashMap();
        String[] searchTargetColumnArray = this.getSearchTargetColumnArray();
        for (String[] record : this.csvDataList) {
            for (String searchTargetColumn : searchTargetColumnArray) {
                String eccGroup;
                String value = this.getValue(record, searchTargetColumn);
                if (!searchStr.equals(value) || !StringUtils.isNotEmpty((String)(eccGroup = this.getValue(record, "ECC Group"))) || "Spare Drive".equals(eccGroup) || "Free Drive".equals(eccGroup)) continue;
                map.put(eccGroup, null);
            }
        }
        return new ArrayList<String>(map.keySet());
    }

    private String[] getSearchTargetColumnArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            String[] searchTargetColumnArray = new String[]{"DKB1", "DKB2"};
            return searchTargetColumnArray;
        }
        String[] searchTargetColumnArray = new String[]{"DKA1", "DKA2"};
        return searchTargetColumnArray;
    }
}

