/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtELunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMfDMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public class SJdtArraygroupReportGenerator
extends SJdtTableReportGenerator {
    public static final String REPORT_NAME = "Arraygroup";
    public static final boolean IS_GRAPHIC_REPORT = false;
    public static final boolean USE_TABLE_SORT = true;
    public static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"pg", "module", "dka", "raidLevel", "resourceGroupName", "resourceGroupId", "emulationType", "numberOfLdevsTotal", "numberOfLdevsUnallocated", "totalLdevCapacity", "unallocatedLdevCapacity", "driveTypeCode", "driveTypeRpm", "driveCapacity", "raidConcatenation0", "raidConcatenation1", "raidConcatenation2", "encryption"};
    private static final int COLUMN_LENGTH = SJdtArraygroupReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Arraygroup";
    private static final String EXPLANATION_KEY = "Common.explanation.Arraygroup";
    private static final String TABLE_HEADER_BASE_KEY = "Arraygroup.table.header";
    public static final String REPORT_FRAMESET_HTML_FILE_NAME = "Arraygroup.html";
    public static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Arraygroup.html";
    public static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Arraygroup.html";
    public static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Arraygroup.html";
    public static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Arraygroup.html";
    public static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Arraygroup.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtELunInfoCSVWrapper eLunInfo = (SJdtELunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ELunInfo.csv");
        SJdtMfDMInfoCSVWrapper mfDMInfo = (SJdtMfDMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MfDMInfo.csv");
        Map<String, String> eccGroupMap = pdevInfo.getEccGroupWithoutSpareDriveValueSet();
        eccGroupMap.putAll(eLunInfo.getAllRecordColumnValueSetMap("ECC Group"));
        eccGroupMap.putAll(mfDMInfo.getAllRecordColumnValueSetMap("Migration Volume Group"));
        ArrayList<String> eccGroupList = new ArrayList<String>(eccGroupMap.keySet());
        Map<String, String[]> eLunInfoEccGroupMap = eLunInfo.getMatchedAllRecordMap("ECC Group");
        Map<String, List<String[]>> ldevInfoEccGroupMap = ldevInfo.getMatchedSameAllRecordMap("ECC Group");
        for (String eccGroup : eccGroupList) {
            String[] oneRecord = new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"pg")).intValue()] = eccGroup;
            if (this.isInternalGroup(eccGroup)) {
                String encryption;
                String dka;
                String[] pdevInfoRecord = pdevInfo.getMatchedOneRecord(eccGroup, "ECC Group");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"module")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Module#");
                ArrayList<String> dkaList = new ArrayList();
                List<String> allMachedEccGroupList = pdevInfo.getMatchedAllRecordColumnValue(eccGroup, "ECC Group", "ECC Group");
                dkaList = pdevInfo.getDkaValueSet(allMachedEccGroupList);
                Collections.sort(dkaList);
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"dka")).intValue()] = dka = SJdtRPTDTUtils.getAddSeparatorStr(dkaList, ";");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "RAID Level");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Resource Group Name (ECC Group)");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Resource Group ID (ECC Group)");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Emulation Type");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Type-Code");
                String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                String rpm = pdevInfo.getValue(pdevInfoRecord, "RPM");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = this.getDriveTypeRpm(deviceType, rpm);
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation0")).intValue()] = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#0"));
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation1")).intValue()] = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#1"));
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation2")).intValue()] = this.changeHyphenDisplayStr(pdevInfo.getValue(pdevInfoRecord, "RAID Concatenation#2"));
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"encryption")).intValue()] = encryption = pdevInfo.getValue(pdevInfoRecord, "Encryption");
            } else {
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"module")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"dka")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = "-";
                if (eccGroup.indexOf("M") == 0) {
                    String resourceGroupId;
                    String resourceGroupName;
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = resourceGroupName = mfDMInfo.getKeyRecordColumnValue(eccGroup, "Resource Group Name (ECC Group)");
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = resourceGroupId = mfDMInfo.getKeyRecordColumnValue(eccGroup, "Resource Group ID (ECC Group)");
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = "-";
                } else {
                    String driveTypeCode;
                    String[] eLunInfoRecord = eLunInfoEccGroupMap.get(eccGroup);
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = eLunInfo.getValue(eLunInfoRecord, "Resource Group Name (ECC Group)");
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = eLunInfo.getValue(eLunInfoRecord, "Resource Group ID (ECC Group)");
                    ArrayList<String> driveTypeCodeList = new ArrayList<String>();
                    driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Vendor"));
                    driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Product Name"));
                    driveTypeCodeList.add(eLunInfo.getValue(eLunInfoRecord, "Serial Number#"));
                    oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = driveTypeCode = SJdtRPTDTUtils.getAddSeparatorStr(driveTypeCodeList, ":");
                }
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveTypeRpm")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation0")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation1")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"raidConcatenation2")).intValue()] = "-";
                oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"encryption")).intValue()] = "-";
            }
            List<String[]> ldevInfoRecordList = ldevInfoEccGroupMap.get(eccGroup);
            oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"numberOfLdevsTotal")).intValue()] = String.valueOf(ldevInfoRecordList.size());
            oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = ldevInfo.getSumSize(ldevInfoRecordList, "Volume Size(MB)");
            List<String[]> ldevInfoUnallocatedRecordList = ldevInfo.getUnallocatedRecordList(ldevInfoRecordList);
            oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"numberOfLdevsUnallocated")).intValue()] = String.valueOf(ldevInfoUnallocatedRecordList.size());
            oneRecord[((Integer)SJdtArraygroupReportGenerator.headerMap.get((Object)"unallocatedLdevCapacity")).intValue()] = ldevInfo.getSumSize(ldevInfoUnallocatedRecordList, "Volume Size(MB)");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

