/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChapUserInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiTargetInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;

public class SJdtChapuserReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "ChapUser";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"portlocation", "userName", "iscsiTargetAlias", "iscsiTargetName"};
    private static final int COLUMN_LENGTH = SJdtChapuserReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.ChapUser";
    private static final String EXPLANATION_KEY = "Common.explanation.ChapUser";
    private static final String TABLE_HEADER_BASE_KEY = "ChapUser.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "ChapUser.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_ChapUser.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_ChapUser.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_ChapUser.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_ChapUser.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_ChapUser.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtChapUserInfoCSVWrapper chapUserInfo = (SJdtChapUserInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChapUserInfo.csv");
        SJdtIscsiTargetInfoCSVWrapper iscsiTargetInfo = (SJdtIscsiTargetInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiTargetInfo.csv");
        List<String[]> csvDataList = chapUserInfo.getCsvDataList();
        for (String[] chapUserInfoRecord : csvDataList) {
            String port;
            String[] oneRecord = new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtChapuserReportGenerator.headerMap.get((Object)"portlocation")).intValue()] = port = chapUserInfo.getValue(chapUserInfoRecord, "Port");
            String userName = chapUserInfo.getValue(chapUserInfoRecord, "User Name");
            if (!StringUtils.isNotEmpty((String)userName)) continue;
            oneRecord[((Integer)SJdtChapuserReportGenerator.headerMap.get((Object)"userName")).intValue()] = userName;
            String iscsiTargetId = chapUserInfo.getValue(chapUserInfoRecord, "iSCSI Target ID");
            String[] iscsiTargetInfoRecord = iscsiTargetInfo.getIscsiTargetRecord(port, iscsiTargetId);
            oneRecord[((Integer)SJdtChapuserReportGenerator.headerMap.get((Object)"iscsiTargetAlias")).intValue()] = iscsiTargetInfo.getValue(iscsiTargetInfoRecord, "iSCSI Target Alias");
            oneRecord[((Integer)SJdtChapuserReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = iscsiTargetInfo.getValue(iscsiTargetInfoRecord, "iSCSI Target Name");
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

