/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.help;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJsvlHelpLoadServlet
extends HttpServlet
implements Servlet {
    static final long serialVersionUID = 1L;
    static HashMap<String, byte[]> map = new HashMap();
    static boolean proprityLoaded = false;
    static HashSet<String> mapOem = new HashSet();
    static HashSet<String> mapLanguage = new HashSet();
    static final String SN_HELP_PATH_DEFAULT = "san\\htdocs\\san\\help\\std\\";
    static final String SN_HELP_BASIC_PATH = "/sanproject/htdocs/san/help/std/";
    String[][] ARCHIVE_FILEPATH_LIST = new String[][]{{"hi/en", "HI\\en\\HI_en.zip"}, {"hi/ja", "HI\\ja\\HI_ja.zip"}, {"hi_jp/en", "HI_JP\\en\\HI_JP_en.zip"}, {"hi_jp/ja", "HI_JP\\ja\\HI_JP_ja.zip"}, {"hp/en", "HP\\en\\HP_en.zip"}, {"hp/ja", "HP\\en\\HP_en.zip"}, {"hp_jp/en", "HP_JP\\en\\HP_JP_en.zip"}, {"hp_jp/ja", "HP_JP\\ja\\HP_JP_ja.zip"}};
    String[] SUMMONSLIST = new String[]{"/hdvm", "/sn2"};
    String[][] MIMETYPELIST = new String[][]{{"html", "text/html"}, {"htm", "text/html"}, {"xml", "text/xml"}, {"js", "text/javascript"}, {"gif", "image/gif"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"txt", "text/plain"}, {"css", "text/css"}, {"png", "image/png"}};
    String[] FILEPATH_CHECKLIST = new String[]{"hi/en/hdvm/", "hi/en/sn2/", "hi/ja/hdvm/", "hi/ja/sn2/", "hi_jp/en/hdvm/", "hi_jp/en/sn2/", "hi_jp/ja/hdvm/", "hi_jp/ja/sn2/", "hp/en/hdvm/", "hp/en/sn2/", "hp/ja/hdvm/", "hp/ja/sn2/", "hp_jp/en/hdvm/", "hp_jp/en/sn2/", "hp_jp/ja/hdvm/", "hp_jp/ja/sn2/"};
    static final String[] proprityFileTypeList = new String[]{"xml", "js"};
    private final String LOG_FUNCTION = "OnlineHelp";
    private final String LOG_TITLE = ((Object)((Object)this)).getClass().getSimpleName();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ZipArchiveInputStream os = null;
        try {
            ZipArchiveEntry entry;
            this.putlog("doPost", "start");
            String uri = request.getRequestURI();
            uri = uri.replace("/helpload/", "");
            uri = uri.toLowerCase();
            if (uri.length() == 0 || uri.substring(uri.length() - 1).equals("/")) {
                uri = uri + "index.htm";
            }
            this.manageCache(this.getOemType(uri));
            if (map.containsKey(uri)) {
                byte[] result = map.get(uri);
                if (result != null) {
                    this.configureMimeType(response, uri);
                    response.getOutputStream().write(result);
                } else {
                    this.putlog("doPost", "Cache Nothing " + uri);
                    response.sendError(404);
                }
                return;
            }
            if (proprityLoaded && this.isPriority(uri)) {
                this.putlog("doPost", "Cache Nothing (ProprityTarget) " + uri);
                response.sendError(404);
                return;
            }
            String accessPath = SJcEnvUty.getSnBasePath() + SN_HELP_PATH_DEFAULT + this.getArchiveFileName_OEM(uri);
            os = new ZipArchiveInputStream((InputStream)new FileInputStream(accessPath));
            if (os == null) {
                this.putlog("doPost", "FileStream create failed " + accessPath);
                response.sendError(404);
                return;
            }
            boolean successflag = false;
            while ((entry = os.getNextZipEntry()) != null) {
                String name = entry.getName();
                name = SN_HELP_BASIC_PATH + this.getOemType(uri) + "/" + name;
                name = name.toLowerCase();
                byte[] outbyte = null;
                if (name.equals(uri)) {
                    this.configureMimeType(response, uri);
                    outbyte = this.loadByte(os);
                    response.getOutputStream().write(outbyte);
                    successflag = true;
                    if (proprityLoaded) break;
                }
                if (proprityLoaded || !this.isPriority(name)) continue;
                if (outbyte == null) {
                    outbyte = this.loadByte(os);
                }
                map.put(name, outbyte);
            }
            if (!proprityLoaded) {
                proprityLoaded = true;
            }
            if (!successflag) {
                this.putlog("doPost", "Not Found URI " + uri);
                response.sendError(404);
            }
            this.putlog("doPost", "end");
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            response.sendError(500);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void manageCache(String oemtype) {
        String oem = this.getOem(oemtype);
        String lang = this.getLanguage(oemtype);
        if (mapOem.isEmpty()) {
            mapOem.add(oem);
            mapLanguage.add(lang);
            this.putlog("manageCache", "check : new entry " + oemtype);
            return;
        }
        if (mapOem.contains(oem)) {
            if (!mapLanguage.contains(lang)) {
                mapLanguage.add(lang);
                proprityLoaded = false;
                this.putlog("manageCache", "check : lang a>>b " + oemtype);
            }
        } else {
            map.clear();
            mapOem.clear();
            mapLanguage.clear();
            mapOem.add(oem);
            mapLanguage.add(lang);
            proprityLoaded = false;
            this.putlog("manageCache", "check : change oem (map clear) " + oemtype);
        }
    }

    String getArchiveFileName_OEM(String uri) {
        String key = this.getOemType(uri.toLowerCase());
        for (String[] path : this.ARCHIVE_FILEPATH_LIST) {
            if (!path[0].equals(key)) continue;
            return path[1];
        }
        return "";
    }

    String getOemType(String uri) {
        int begin_index;
        String key = uri;
        int end_index = begin_index = SN_HELP_BASIC_PATH.length();
        for (String summon : this.SUMMONSLIST) {
            int res_index = key.indexOf(summon);
            if (begin_index >= res_index) continue;
            end_index = res_index;
            break;
        }
        key = key.substring(begin_index, end_index);
        return key;
    }

    String getOem(String oemtype) {
        String oem = "";
        String[] key = oemtype.split("/");
        if (key.length > 0) {
            oem = key[0];
        }
        return oem;
    }

    String getLanguage(String oemtype) {
        String language = "";
        String[] key = oemtype.split("/");
        if (key.length > 1) {
            language = key[1];
        }
        return language;
    }

    private void configureMimeType(HttpServletResponse response, String path) {
        String[] strs = path.split("/");
        String fileName = strs[strs.length - 1];
        String[] fileEle = fileName.split("\\.");
        String type = fileEle[fileEle.length - 1];
        type = type.toLowerCase();
        for (String[] mimeKind : this.MIMETYPELIST) {
            if (!mimeKind[0].equals(type)) continue;
            String result = mimeKind[1];
            response.setContentType(result);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadByte(ZipArchiveInputStream os) {
        byte[] result = null;
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)os, (OutputStream)out);
            result = out.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    private boolean isPriority(String filePath) {
        boolean result = false;
        String[] strs = filePath.split("/");
        if (strs.length > 0) {
            String[] fileEle;
            String fileName = strs[strs.length - 1];
            for (String str : this.FILEPATH_CHECKLIST) {
                String checkPath = SN_HELP_BASIC_PATH + str + fileName;
                if (!checkPath.equals(filePath)) continue;
                result = true;
                break;
            }
            if (!result && (fileEle = fileName.split("\\.")).length > 1) {
                String fileType = fileEle[fileEle.length - 1];
                for (String str : proprityFileTypeList) {
                    if (!str.equals(fileType)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public String getMemoryInfo() {
        DecimalFormat f1 = new DecimalFormat("#,###KB");
        DecimalFormat f2 = new DecimalFormat("##.#");
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        long used = total - free;
        double ratio = (double)(used * 100L) / (double)total;
        String info = "Total         =" + f1.format(total) + ", " + "Used          =" + f1.format(used) + " (" + f2.format(ratio) + "%), " + "Usability Max =" + f1.format(max);
        return info;
    }

    private void putlog(String subTitle, String log) {
        SJcLogUty.getLogger().info("OnlineHelp", this.LOG_TITLE, subTitle, log);
    }
}

