/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.webapi;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.authentication.def.SJbaseHcsConMapKey;
import sanproject.sn2.base.authentication.def.SJbaseHcsConst;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSAuthUtility;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSHttpsManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcTRLogUty;
import sanproject.sn2.generated.svp.APIInfo;
import sanproject.sn2.generated.svp.EchoCommand;
import sanproject.sn2.generated.svp.HCSInfo;
import sanproject.sn2.generated.svp.ObjectFactory;
import sanproject.sn2.generated.svp.RAIDSVPServerMessage;
import sanproject.sn2.generated.svp.Request;
import sanproject.sn2.generated.svp.Response;
import sanproject.sn2.generated.svp.ResultList;
import sanproject.sn2.servlet.webapi.SJsvlHCSBaseServlet;
import sanproject.sn2.servlet.webapi.SJsvlHCSServletUty;
import sanproject.sn2.servlet.webapi.def.SJsvlErrorCode;
import sanproject.sn2.servlet.webapi.def.SJsvlHcsCommandStatus;
import sanproject.sn2.servlet.webapi.exception.SJsvlWebApiException;

public class SJsvlHCSInfo
extends SJsvlHCSBaseServlet {
    private static final long serialVersionUID = 0L;
    private static final String API_VERSION_REGIST = "1.0";
    private static final String API_VERSION_DELETE = "1.0";
    private static final String COMMAND_NAME_REGIST = "PutHCSInfo";
    private static final String COMMAND_NAME_DELETE = "DeleteHCSInfo";
    private static final int READ_TIMEOUT_MIN = 1;
    private static final int READ_TIMEOUT_MAX = 600000;

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPut";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPut", "Start.");
        try {
            request.getSession();
            response.setContentType("text/xml");
            this.regist(request, response);
        }
        catch (SJsvlWebApiException wapiex) {
            SJsvlHCSServletUty.setErrorResponseBody(response, "1.0", COMMAND_NAME_REGIST, wapiex);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doPut", "End.");
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doDelete";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doDelete", "Start.");
        try {
            request.getSession();
            response.setContentType("text/xml");
            this.delete(request, response);
        }
        catch (SJsvlWebApiException wapiex) {
            response.sendError(wapiex.getRspCd());
            return;
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "doDelete", "End.");
    }

    private void regist(HttpServletRequest request, HttpServletResponse response) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "regist";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "regist", "Start.");
        try {
            String sessionId = SJsvlHCSServletUty.getSessionId(request);
            this.sessionCheck(sessionId);
            RAIDSVPServerMessage requestBody = SJsvlHCSServletUty.getRequestBody(request);
            this.messageBodyCheck(requestBody);
            String hcsIp = requestBody.getRequest().getIP();
            BigInteger hcsPort = requestBody.getRequest().getPort();
            String hcsPort_string = hcsPort.toString();
            BigInteger hcsReadTimeout = requestBody.getRequest().getReadTimeout();
            String hcsReadTimeout_string = this.getReadTimeout(requestBody);
            String urlStr = SJbaseHCSAuthUtility.getHcsUrl(hcsIp, hcsPort_string);
            this.testConnection(urlStr, hcsIp, hcsPort_string, "TestUser", "TestUser", hcsReadTimeout_string);
            Map<String, Object> hcsInfo = this.createHcsInfoMap(hcsIp, hcsPort_string, hcsReadTimeout_string);
            this.registHcsInfo(hcsInfo);
            SJsvlHCSServletUty.setResponseBody(response, this.createResponseMessage(hcsIp, hcsPort, hcsReadTimeout, SJsvlHcsCommandStatus.COMPLETED));
        }
        catch (SJsvlWebApiException wapiex) {
            throw wapiex;
        }
        catch (Exception ex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "regist", SJsvlErrorCode.UNKNOWN_ERROR.name(), ex);
            throw new SJsvlWebApiException(SJsvlErrorCode.UNKNOWN_ERROR);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "regist", "End.");
    }

    private void delete(HttpServletRequest request, HttpServletResponse response) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "delete";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "delete", "Start.");
        try {
            String sessionId = SJsvlHCSServletUty.getSessionId(request);
            this.sessionCheck(sessionId);
            this.deleteHcsInfo();
            SJsvlHCSServletUty.setResponseBody(response, this.createResponseMessage());
        }
        catch (SJsvlWebApiException wapiex) {
            throw wapiex;
        }
        catch (Exception ex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "delete", SJsvlErrorCode.UNKNOWN_ERROR.name(), ex);
            throw new SJsvlWebApiException(SJsvlErrorCode.UNKNOWN_ERROR);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "delete", "End.");
    }

    private void messageBodyCheck(RAIDSVPServerMessage requestBody) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "messageBodyCheck";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "messageBodyCheck", "Start.");
        if (null == requestBody) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "messageBodyCheck", SJsvlErrorCode.MSG_BODY_RAIDSVPSERVERMESSAGE_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.MSG_BODY_RAIDSVPSERVERMESSAGE_NOTFOUND);
        }
        APIInfo apiInfo = requestBody.getAPIInfo();
        if (null == apiInfo) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "messageBodyCheck", SJsvlErrorCode.MSG_BODY_APIINFO_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.MSG_BODY_APIINFO_NOTFOUND);
        }
        Request request = requestBody.getRequest();
        if (null == request) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "messageBodyCheck", SJsvlErrorCode.MSG_BODY_REQUEST_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.MSG_BODY_REQUEST_NOTFOUND);
        }
        if (null == request.getIP() || "".equals(request.getIP())) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "messageBodyCheck", SJsvlErrorCode.MSG_BODY_IP_NOTFOUND.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.MSG_BODY_IP_NOTFOUND);
        }
        BigInteger port = request.getPort();
        if (null == port || !this.rightPortRange(port)) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "messageBodyCheck", SJsvlErrorCode.MSG_BODY_PORT_ILLEGAL.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.MSG_BODY_PORT_ILLEGAL);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "messageBodyCheck", "End.");
    }

    private String getReadTimeout(RAIDSVPServerMessage requestBody) {
        String LOG_SUBTITLE = "getReadTimeout";
        Request request = requestBody.getRequest();
        BigInteger readTimeout = request.getReadTimeout();
        String retReadTimeout = !this.rightReadTimeoutRange(readTimeout) ? "" : readTimeout.toString();
        return retReadTimeout;
    }

    private void sessionCheck(String sessionId) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "sessionCheck";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "sessionCheck", "Start.");
        SJsvlHCSServletUty.checkSessionIdFormat(sessionId);
        SJsvlHCSServletUty.checkAuthority(sessionId, 17);
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "sessionCheck", "End.");
    }

    private Map<String, Object> createHcsInfoMap(String hcsIp, String hcsPort, String hcsReadTimeout) {
        String LOG_SUBTITLE = "createHcsInfoMap";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createHcsInfoMap", "Start.");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SJbaseHcsConMapKey.IP.getKey(), hcsIp);
        map.put(SJbaseHcsConMapKey.PORT.getKey(), hcsPort);
        if (hcsReadTimeout.length() > 0) {
            map.put(SJbaseHcsConMapKey.READ_TIMEOUT.getKey(), hcsReadTimeout);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createHcsInfoMap", "End.");
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testConnection(String hcsUrl, String ip, String port, String user, String password, String readTimeout) throws SJsvlWebApiException {
        block10: {
            String LOG_SUBTITLE = "testConnection";
            STD_LOGGER.info("WebApi", this.LOG_TITLE, "testConnection", "Start. - user:" + user);
            HttpURLConnection urlconn = null;
            try {
                String requestContents = SJbaseHCSAuthUtility.createRequestContents(user);
                SJbaseHCSHttpsManager httpsMgr = new SJbaseHCSHttpsManager();
                httpsMgr.init();
                try {
                    urlconn = SJbaseHCSAuthUtility.connect(hcsUrl, requestContents, user, password, readTimeout);
                }
                catch (Exception ex) {
                    String hcsIp = ip;
                    String hcsPort = port;
                    String suminfo = String.format("Warning : Failed to connection. IP address=%s Port=%s.", hcsIp, hcsPort);
                    SJcTRLogUty.error("External Authenticator", "TREXAU000008", suminfo);
                    throw ex;
                }
                SJbaseHCSAuthUtility.send(urlconn, requestContents);
                int resCode = SJbaseHCSAuthUtility.getResponseCode(urlconn);
                SJbaseHCSAuthUtility.disconnect(urlconn);
                if (resCode != 401 && resCode != 200) {
                    STD_LOGGER.error("WebApi", this.LOG_TITLE, "testConnection", SJsvlErrorCode.TEST_COMMUNICATION_ERROR.name() + " user:" + user + " resCode:" + resCode);
                    throw new SJsvlWebApiException(SJsvlErrorCode.TEST_COMMUNICATION_ERROR, SJsvlHcsCommandStatus.CONNECTION_ERROR, null);
                }
                STD_LOGGER.info("WebApi", this.LOG_TITLE, "testConnection", "Succeed to test connect. user:" + user + " HTTP:" + resCode);
                if (null == urlconn) break block10;
            }
            catch (SJsvlWebApiException wapiex) {
                try {
                    throw wapiex;
                    catch (SocketTimeoutException sockTex) {
                        STD_LOGGER.error("WebApi", this.LOG_TITLE, "testConnection", SJsvlErrorCode.TEST_CONNECT_TIMEOUT.name() + " user:" + user);
                        throw new SJsvlWebApiException(SJsvlErrorCode.TEST_CONNECT_TIMEOUT, SJsvlHcsCommandStatus.CONNECTION_ERROR, sockTex);
                    }
                    catch (Exception ex) {
                        STD_LOGGER.error("WebApi", this.LOG_TITLE, "testConnection", SJsvlErrorCode.TEST_COMMUNICATION_ERROR.name() + " user:" + user);
                        throw new SJsvlWebApiException(SJsvlErrorCode.TEST_COMMUNICATION_ERROR, SJsvlHcsCommandStatus.CONNECTION_ERROR, ex);
                    }
                }
                catch (Throwable throwable) {
                    if (null != urlconn) {
                        SJbaseHCSAuthUtility.disconnect(urlconn);
                    }
                    throw throwable;
                }
            }
            SJbaseHCSAuthUtility.disconnect(urlconn);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "testConnection", "End.");
    }

    private synchronized boolean registHcsInfo(Map<String, Object> hcsInfo) throws SJsvlWebApiException {
        String LOG_SUBTITLE = "registHcsInfo";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "registHcsInfo", "Start.");
        boolean result = false;
        try {
            byte[] encryptedData = null;
            encryptedData = SJcSecureUty.encryptSerialize((Serializable)((Object)hcsInfo));
            SJcFileUty.saveNewBinary(SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH, "HCSInfo", encryptedData);
            result = true;
        }
        catch (SJcException sjcex) {
            STD_LOGGER.error("WebApi", this.LOG_TITLE, "registHcsInfo", SJsvlErrorCode.BINARY_FILE_SAVE_ERROR.name());
            throw new SJsvlWebApiException(SJsvlErrorCode.BINARY_FILE_SAVE_ERROR);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "registHcsInfo", "End. - file:" + SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH + SJcFileUty.sjc_PathSeparator + "HCSInfo");
        return result;
    }

    private synchronized void deleteHcsInfo() {
        String LOG_SUBTITLE = "deleteHcsInfo";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "deleteHcsInfo", "Start.");
        try {
            SJcFileUty.deleteFile(SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH, "HCSInfo");
        }
        catch (SJcException sjcex) {
            STD_LOGGER.warn("WebApi", this.LOG_TITLE, "deleteHcsInfo", SJsvlErrorCode.FILE_DELETE_ERROR.name() + "- file:" + SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH + SJcFileUty.sjc_PathSeparator + "HCSInfo", sjcex);
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "deleteHcsInfo", "End. - file:" + SJbaseHcsConst.SN_DIRECTORY_BASE_EXTAUTH + SJcFileUty.sjc_PathSeparator + "HCSInfo");
    }

    private RAIDSVPServerMessage createResponseMessage(String ip, BigInteger port, BigInteger readTimeout, SJsvlHcsCommandStatus commandStatus) {
        String LOG_SUBTITLE = "createResponseMessage REGIST";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage REGIST", "Start.");
        RAIDSVPServerMessage serverMessage = null;
        ObjectFactory factory = new ObjectFactory();
        serverMessage = factory.createRAIDSVPServerMessage();
        APIInfo apiinfo = factory.createAPIInfo();
        apiinfo.setVersion("1.0");
        Response response = factory.createResponse();
        EchoCommand command = factory.createEchoCommand();
        command.setName(COMMAND_NAME_REGIST);
        command.setStatus(commandStatus.getStatus());
        command.setResult("");
        command.setResultsource("");
        command.setMessageid("");
        ResultList resultList = factory.createResultList();
        HCSInfo hcsInfo = factory.createHCSInfo();
        hcsInfo.setIP(ip);
        hcsInfo.setPort(port);
        if (this.checkReadTimeoutSetting(readTimeout)) {
            hcsInfo.setReadTimeout(readTimeout);
        }
        resultList.setHCSInfo(hcsInfo);
        response.setEchoCommand(command);
        response.setResultList(resultList);
        serverMessage.setAPIInfo(apiinfo);
        serverMessage.setResponse(response);
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage REGIST", "End.");
        return serverMessage;
    }

    private RAIDSVPServerMessage createResponseMessage() throws SJsvlWebApiException {
        String LOG_SUBTITLE = "createResponseMessage DELETE";
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage DELETE", "Start.");
        RAIDSVPServerMessage serverMessage = null;
        ObjectFactory factory = new ObjectFactory();
        serverMessage = factory.createRAIDSVPServerMessage();
        APIInfo apiinfo = factory.createAPIInfo();
        apiinfo.setVersion("1.0");
        Response response = factory.createResponse();
        EchoCommand command = factory.createEchoCommand();
        command.setName(COMMAND_NAME_DELETE);
        command.setStatus(SJsvlHcsCommandStatus.COMPLETED.getStatus());
        command.setResult("");
        command.setResultsource("");
        command.setMessageid("");
        ResultList resultList = factory.createResultList();
        response.setEchoCommand(command);
        response.setResultList(resultList);
        serverMessage.setAPIInfo(apiinfo);
        serverMessage.setResponse(response);
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "createResponseMessage DELETE", "End.");
        return serverMessage;
    }

    private boolean rightPortRange(BigInteger port) {
        int PORT_MIN = 0;
        int PORT_MAX = 65535;
        if (port == null) {
            return false;
        }
        return port.compareTo(BigInteger.valueOf(PORT_MIN)) != -1 && port.compareTo(BigInteger.valueOf(PORT_MAX)) != 1;
    }

    private boolean checkReadTimeoutSetting(BigInteger readTimeout) {
        if (readTimeout == null) {
            return false;
        }
        return this.rightReadTimeoutRange(readTimeout);
    }

    private boolean rightReadTimeoutRange(BigInteger readTimeout) {
        String LOG_SUBTITLE = "rightReadTimeoutRange";
        if (readTimeout == null) {
            STD_LOGGER.info("WebApi", this.LOG_TITLE, "rightReadTimeoutRange", "ReadTimeout is not set");
            return false;
        }
        STD_LOGGER.info("WebApi", this.LOG_TITLE, "rightReadTimeoutRange", "Set ReadTimeout=[" + readTimeout.toString() + "]");
        return readTimeout.compareTo(BigInteger.valueOf(1L)) != -1 && readTimeout.compareTo(BigInteger.valueOf(600000L)) != 1;
    }
}

