/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.tools;

import java.io.File;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.fileuty.SJcFileOnDisk;

public class SetExAuthFileUty {
    public static boolean isExistFile(String path) {
        SJcFileOnDisk sFile = new SJcFileOnDisk(path);
        return sFile.exists();
    }

    public static void deleteFile(String path) throws Exception {
        SJcFileOnDisk sFile = new SJcFileOnDisk(path);
        if (!sFile.delete()) {
            throw new Exception();
        }
    }

    public static void encryptFile(String sourceFile, String destinationFile) throws Exception {
        byte[] data = SetExAuthFileUty.loadBinary(sourceFile);
        byte[] encData = SetExAuthFileUty.encryptByte(data);
        SetExAuthFileUty.saveBinary(destinationFile, encData);
    }

    public static String concatFilePath(String dir, String file) throws Exception {
        if (dir == null || file == null) {
            throw new Exception();
        }
        String path = dir;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        path = path + file;
        return path;
    }

    private static byte[] loadBinary(String file) throws Exception {
        if (file == null) {
            throw new Exception();
        }
        SJcFileOnDisk sFile = new SJcFileOnDisk(file);
        long size = sFile.getLength();
        byte[] data = sFile.readBytes(0, (int)size);
        return data;
    }

    private static void saveBinary(String file, byte[] data) throws Exception {
        if (file == null || data == null) {
            throw new Exception();
        }
        SJcFileOnDisk sFile = new SJcFileOnDisk(file);
        if (sFile.exists()) {
            sFile.delete();
        }
        sFile.writeBytes(data, 0);
    }

    private static byte[] encryptByte(byte[] byteData) throws Exception {
        if (byteData == null) {
            throw new Exception();
        }
        byte[] ret = SJcSecureUty.encryptByteNoLog(byteData);
        return ret;
    }
}

