/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl;

import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.snctrl.SJsnctrlSnWebAppController;
import sanproject.snctrl.com.SJsnctrlSnConst;
import sanproject.snctrl.thread.SJsnctrlStopProcessFinishThrerad;
import sanproject.snctrl.utility.SJsnctrlProcessLockUtility;

public class SJsnctrlStopProcessMain {
    private static final String LOG_FUNCTION = "JettyStop";
    private static final String LOG_TITLE = SJsnctrlStopProcessMain.class.getSimpleName();
    private static SJcLoggerInterface STD_LOGGER = null;
    private static String mappInstPath = null;
    private static String dkcPath = null;
    private static String stopLockPath = null;
    private static String multiLockPath = null;
    private static SJsnctrlProcessLockUtility stopUty = null;
    private static SJsnctrlProcessLockUtility multiUty = null;
    private static SJbaseSystemPropertiesManager sysPropMgr = null;
    private static Thread stopWatchThread = null;

    public static void main(String[] args) {
        String LOG_SUBTITLE = "main";
        if (!SJsnctrlStopProcessMain.initEx()) {
            return;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "main", "Start.");
        try {
            stopUty = new SJsnctrlProcessLockUtility(stopLockPath);
            stopUty.getLock();
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "main", "Exception in stopUty.", (Throwable)ex);
            return;
        }
        stopWatchThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String LOG_THREAD_TITLE = "stopWatchThread";
                try {
                    Thread thread = stopWatchThread;
                    synchronized (thread) {
                        STD_LOGGER.info(SJsnctrlStopProcessMain.LOG_FUNCTION, LOG_TITLE, "stopWatchThread", "Start.");
                        stopWatchThread.wait();
                        STD_LOGGER.info(SJsnctrlStopProcessMain.LOG_FUNCTION, LOG_TITLE, "stopWatchThread", "End.");
                    }
                }
                catch (InterruptedException ex) {
                    STD_LOGGER.warn(SJsnctrlStopProcessMain.LOG_FUNCTION, LOG_TITLE, "stopWatchThread", "InterruptedException.");
                }
            }
        };
        stopWatchThread.start();
        try {
            SJsnctrlStopProcessFinishThrerad snStopTh = new SJsnctrlStopProcessFinishThrerad(stopUty, multiUty, stopWatchThread);
            Runtime.getRuntime().addShutdownHook(snStopTh);
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "main", "Stand by ShutdownHook().");
            stopWatchThread.join();
        }
        catch (InterruptedException e) {
            STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "main", "Join Interrupted.");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "main", "End.");
    }

    private static boolean initEx() {
        String LOG_SUBTITLE = "initEx";
        if (!SJsnctrlStopProcessMain.init()) {
            return false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "initEx", "Start.");
        stopLockPath = dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_STOPFILE) + "STOPLOCKFILE";
        multiLockPath = dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_STOPFILE) + "STOPMULTIFILE";
        try {
            multiUty = new SJsnctrlProcessLockUtility(multiLockPath);
            if (!multiUty.tryLock()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initEx", "File lock get failed (" + multiLockPath + ")");
                return false;
            }
        }
        catch (Exception e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "initEx", "Exception in multiUty.", (Throwable)e);
            return false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "initEx", "End.");
        return true;
    }

    private static boolean init() {
        String LOG_SUBTITLE = "init";
        boolean result = true;
        String wk_userdir = SJsnctrlSnWebAppController.endsWithFileSeparator(System.getProperty("user.dir"));
        dkcPath = SJsnctrlSnWebAppController.getMoveUpPathNoLogging(wk_userdir, 3);
        if ("".equals(dkcPath)) {
            return false;
        }
        mappInstPath = SJsnctrlSnWebAppController.getMoveUpPathNoLogging(wk_userdir, 5);
        if ("".equals(mappInstPath)) {
            return false;
        }
        SJsnctrlStopProcessMain.initProperty();
        STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "Start.");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "mappInstPath is (" + mappInstPath + ")");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "dkcPath is (" + dkcPath + ")");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "init", "End.");
        return result;
    }

    private static void initProperty() {
        if (System.getProperty("SN_DataPath") == null) {
            System.setProperty("SN_DataPath", dkcPath + SJsnctrlSnConst.SJ_DIR_NAME_SN2_DATA);
        }
        if (System.getProperty("SN_EnvFile") == null) {
            System.setProperty("SN_EnvFile", dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_ENVFILE) + "SN2_Startup.properties");
        }
        if (System.getProperty("SN_EnvFileV") == null) {
            System.setProperty("SN_EnvFileV", dkcPath + SJsnctrlSnWebAppController.endsWithFileSeparator(SJsnctrlSnConst.SJ_DIR_NAME_SN2_ENVFILE) + "SN2_StartupV.properties");
        }
        if (System.getProperty("SN_LogPath") == null) {
            System.setProperty("SN_LogPath", "webappstop");
        }
        sysPropMgr = new SJbaseSystemPropertiesManager();
        sysPropMgr.initialize(0);
    }
}

