/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.com.utility;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJcSleepUty {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJcSleepUty.class.getSimpleName();
    private static SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();

    public static boolean sleepSchedule(long delay) {
        String LOG_SUBTITLE = "sleepSchedule";
        boolean result = true;
        boolean awaitTerminated = false;
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "sleepSchedule", "start.");
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(new Runnable(){

            public void run() {
            }
        }, delay, TimeUnit.MILLISECONDS);
        scheduler.shutdown();
        long awaitTime = delay + 1000L;
        try {
            awaitTerminated = scheduler.awaitTermination(awaitTime, TimeUnit.MILLISECONDS);
            if (!awaitTerminated) {
                List<Runnable> notExecutedTaskList = scheduler.shutdownNow();
                SJcSleepUty.dispNotExecutedTaskList(notExecutedTaskList);
                result = false;
            }
        }
        catch (InterruptedException e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "sleepSchedule", "InterruptedException", (Throwable)e);
            List<Runnable> notExecutedTaskList = scheduler.shutdownNow();
            SJcSleepUty.dispNotExecutedTaskList(notExecutedTaskList);
            result = false;
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "sleepSchedule", "end.");
        return result;
    }

    private static void dispNotExecutedTaskList(List<Runnable> notExecutedTaskList) {
        String LOG_SUBTITLE = "dispNotExecutedTaskList";
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "dispNotExecutedTaskList", "start.");
        if (notExecutedTaskList.isEmpty()) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "dispNotExecutedTaskList", "dispNotExecutedTaskList() List is empty.");
        } else {
            for (Runnable runnable : notExecutedTaskList) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "dispNotExecutedTaskList", "runnable: " + runnable.toString());
            }
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "dispNotExecutedTaskList", "end.");
    }
}

